/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import org.apache.http.protocol.UriPatternMatcher;
import org.junit.Assert;
import org.junit.Test;

public class TestUriPatternMatcher {
    @Test
    public void testEntrySet() throws Exception {
        Object h1 = new Object();
        Object h2 = new Object();
        Object h3 = new Object();
        UriPatternMatcher matcher = new UriPatternMatcher();
        Assert.assertEquals((long)0L, (long)matcher.entrySet().size());
        matcher.register("/h1", h1);
        Assert.assertEquals((long)1L, (long)matcher.entrySet().size());
        matcher.register("/h2", h2);
        Assert.assertEquals((long)2L, (long)matcher.entrySet().size());
        matcher.register("/h3", h3);
        Assert.assertEquals((long)3L, (long)matcher.entrySet().size());
    }

    @Test
    public void testRegisterUnregister() throws Exception {
        Object h1 = new Object();
        Object h2 = new Object();
        Object h3 = new Object();
        UriPatternMatcher matcher = new UriPatternMatcher();
        matcher.register("/h1", h1);
        matcher.register("/h2", h2);
        matcher.register("/h3", h3);
        Object h = matcher.lookup("/h1");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h1 == h ? 1 : 0) != 0);
        h = matcher.lookup("/h2");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h2 == h ? 1 : 0) != 0);
        h = matcher.lookup("/h3");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h3 == h ? 1 : 0) != 0);
        matcher.unregister("/h1");
        h = matcher.lookup("/h1");
        Assert.assertNull((Object)h);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterNull() throws Exception {
        UriPatternMatcher matcher = new UriPatternMatcher();
        matcher.register(null, null);
    }

    @Test
    public void testWildCardMatching1() throws Exception {
        Object h1 = new Object();
        Object h2 = new Object();
        Object h3 = new Object();
        Object def = new Object();
        UriPatternMatcher matcher = new UriPatternMatcher();
        matcher.register("*", def);
        matcher.register("/one/*", h1);
        matcher.register("/one/two/*", h2);
        matcher.register("/one/two/three/*", h3);
        Object h = matcher.lookup("/one/request");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h1 == h ? 1 : 0) != 0);
        h = matcher.lookup("/one/two/request");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h2 == h ? 1 : 0) != 0);
        h = matcher.lookup("/one/two/three/request");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h3 == h ? 1 : 0) != 0);
        h = matcher.lookup("default/request");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((def == h ? 1 : 0) != 0);
    }

    @Test
    public void testWildCardMatching2() throws Exception {
        Object h1 = new Object();
        Object h2 = new Object();
        Object def = new Object();
        UriPatternMatcher matcher = new UriPatternMatcher();
        matcher.register("*", def);
        matcher.register("*.view", h1);
        matcher.register("*.form", h2);
        Object h = matcher.lookup("/that.view");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h1 == h ? 1 : 0) != 0);
        h = matcher.lookup("/that.form");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h2 == h ? 1 : 0) != 0);
        h = matcher.lookup("/whatever");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((def == h ? 1 : 0) != 0);
    }

    @Test
    public void testSuffixPatternOverPrefixPatternMatch() throws Exception {
        Object h1 = new Object();
        Object h2 = new Object();
        UriPatternMatcher matcher = new UriPatternMatcher();
        matcher.register("/ma*", h1);
        matcher.register("*tch", h2);
        Object h = matcher.lookup("/match");
        Assert.assertNotNull((Object)h);
        Assert.assertTrue((h1 == h ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterInvalidInput() throws Exception {
        UriPatternMatcher matcher = new UriPatternMatcher();
        matcher.register(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLookupInvalidInput() throws Exception {
        UriPatternMatcher matcher = new UriPatternMatcher();
        matcher.lookup(null);
    }
}

