/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestSSLContextBuilder {
    private static final String PROVIDER_SUN_JSSE = "SunJSSE";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final int TIMEOUT = 5000;
    private ExecutorService executorService;

    private static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    @After
    public void cleanup() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    private URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    @Test
    public void testBuildDefault() throws Exception {
        new SSLContextBuilder().build();
    }

    @Test
    public void testBuildAllNull() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().setKeyStoreType(null).setKeyManagerFactoryAlgorithm(null).setTrustManagerFactoryAlgorithm(null).setProtocol(null).setProvider((String)null).setSecureRandom(null).loadTrustMaterial((KeyStore)null, null).loadKeyMaterial((KeyStore)null, null, null).build();
        Assert.assertNotNull((Object)sslContext);
        Assert.assertEquals((Object)"TLS", (Object)sslContext.getProtocol());
        Assert.assertEquals((Object)PROVIDER_SUN_JSSE, (Object)sslContext.getProvider().getName());
    }

    @Test
    public void testBuildAllDefaults() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().setKeyStoreType(KeyStore.getDefaultType()).setKeyManagerFactoryAlgorithm(KeyManagerFactory.getDefaultAlgorithm()).setTrustManagerFactoryAlgorithm(TrustManagerFactory.getDefaultAlgorithm()).setProvider(PROVIDER_SUN_JSSE).setProtocol("TLS").setSecureRandom(null).loadTrustMaterial((KeyStore)null, null).loadKeyMaterial((KeyStore)null, null, null).build();
        Assert.assertNotNull((Object)sslContext);
        Assert.assertEquals((Object)"TLS", (Object)sslContext.getProtocol());
        Assert.assertEquals((Object)PROVIDER_SUN_JSSE, (Object)sslContext.getProvider().getName());
    }

    @Test
    public void testBuildNoSuchKeyStoreType() throws Exception {
        this.thrown.expect(KeyStoreException.class);
        URL resource1 = this.getResource("/test-keypasswd.keystore");
        String storePassword = "nopassword";
        String keyPassword = "password";
        SSLContextBuilder.create().setKeyStoreType(" BAD ").loadKeyMaterial(resource1, "nopassword".toCharArray(), "password".toCharArray()).build();
    }

    @Test
    public void testBuildNoSuchKeyManagerFactoryAlgorithm() throws Exception {
        this.thrown.expect(NoSuchAlgorithmException.class);
        URL resource1 = this.getResource("/test-keypasswd.keystore");
        String storePassword = "nopassword";
        String keyPassword = "password";
        SSLContextBuilder.create().setKeyManagerFactoryAlgorithm(" BAD ").loadKeyMaterial(resource1, "nopassword".toCharArray(), "password".toCharArray()).build();
    }

    @Test
    public void testBuildNoSuchTrustManagerFactoryAlgorithm() throws Exception {
        this.thrown.expect(NoSuchAlgorithmException.class);
        URL resource1 = this.getResource("/test-keypasswd.keystore");
        String storePassword = "nopassword";
        SSLContextBuilder.create().setTrustManagerFactoryAlgorithm(" BAD ").loadTrustMaterial(resource1, "nopassword".toCharArray()).build();
    }

    @Test
    public void testBuildAllNull_deprecated() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().useProtocol(null).setSecureRandom(null).loadTrustMaterial((KeyStore)null, null).loadKeyMaterial((KeyStore)null, null, null).build();
        Assert.assertNotNull((Object)sslContext);
        Assert.assertEquals((Object)"TLS", (Object)sslContext.getProtocol());
    }

    @Test
    public void testKeyWithAlternatePassword() throws Exception {
        URL resource1 = this.getResource("/test-keypasswd.keystore");
        String storePassword = "nopassword";
        String keyPassword = "password";
        SSLContext sslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "password".toCharArray()).loadTrustMaterial(resource1, "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)sslContext);
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        Assert.assertNotNull((Object)socketFactory);
    }

    @Test
    public void testKeyWithAlternatePasswordInvalid() throws Exception {
        this.thrown.expect(UnrecoverableKeyException.class);
        URL resource1 = this.getResource("/test-keypasswd.keystore");
        String storePassword = "nopassword";
        String keyPassword = "!password";
        SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "!password".toCharArray()).loadTrustMaterial(resource1, "nopassword".toCharArray()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeServerTrusted() throws Exception {
        URL resource1 = this.getResource("/test.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource1, "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)clientSslContext);
        final ServerSocket serverSocket = serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Boolean> future = this.executorService.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Socket socket = serverSocket.accept();
                try {
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(new byte[]{72, 105});
                    outputStream.flush();
                }
                finally {
                    socket.close();
                }
                return Boolean.TRUE;
            }
        });
        int localPort = serverSocket.getLocalPort();
        Socket clientSocket = clientSslContext.getSocketFactory().createSocket();
        try {
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            InputStream inputStream = clientSocket.getInputStream();
            Assert.assertEquals((long)72L, (long)inputStream.read());
            Assert.assertEquals((long)105L, (long)inputStream.read());
            Assert.assertEquals((long)-1L, (long)inputStream.read());
        }
        finally {
            clientSocket.close();
        }
        Boolean result = future.get(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeServerNotTrusted() throws Exception {
        this.thrown.expect(IOException.class);
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test.keystore");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)clientSslContext);
        final ServerSocket serverSocket = serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                SSLSocket socket = (SSLSocket)serverSocket.accept();
                try {
                    socket.getSession();
                }
                finally {
                    socket.close();
                }
                return Boolean.FALSE;
            }
        });
        int localPort = serverSocket.getLocalPort();
        SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        try {
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            clientSocket.setSoTimeout(5000);
            clientSocket.startHandshake();
        }
        finally {
            clientSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeServerCustomTrustStrategy() throws Exception {
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        final AtomicReference certChainRef = new AtomicReference();
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                certChainRef.set(chain);
                return true;
            }
        };
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(trustStrategy).build();
        Assert.assertNotNull((Object)clientSslContext);
        final ServerSocket serverSocket = serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Boolean> future = this.executorService.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Socket socket = serverSocket.accept();
                try {
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(new byte[]{72, 105});
                    outputStream.flush();
                }
                finally {
                    socket.close();
                }
                return Boolean.TRUE;
            }
        });
        int localPort = serverSocket.getLocalPort();
        SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        try {
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            clientSocket.setSoTimeout(5000);
            InputStream inputStream = clientSocket.getInputStream();
            Assert.assertEquals((long)72L, (long)inputStream.read());
            Assert.assertEquals((long)105L, (long)inputStream.read());
            Assert.assertEquals((long)-1L, (long)inputStream.read());
        }
        finally {
            clientSocket.close();
        }
        Boolean result = future.get(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)result);
        X509Certificate[] certs = (X509Certificate[])certChainRef.get();
        Assert.assertNotNull((Object)certs);
        Assert.assertEquals((long)2L, (long)certs.length);
        X509Certificate cert1 = certs[0];
        Principal subjectDN1 = cert1.getSubjectDN();
        Assert.assertNotNull((Object)subjectDN1);
        Assert.assertEquals((Object)"CN=Test Server, OU=HttpComponents Project, O=Apache Software Foundation", (Object)subjectDN1.getName());
        X509Certificate cert2 = certs[1];
        Principal subjectDN2 = cert2.getSubjectDN();
        Assert.assertNotNull((Object)subjectDN2);
        Assert.assertEquals((Object)"EMAILADDRESS=dev@hc.apache.org, CN=Test CA, OU=HttpComponents Project, O=Apache Software Foundation", (Object)subjectDN2.getName());
        Principal issuerDN = cert2.getIssuerDN();
        Assert.assertNotNull((Object)issuerDN);
        Assert.assertEquals((Object)"EMAILADDRESS=dev@hc.apache.org, CN=Test CA, OU=HttpComponents Project, O=Apache Software Foundation", (Object)issuerDN.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeClientUnauthenticated() throws Exception {
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.keystore");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)clientSslContext);
        final SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.setWantClientAuth(true);
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Principal> future = this.executorService.submit(new Callable<Principal>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Principal call() throws Exception {
                SSLSocket socket = (SSLSocket)serverSocket.accept();
                Principal clientPrincipal = null;
                try {
                    SSLSession session = socket.getSession();
                    try {
                        clientPrincipal = session.getPeerPrincipal();
                    }
                    catch (SSLPeerUnverifiedException ignore) {
                        // empty catch block
                    }
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(new byte[]{72, 105});
                    outputStream.flush();
                }
                finally {
                    socket.close();
                }
                return clientPrincipal;
            }
        });
        int localPort = serverSocket.getLocalPort();
        SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        try {
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            clientSocket.setSoTimeout(5000);
            clientSocket.startHandshake();
            InputStream inputStream = clientSocket.getInputStream();
            Assert.assertEquals((long)72L, (long)inputStream.read());
            Assert.assertEquals((long)105L, (long)inputStream.read());
            Assert.assertEquals((long)-1L, (long)inputStream.read());
        }
        finally {
            clientSocket.close();
        }
        Principal clientPrincipal = future.get(5L, TimeUnit.SECONDS);
        Assert.assertNull((Object)clientPrincipal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeClientUnauthenticatedError() throws Exception {
        this.thrown.expect(IOException.class);
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.keystore");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)clientSslContext);
        final SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.setNeedClientAuth(true);
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                SSLSocket socket = (SSLSocket)serverSocket.accept();
                try {
                    socket.getSession();
                }
                finally {
                    socket.close();
                }
                return Boolean.FALSE;
            }
        });
        int localPort = serverSocket.getLocalPort();
        SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        try {
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            clientSocket.setSoTimeout(5000);
            clientSocket.startHandshake();
            InputStream inputStream = clientSocket.getInputStream();
            Assert.assertEquals((long)-1L, (long)inputStream.read());
        }
        finally {
            clientSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeClientAuthenticated() throws Exception {
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadTrustMaterial(resource1, "nopassword".toCharArray()).loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.keystore");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).loadKeyMaterial(resource2, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)clientSslContext);
        final SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.setNeedClientAuth(true);
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Principal> future = this.executorService.submit(new Callable<Principal>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Principal call() throws Exception {
                SSLSocket socket = (SSLSocket)serverSocket.accept();
                try {
                    SSLSession session = socket.getSession();
                    Principal clientPrincipal = session.getPeerPrincipal();
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(new byte[]{72, 105});
                    outputStream.flush();
                    Principal principal = clientPrincipal;
                    return principal;
                }
                finally {
                    socket.close();
                }
            }
        });
        int localPort = serverSocket.getLocalPort();
        SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        try {
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            clientSocket.setSoTimeout(5000);
            clientSocket.startHandshake();
            InputStream inputStream = clientSocket.getInputStream();
            Assert.assertEquals((long)72L, (long)inputStream.read());
            Assert.assertEquals((long)105L, (long)inputStream.read());
            Assert.assertEquals((long)-1L, (long)inputStream.read());
        }
        finally {
            clientSocket.close();
        }
        Principal clientPrincipal = future.get(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)clientPrincipal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeClientAuthenticatedPrivateKeyStrategy() throws Exception {
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadTrustMaterial(resource1, "nopassword".toCharArray()).loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        PrivateKeyStrategy privateKeyStrategy = new PrivateKeyStrategy(){

            public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
                return aliases.containsKey("client2") ? "client2" : null;
            }
        };
        URL resource2 = this.getResource("/test-client.keystore");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).loadKeyMaterial(resource2, "nopassword".toCharArray(), "nopassword".toCharArray(), privateKeyStrategy).build();
        Assert.assertNotNull((Object)clientSslContext);
        final SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.setNeedClientAuth(true);
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Principal> future = this.executorService.submit(new Callable<Principal>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Principal call() throws Exception {
                SSLSocket socket = (SSLSocket)serverSocket.accept();
                try {
                    SSLSession session = socket.getSession();
                    Principal clientPrincipal = session.getPeerPrincipal();
                    OutputStream outputStream = socket.getOutputStream();
                    outputStream.write(new byte[]{72, 105});
                    outputStream.flush();
                    Principal principal = clientPrincipal;
                    return principal;
                }
                finally {
                    socket.close();
                }
            }
        });
        int localPort = serverSocket.getLocalPort();
        SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        try {
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            clientSocket.setSoTimeout(5000);
            clientSocket.startHandshake();
            InputStream inputStream = clientSocket.getInputStream();
            Assert.assertEquals((long)72L, (long)inputStream.read());
            Assert.assertEquals((long)105L, (long)inputStream.read());
            Assert.assertEquals((long)-1L, (long)inputStream.read());
        }
        finally {
            clientSocket.close();
        }
        Principal clientPrincipal = future.get(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)clientPrincipal);
        Assert.assertEquals((Object)"CN=Test Client 2,OU=HttpComponents Project,O=Apache Software Foundation", (Object)clientPrincipal.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeProtocolMismatch1() throws Exception {
        if (TestSSLContextBuilder.isWindows()) {
            this.thrown.expect(IOException.class);
        } else {
            this.thrown.expect(SSLHandshakeException.class);
        }
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.keystore");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)clientSslContext);
        final SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        LinkedHashSet<String> supportedServerProtocols = new LinkedHashSet<String>(Arrays.asList(serverSocket.getSupportedProtocols()));
        Assert.assertTrue((boolean)supportedServerProtocols.contains("TLSv1"));
        serverSocket.setEnabledProtocols(new String[]{"TLSv1"});
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                SSLSocket socket = (SSLSocket)serverSocket.accept();
                try {
                    socket.getSession();
                }
                finally {
                    socket.close();
                }
                return Boolean.FALSE;
            }
        });
        int localPort = serverSocket.getLocalPort();
        SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        try {
            LinkedHashSet<String> supportedClientProtocols = new LinkedHashSet<String>(Arrays.asList(clientSocket.getSupportedProtocols()));
            Assert.assertTrue((boolean)supportedClientProtocols.contains("SSLv3"));
            clientSocket.setEnabledProtocols(new String[]{"SSLv3"});
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            clientSocket.setSoTimeout(5000);
            clientSocket.startHandshake();
        }
        finally {
            clientSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLHandshakeProtocolMismatch2() throws Exception {
        if (TestSSLContextBuilder.isWindows()) {
            this.thrown.expect(IOException.class);
        } else {
            this.thrown.expect(SSLException.class);
        }
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.keystore");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assert.assertNotNull((Object)clientSslContext);
        final SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        LinkedHashSet<String> supportedServerProtocols = new LinkedHashSet<String>(Arrays.asList(serverSocket.getSupportedProtocols()));
        Assert.assertTrue((boolean)supportedServerProtocols.contains("SSLv3"));
        serverSocket.setEnabledProtocols(new String[]{"SSLv3"});
        serverSocket.bind(new InetSocketAddress("localhost", 0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                SSLSocket socket = (SSLSocket)serverSocket.accept();
                try {
                    socket.getSession();
                }
                finally {
                    socket.close();
                }
                return Boolean.FALSE;
            }
        });
        int localPort = serverSocket.getLocalPort();
        SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();
        try {
            LinkedHashSet<String> supportedClientProtocols = new LinkedHashSet<String>(Arrays.asList(clientSocket.getSupportedProtocols()));
            Assert.assertTrue((boolean)supportedClientProtocols.contains("TLSv1"));
            clientSocket.setEnabledProtocols(new String[]{"TLSv1"});
            clientSocket.connect(new InetSocketAddress("localhost", localPort), 5000);
            clientSocket.setSoTimeout(5000);
            clientSocket.startHandshake();
        }
        finally {
            clientSocket.close();
        }
    }

    @Test
    public void testBuildWithProvider() throws Exception {
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext sslContext = SSLContextBuilder.create().setProvider(Security.getProvider(PROVIDER_SUN_JSSE)).loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertEquals((Object)PROVIDER_SUN_JSSE, (Object)sslContext.getProvider().getName());
    }

    @Test
    public void testBuildWithProviderName() throws Exception {
        URL resource1 = this.getResource("/test-server.keystore");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext sslContext = SSLContextBuilder.create().setProvider(PROVIDER_SUN_JSSE).loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assert.assertEquals((Object)PROVIDER_SUN_JSSE, (Object)sslContext.getProvider().getName());
    }
}

