/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.testserver;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ExceptionLogger;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.apache.http.testserver.LoggingBHttpServerConnection;
import org.apache.http.util.Asserts;

public class HttpServer {
    private final UriHttpRequestHandlerMapper reqistry = new UriHttpRequestHandlerMapper();
    private volatile HttpExpectationVerifier expectationVerifier;
    private volatile int timeout;
    private volatile org.apache.http.impl.bootstrap.HttpServer server;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void registerHandler(String pattern, HttpRequestHandler handler) {
        this.reqistry.register(pattern, handler);
    }

    public void setExpectationVerifier(HttpExpectationVerifier expectationVerifier) {
        this.expectationVerifier = expectationVerifier;
    }

    public int getPort() {
        org.apache.http.impl.bootstrap.HttpServer local = this.server;
        if (local != null) {
            return this.server.getLocalPort();
        }
        throw new IllegalStateException("Server not running");
    }

    public InetAddress getInetAddress() {
        org.apache.http.impl.bootstrap.HttpServer local = this.server;
        if (local != null) {
            return local.getInetAddress();
        }
        throw new IllegalStateException("Server not running");
    }

    public void start() throws IOException {
        Asserts.check((this.server == null ? 1 : 0) != 0, (String)"Server already running");
        this.server = ServerBootstrap.bootstrap().setSocketConfig(SocketConfig.custom().setSoTimeout(this.timeout).build()).setServerInfo("TEST-SERVER/1.1").setConnectionFactory((HttpConnectionFactory)new LoggingConnFactory()).setExceptionLogger((ExceptionLogger)new SimpleExceptionLogger()).setExpectationVerifier(this.expectationVerifier).setHandlerMapper((HttpRequestHandlerMapper)this.reqistry).create();
        this.server.start();
    }

    public void shutdown() {
        org.apache.http.impl.bootstrap.HttpServer local = this.server;
        this.server = null;
        if (local != null) {
            local.shutdown(5L, TimeUnit.SECONDS);
        }
    }

    static class SimpleExceptionLogger
    implements ExceptionLogger {
        private final Log log = LogFactory.getLog(HttpServer.class);

        SimpleExceptionLogger() {
        }

        public void log(Exception ex) {
            if (ex instanceof ConnectionClosedException) {
                this.log.debug((Object)ex.getMessage());
            } else if (ex instanceof SocketException) {
                this.log.debug((Object)ex.getMessage());
            } else {
                this.log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    static class LoggingConnFactory
    implements HttpConnectionFactory<LoggingBHttpServerConnection> {
        LoggingConnFactory() {
        }

        public LoggingBHttpServerConnection createConnection(Socket socket) throws IOException {
            LoggingBHttpServerConnection conn = new LoggingBHttpServerConnection(8192);
            conn.bind(socket);
            return conn;
        }
    }
}

