/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.testserver;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.testserver.Wire;

class LoggingInputStream
extends InputStream {
    private final InputStream in;
    private final Wire wire;

    public LoggingInputStream(InputStream in, Wire wire) {
        this.in = in;
        this.wire = wire;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.wire.input(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = this.in.read(b);
        if (bytesRead != -1) {
            this.wire.input(b, 0, bytesRead);
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead != -1) {
            this.wire.input(b, off, bytesRead);
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

