/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.Consts;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestCharArrayBuffer {
    @Test
    public void testConstructor() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        Assert.assertNotNull((Object)buffer.buffer());
        Assert.assertEquals((long)16L, (long)buffer.buffer().length);
        try {
            new CharArrayBuffer(-1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleAppend() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        char[] b1 = buffer.toCharArray();
        Assert.assertNotNull((Object)b1);
        Assert.assertEquals((long)0L, (long)b1.length);
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        char[] tmp = new char[]{'1', '2', '3', '4'};
        buffer.append(tmp, 0, tmp.length);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)4L, (long)buffer.length());
        Assert.assertFalse((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
        char[] b2 = buffer.toCharArray();
        Assert.assertNotNull((Object)b2);
        Assert.assertEquals((long)4L, (long)b2.length);
        for (int i = 0; i < tmp.length; ++i) {
            Assert.assertEquals((long)tmp[i], (long)b2[i]);
            Assert.assertEquals((long)tmp[i], (long)buffer.charAt(i));
        }
        Assert.assertEquals((Object)"1234", (Object)buffer.toString());
        buffer.clear();
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)0L, (long)buffer.length());
        Assert.assertTrue((boolean)buffer.isEmpty());
        Assert.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testExpandAppend() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        Assert.assertEquals((long)4L, (long)buffer.capacity());
        char[] tmp = new char[]{'1', '2', '3', '4'};
        buffer.append(tmp, 0, 2);
        buffer.append(tmp, 0, 4);
        buffer.append(tmp, 0, 0);
        Assert.assertEquals((long)8L, (long)buffer.capacity());
        Assert.assertEquals((long)6L, (long)buffer.length());
        buffer.append(tmp, 0, 4);
        Assert.assertEquals((long)16L, (long)buffer.capacity());
        Assert.assertEquals((long)10L, (long)buffer.length());
        Assert.assertEquals((Object)"1212341234", (Object)buffer.toString());
    }

    @Test
    public void testAppendString() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append("stuff");
        buffer.append(" and more stuff");
        Assert.assertEquals((Object)"stuff and more stuff", (Object)buffer.toString());
    }

    @Test
    public void testAppendNullString() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append((String)null);
        Assert.assertEquals((Object)"null", (Object)buffer.toString());
    }

    @Test
    public void testAppendCharArrayBuffer() throws Exception {
        CharArrayBuffer buffer1 = new CharArrayBuffer(8);
        buffer1.append(" and more stuff");
        CharArrayBuffer buffer2 = new CharArrayBuffer(8);
        buffer2.append("stuff");
        buffer2.append(buffer1);
        Assert.assertEquals((Object)"stuff and more stuff", (Object)buffer2.toString());
    }

    @Test
    public void testAppendNullCharArrayBuffer() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append((CharArrayBuffer)null);
        buffer.append((CharArrayBuffer)null, 0, 0);
        Assert.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testAppendSingleChar() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.append('1');
        buffer.append('2');
        buffer.append('3');
        buffer.append('4');
        buffer.append('5');
        buffer.append('6');
        Assert.assertEquals((Object)"123456", (Object)buffer.toString());
    }

    @Test
    public void testInvalidCharArrayAppend() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.append((char[])null, 0, 0);
        char[] tmp = new char[]{'1', '2', '3', '4'};
        try {
            buffer.append(tmp, -1, 0);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, 8);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 10, Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 2, 4);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSetLength() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.setLength(2);
        Assert.assertEquals((long)2L, (long)buffer.length());
    }

    @Test
    public void testSetInvalidLength() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        try {
            buffer.setLength(-2);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.setLength(200);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testEnsureCapacity() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.ensureCapacity(2);
        Assert.assertEquals((long)4L, (long)buffer.capacity());
        buffer.ensureCapacity(8);
        Assert.assertEquals((long)8L, (long)buffer.capacity());
    }

    @Test
    public void testIndexOf() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("name: value");
        Assert.assertEquals((long)4L, (long)buffer.indexOf(58));
        Assert.assertEquals((long)-1L, (long)buffer.indexOf(44));
        Assert.assertEquals((long)4L, (long)buffer.indexOf(58, -1, 11));
        Assert.assertEquals((long)4L, (long)buffer.indexOf(58, 0, 1000));
        Assert.assertEquals((long)-1L, (long)buffer.indexOf(58, 2, 1));
    }

    @Test
    public void testSubstring() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(" name:  value    ");
        Assert.assertEquals((long)5L, (long)buffer.indexOf(58));
        Assert.assertEquals((Object)" name", (Object)buffer.substring(0, 5));
        Assert.assertEquals((Object)"  value    ", (Object)buffer.substring(6, buffer.length()));
        Assert.assertEquals((Object)"name", (Object)buffer.substringTrimmed(0, 5));
        Assert.assertEquals((Object)"value", (Object)buffer.substringTrimmed(6, buffer.length()));
        Assert.assertEquals((Object)"", (Object)buffer.substringTrimmed(13, buffer.length()));
    }

    @Test
    public void testSubstringIndexOfOutBound() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("stuff");
        try {
            buffer.substring(-2, 10);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.substringTrimmed(-2, 10);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.substring(12, 10);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.substringTrimmed(12, 10);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.substring(2, 1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.substringTrimmed(2, 1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testAppendAsciiByteArray() throws Exception {
        String s1 = "stuff";
        String s2 = " and more stuff";
        byte[] b1 = "stuff".getBytes(Consts.ASCII);
        byte[] b2 = " and more stuff".getBytes(Consts.ASCII);
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append(b1, 0, b1.length);
        buffer.append(b2, 0, b2.length);
        Assert.assertEquals((Object)"stuff and more stuff", (Object)buffer.toString());
    }

    @Test
    public void testAppendISOByteArray() throws Exception {
        byte[] b = new byte[]{0, 32, 127, -128, -1};
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append(b, 0, b.length);
        char[] ch = buffer.toCharArray();
        Assert.assertNotNull((Object)ch);
        Assert.assertEquals((long)5L, (long)ch.length);
        Assert.assertEquals((long)0L, (long)ch[0]);
        Assert.assertEquals((long)32L, (long)ch[1]);
        Assert.assertEquals((long)127L, (long)ch[2]);
        Assert.assertEquals((long)128L, (long)ch[3]);
        Assert.assertEquals((long)255L, (long)ch[4]);
    }

    @Test
    public void testAppendNullByteArray() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append((byte[])null, 0, 0);
        Assert.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testAppendNullByteArrayBuffer() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(8);
        buffer.append((ByteArrayBuffer)null, 0, 0);
        Assert.assertEquals((Object)"", (Object)buffer.toString());
    }

    @Test
    public void testInvalidAppendAsciiByteArray() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(4);
        buffer.append((byte[])null, 0, 0);
        byte[] tmp = new byte[]{49, 50, 51, 52};
        try {
            buffer.append(tmp, -1, 0);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, 8);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 10, Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 2, 4);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSerialization() throws Exception {
        CharArrayBuffer orig = new CharArrayBuffer(32);
        orig.append('a');
        orig.append('b');
        orig.append('c');
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        CharArrayBuffer clone = (CharArrayBuffer)inStream.readObject();
        Assert.assertEquals((long)orig.capacity(), (long)clone.capacity());
        Assert.assertEquals((long)orig.length(), (long)clone.length());
        char[] data = clone.toCharArray();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)3L, (long)data.length);
        Assert.assertEquals((long)97L, (long)data[0]);
        Assert.assertEquals((long)98L, (long)data[1]);
        Assert.assertEquals((long)99L, (long)data[2]);
    }

    @Test
    public void testSubSequenceIndexOfOutBound() {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("stuff");
        try {
            buffer.subSequence(-2, 10);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.subSequence(12, 10);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.subSequence(2, 1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }
}

