/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import org.apache.http.util.LangUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLangUtils {
    @Test
    public void testBasicHash() {
        int h2;
        Integer i = new Integer(1234);
        int h1 = LangUtils.hashCode((int)17, (int)i.hashCode());
        Assert.assertTrue((h1 == (h2 = LangUtils.hashCode((int)17, (Object)i)) ? 1 : 0) != 0);
    }

    @Test
    public void testNullObjectHash() {
        int h2;
        int h1 = LangUtils.hashCode((int)17, null);
        Assert.assertTrue((h1 == (h2 = LangUtils.hashCode((int)17, (int)0)) ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanHash() {
        int h1 = LangUtils.hashCode((int)17, (boolean)true);
        int h2 = LangUtils.hashCode((int)17, (boolean)false);
        int h3 = LangUtils.hashCode((int)17, (boolean)true);
        int h4 = LangUtils.hashCode((int)17, (boolean)false);
        Assert.assertTrue((h1 != h2 ? 1 : 0) != 0);
        Assert.assertTrue((h1 == h3 ? 1 : 0) != 0);
        Assert.assertTrue((h2 == h4 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicEquality() {
        Assert.assertTrue((boolean)LangUtils.equals(null, null));
        Assert.assertFalse((boolean)LangUtils.equals(null, (Object)"abc"));
        Assert.assertFalse((boolean)LangUtils.equals((Object)"abc", null));
        Assert.assertTrue((boolean)LangUtils.equals((Object)"abc", (Object)"abc"));
    }

    @Test
    public void testArrayEquals() {
        Assert.assertFalse((boolean)LangUtils.equals(null, (Object[])new Object[0]));
        Assert.assertFalse((boolean)LangUtils.equals((Object[])new Object[0], null));
        Assert.assertTrue((boolean)LangUtils.equals((Object[])new Object[0], (Object[])new Object[0]));
        Assert.assertFalse((boolean)LangUtils.equals((Object[])new Object[]{new Integer(1), new Integer(2)}, (Object[])new Object[]{new Integer(1)}));
        Assert.assertFalse((boolean)LangUtils.equals((Object[])new Object[]{new Integer(1), new Integer(2)}, (Object[])new Object[]{new Integer(1), new Integer(3)}));
        Assert.assertTrue((boolean)LangUtils.equals((Object[])new Object[]{new Integer(1), new Integer(2)}, (Object[])new Object[]{new Integer(1), new Integer(2)}));
    }
}

