/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct;

import com.typesafe.config.ConfigFactory;
import cz.o2.proxima.direct.commitlog.CommitLogReader;
import cz.o2.proxima.direct.commitlog.LogObserver;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.testing.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadMe {
    private static final Logger log = LoggerFactory.getLogger(ReadMe.class);

    private Model createModel() {
        return Model.of(ConfigFactory.load());
    }

    private void consumeCommitLog() {
        Model model = this.createModel();
        DirectDataOperator operator = (DirectDataOperator)model.getRepo().asDataOperator(DirectDataOperator.class, new Consumer[0]);
        CommitLogReader commitLog = (CommitLogReader)operator.getCommitLogReader(new AttributeDescriptor[]{model.getEvent().getDataDescriptor()}).orElseThrow(() -> new IllegalArgumentException("Missing commit log for " + model.getEvent().getDataDescriptor()));
        commitLog.observe("MyObservationProcess", new LogObserver(){

            public boolean onError(Throwable error) {
                throw new RuntimeException(error);
            }

            public boolean onNext(StreamElement elem, LogObserver.OnNextContext context) {
                log.info("Consumed element {}", (Object)elem);
                context.confirm();
                return true;
            }
        });
    }

    private ReadMe() {
        this.consumeCommitLog();
    }
}

