/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.testing.model;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import cz.o2.proxima.direct.commitlog.CommitLogReader;
import cz.o2.proxima.direct.core.DirectAttributeFamilyDescriptor;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.ConfigRepository;
import cz.o2.proxima.repository.DataOperator;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CoreModel
implements Serializable {
    private static final String GENERATED_FROM = "{\n  entities: {\n    event: {\n      attributes: {\n        data: { scheme: \"bytes\" }\n      }\n    }\n\n    gateway: {\n      attributes: {\n        armed: { scheme: bytes }\n        users: { scheme: bytes }\n        status: { scheme: bytes }\n\n        # the following defines a pattern for attributes\n        # each attribute that matches the pattern is treated the same\n        \"device.*\": { scheme: bytes }\n\n        # settings for specific rule\n        \"rule.*\": { scheme: bytes }\n\n        # this is fake attribute that always fails validation\n        fail: { scheme: \"fail:whenever\" }\n\n        bytes: { scheme: bytes }\n        metric: { scheme: float }\n      }\n    }\n\n    dummy: {\n      attributes: {\n        data: { scheme: bytes }\n        \"wildcard.*\": { scheme: \"bytes\" }\n      }\n    }\n\n    batch {\n      from: dummy\n    }\n\n    proxied {\n\n      attributes {\n        # this is \"protected\" field and should not be accessed directly\n        \"_e.*\": { scheme: bytes }\n\n        \"raw.*\": { scheme: bytes }\n\n        \"ints.*\" { scheme: integer }\n\n        \"dummy\": { scheme: bytes }\n\n        # this is proxy public attribute performing transformation\n        \"event.*\": {\n          proxy: \"_e.*\"\n          apply: cz.o2.proxima.transform.EventTransform\n        }\n\n        # this is asymmetric proxy attribute\n        # with different transformations on read and write\n        # e.g. the attribute has to have storage for reading\n        # but writes are transformed to another attribute\n        # typical use-case: replication\n        \"asymmetric.*\": {\n          proxy {\n            write {\n              into: \"_e.*\"\n              apply: cz.o2.proxima.transform.WriteProxy\n            }\n            read {\n              from: \"raw.*\"\n              apply: cz.o2.proxima.transform.ReadProxy\n            }\n          }\n        }\n\n        # applied explicit scheme\n        \"schemeAsymmetric.*\" {\n          proxy {\n            write {\n              into: \"_e.*\"\n              apply: cz.o2.proxima.transform.WriteProxy\n            }\n            read {\n              from: \"ints.*\"\n              apply: cz.o2.proxima.transform.ReadProxy\n            }\n          }\n          # need explicit scheme\n          scheme: float\n        }\n\n        # attribute with one-side proxy transformation\n        \"writeAsymmetric.*\" {\n          proxy {\n            write {\n              into: \"_e.*\"\n              apply: cz.o2.proxima.transform.WriteProxy\n            }\n          }\n          # when the attribute has only single-side transformation\n          # it has to have scheme (because it is regular attribute also\n          # by itself)\n          scheme: bytes\n        }\n\n        # this is just to validate parsing\n        differentScheme {\n          proxy: dummy\n          scheme: integer\n          apply: cz.o2.proxima.transform.EventTransform\n        }\n      }\n\n    }\n\n    replica {\n      from: gateway\n    }\n\n  }\n\n  attributeFamilies: {\n    event-storage-stream: {\n      entity: event\n      attributes: [ data ]\n      # this is testing only storage\n      storage: \"inmem:///proxima_events\"\n      type: primary\n      access: commit-log\n    }\n\n    event-storage-bulk {\n      entity: event\n      attributes: [ data ]\n      storage: \"inmem-bulk:///proxima_events/bulk\"\n      type: replica\n      access: [ write-only ]\n    }\n\n    gateway-storage-stream: {\n      entity: gateway\n      attributes: [ \"*\" ]\n      storage: \"inmem:///proxima_gateway\"\n      type: primary\n      access: [ commit-log, cached-view, random-access ]\n    }\n\n    gateway-storage-batch: {\n      entity: gateway\n      attributes: [ \"*\" ]\n      storage: \"inmem:///proxima_gateway_batch\"\n      type: replica\n      access: [ batch-snapshot, batch-updates ]\n    }\n\n    dummy-storage: {\n      entity: dummy\n      attributes: [ \"*\" ]\n      storage: \"inmem:///proxima/dummy\"\n      type: primary\n      access: [ commit-log, random-access ]\n    }\n\n    dummy-storage-bulk: {\n      entity: dummy\n      attributes: [ \"*\" ]\n      storage: \"inmem-bulk:///proxima/dummy-bulk\"\n      type: replica\n      access: batch-updates\n    }\n\n    batch-storage {\n      entity: batch\n      attributes: [ \"*\" ]\n      storage: \"inmem:///proxima/batch\"\n      type: primary\n      access: batch-updates\n    }\n\n    proxy-primary {\n      entity: proxied\n      attributes: [ \"_e.*\" ]\n      storage: \"inmem:///proxima/proxy\"\n      type: primary\n      access: [ commit-log, random-access, cached-view, batch-snapshot, list-primary-key ]\n    }\n\n    # this is family that will be remove, but has to be accessible by name\n    proxy-event-storage {\n      entity: proxied\n      attributes: [\"event.*\"]\n      storage: \"inmem:///proxima/proxy/event\"\n      type: primary\n      access: commit-log\n    }\n\n    raw-storage {\n      entity: proxied\n      attributes: [ \"raw.*\" ]\n      storage: \"inmem:///proxima/raw\"\n      type: primary\n      access: [ commit-log, random-access ]\n    }\n\n    proxied-other-storage {\n      entity: proxied\n      attributes: [ \"dummy\", \"ints.*\" ]\n      storage: \"inmem:///proxima/proxied-dummy\"\n      type: primary\n      access: [ commit-log, random-access ]\n    }\n\n    writeAsymmetric-read-storage {\n      entity: proxied\n      attributes: [ \"writeAsymmetric.*\" ]\n      storage: \"inmem:///proxima/writeAsymmetric\"\n      type: primary\n      access: [ commit-log, random-access, read-only ]\n    }\n\n    replica-storage {\n      entity: replica\n      attributes: [ \"*\" ]\n      storage: \"inmem:///proxima/replica\"\n      type: primary\n      access: commit-log\n    }\n\n    event-data-storage-with-suffix {\n      entity: event\n      attributes: [ data ]\n      # this is testing only storage\n      storage: \"inmem:///proxima_events-with-suffix\"\n      type: replica\n      access: commit-log\n      replication.consumer.name.suffix: \"-my-suffix\"\n      transformer.consumer.name.suffix: \"-my-suffix\"\n    }\n\n  }\n\n  transformations {\n    event-data-to-dummy-wildcard {\n      entity: event\n      attributes: [ \"data\" ]\n      using: cz.o2.proxima.transform.EventDataToDummy\n      # this is default, but add it to test parsing\n      filter: cz.o2.proxima.storage.PassthroughFilter\n    }\n\n    disabled {\n      entity: event\n      attributes: [ \"data\" ]\n      using: cz.o2.proxima.transform.EventDataToDummy\n      # this is default, but add it to test parsing\n      filter: cz.o2.proxima.storage.PassthroughFilter\n      disabled: true\n    }\n\n  }\n\n}\n\n";
    private final DirectOperator direct;
    private final Config cfg;
    private final RepositoryFactory factory;
    private final Dummy dummy;
    private final Replica replica;
    private final Batch batch;
    private final Proxied proxied;
    private final Event event;
    private final Gateway gateway;

    public static CoreModel of(Config cfg) {
        return new CoreModel(ConfigRepository.Builder.of((Config)cfg.withFallback((ConfigMergeable)ConfigFactory.parseString((String)GENERATED_FROM))));
    }

    public static CoreModel of(ConfigRepository.Builder builder) {
        return new CoreModel(builder);
    }

    public static CoreModel ofTest(Config config, Repository.Validate ... validations) {
        return new CoreModel(ConfigRepository.Builder.ofTest((Config)config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)GENERATED_FROM))).withValidate(validations));
    }

    public static DirectOperator direct(Config cfg) {
        return CoreModel.of(cfg).direct();
    }

    public static DirectOperator direct(ConfigRepository.Builder builder) {
        return CoreModel.of(builder).direct();
    }

    public DirectOperator direct() {
        return this.direct;
    }

    public DirectDataOperator directOperator() {
        return this.direct.getOperator();
    }

    private CoreModel(ConfigRepository.Builder builder) {
        this.factory = Objects.requireNonNull(builder).build().asFactory();
        Repository repo = this.factory.apply();
        this.cfg = ((ConfigRepository)repo).getConfig();
        this.direct = new DirectOperator();
        this.dummy = new Dummy();
        this.replica = new Replica();
        this.batch = new Batch();
        this.proxied = new Proxied();
        this.event = new Event();
        this.gateway = new Gateway();
    }

    public Dummy getDummy() {
        return this.dummy;
    }

    public Replica getReplica() {
        return this.replica;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public Proxied getProxied() {
        return this.proxied;
    }

    public Event getEvent() {
        return this.event;
    }

    public Gateway getGateway() {
        return this.gateway;
    }

    public Repository getRepo() {
        return this.factory.apply();
    }

    public class Gateway
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> failDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> ruleDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<Float> metricDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> bytesDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> armedDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> usersDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> deviceDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> statusDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getFailDescriptor() {
            return this.failDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getRuleDescriptor() {
            return this.ruleDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<Float> getMetricDescriptor() {
            return this.metricDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getBytesDescriptor() {
            return this.bytesDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getArmedDescriptor() {
            return this.armedDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getUsersDescriptor() {
            return this.usersDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getDeviceDescriptor() {
            return this.deviceDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getStatusDescriptor() {
            return this.statusDescriptor;
        }

        private Gateway() {
            this.descriptor = CoreModel.this.factory.apply().getEntity("gateway");
            this.failDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("fail"));
            this.ruleDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("rule.*"));
            this.metricDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("metric"));
            this.bytesDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("bytes"));
            this.armedDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("armed"));
            this.usersDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("users"));
            this.deviceDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("device.*"));
            this.statusDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("status"));
        }
    }

    public class GatewayWrapper
    implements Serializable {
        private byte[] Fail = null;
        private final byte[] FailDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("gateway").getAttribute("fail").getValueSerializer().getDefault();
        private Float Metric = null;
        private final Float MetricDefault = (Float)CoreModel.access$000(CoreModel.this).apply().getEntity("gateway").getAttribute("metric").getValueSerializer().getDefault();
        private byte[] Bytes = null;
        private final byte[] BytesDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("gateway").getAttribute("bytes").getValueSerializer().getDefault();
        private byte[] Armed = null;
        private final byte[] ArmedDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("gateway").getAttribute("armed").getValueSerializer().getDefault();
        private byte[] Users = null;
        private final byte[] UsersDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("gateway").getAttribute("users").getValueSerializer().getDefault();
        private byte[] Status = null;
        private final byte[] StatusDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("gateway").getAttribute("status").getValueSerializer().getDefault();

        private GatewayWrapper() {
        }

        public byte[] getFail() {
            return this.Fail == null ? this.FailDefault : this.Fail;
        }

        public Float getMetric() {
            return this.Metric == null ? this.MetricDefault : this.Metric;
        }

        public byte[] getBytes() {
            return this.Bytes == null ? this.BytesDefault : this.Bytes;
        }

        public byte[] getArmed() {
            return this.Armed == null ? this.ArmedDefault : this.Armed;
        }

        public byte[] getUsers() {
            return this.Users == null ? this.UsersDefault : this.Users;
        }

        public byte[] getStatus() {
            return this.Status == null ? this.StatusDefault : this.Status;
        }
    }

    public class Event
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> dataDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getDataDescriptor() {
            return this.dataDescriptor;
        }

        private Event() {
            this.descriptor = CoreModel.this.factory.apply().getEntity("event");
            this.dataDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("data"));
        }
    }

    public class EventWrapper
    implements Serializable {
        private byte[] Data = null;
        private final byte[] DataDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("event").getAttribute("data").getValueSerializer().getDefault();

        private EventWrapper() {
        }

        public byte[] getData() {
            return this.Data == null ? this.DataDefault : this.Data;
        }
    }

    public class Proxied
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> rawDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> dummyDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<Integer> intsDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> eventDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> asymmetricDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<Float> schemeAsymmetricDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> writeAsymmetricDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<Integer> differentSchemeDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getRawDescriptor() {
            return this.rawDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getDummyDescriptor() {
            return this.dummyDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<Integer> getIntsDescriptor() {
            return this.intsDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getEventDescriptor() {
            return this.eventDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getAsymmetricDescriptor() {
            return this.asymmetricDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<Float> getSchemeAsymmetricDescriptor() {
            return this.schemeAsymmetricDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getWriteAsymmetricDescriptor() {
            return this.writeAsymmetricDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<Integer> getDifferentSchemeDescriptor() {
            return this.differentSchemeDescriptor;
        }

        private Proxied() {
            this.descriptor = CoreModel.this.factory.apply().getEntity("proxied");
            this.rawDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("raw.*"));
            this.dummyDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("dummy"));
            this.intsDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("ints.*"));
            this.eventDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("event.*"));
            this.asymmetricDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("asymmetric.*"));
            this.schemeAsymmetricDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("schemeAsymmetric.*"));
            this.writeAsymmetricDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("writeAsymmetric.*"));
            this.differentSchemeDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("differentScheme"));
        }
    }

    public class ProxiedWrapper
    implements Serializable {
        private byte[] Dummy = null;
        private final byte[] DummyDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("proxied").getAttribute("dummy").getValueSerializer().getDefault();
        private Integer DifferentScheme = null;
        private final Integer DifferentSchemeDefault = (Integer)CoreModel.access$000(CoreModel.this).apply().getEntity("proxied").getAttribute("differentScheme").getValueSerializer().getDefault();

        private ProxiedWrapper() {
        }

        public byte[] getDummy() {
            return this.Dummy == null ? this.DummyDefault : this.Dummy;
        }

        public Integer getDifferentScheme() {
            return this.DifferentScheme == null ? this.DifferentSchemeDefault : this.DifferentScheme;
        }
    }

    public class Batch
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> dataDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> wildcardDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getDataDescriptor() {
            return this.dataDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getWildcardDescriptor() {
            return this.wildcardDescriptor;
        }

        private Batch() {
            this.descriptor = CoreModel.this.factory.apply().getEntity("batch");
            this.dataDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("data"));
            this.wildcardDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("wildcard.*"));
        }
    }

    public class BatchWrapper
    implements Serializable {
        private byte[] Data = null;
        private final byte[] DataDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("batch").getAttribute("data").getValueSerializer().getDefault();

        private BatchWrapper() {
        }

        public byte[] getData() {
            return this.Data == null ? this.DataDefault : this.Data;
        }
    }

    public class Replica
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> failDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> ruleDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<Float> metricDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> bytesDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> armedDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> usersDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> deviceDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> statusDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getFailDescriptor() {
            return this.failDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getRuleDescriptor() {
            return this.ruleDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<Float> getMetricDescriptor() {
            return this.metricDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getBytesDescriptor() {
            return this.bytesDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getArmedDescriptor() {
            return this.armedDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getUsersDescriptor() {
            return this.usersDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getDeviceDescriptor() {
            return this.deviceDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getStatusDescriptor() {
            return this.statusDescriptor;
        }

        private Replica() {
            this.descriptor = CoreModel.this.factory.apply().getEntity("replica");
            this.failDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("fail"));
            this.ruleDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("rule.*"));
            this.metricDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("metric"));
            this.bytesDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("bytes"));
            this.armedDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("armed"));
            this.usersDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("users"));
            this.deviceDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("device.*"));
            this.statusDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("status"));
        }
    }

    public class ReplicaWrapper
    implements Serializable {
        private byte[] Fail = null;
        private final byte[] FailDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("replica").getAttribute("fail").getValueSerializer().getDefault();
        private Float Metric = null;
        private final Float MetricDefault = (Float)CoreModel.access$000(CoreModel.this).apply().getEntity("replica").getAttribute("metric").getValueSerializer().getDefault();
        private byte[] Bytes = null;
        private final byte[] BytesDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("replica").getAttribute("bytes").getValueSerializer().getDefault();
        private byte[] Armed = null;
        private final byte[] ArmedDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("replica").getAttribute("armed").getValueSerializer().getDefault();
        private byte[] Users = null;
        private final byte[] UsersDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("replica").getAttribute("users").getValueSerializer().getDefault();
        private byte[] Status = null;
        private final byte[] StatusDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("replica").getAttribute("status").getValueSerializer().getDefault();

        private ReplicaWrapper() {
        }

        public byte[] getFail() {
            return this.Fail == null ? this.FailDefault : this.Fail;
        }

        public Float getMetric() {
            return this.Metric == null ? this.MetricDefault : this.Metric;
        }

        public byte[] getBytes() {
            return this.Bytes == null ? this.BytesDefault : this.Bytes;
        }

        public byte[] getArmed() {
            return this.Armed == null ? this.ArmedDefault : this.Armed;
        }

        public byte[] getUsers() {
            return this.Users == null ? this.UsersDefault : this.Users;
        }

        public byte[] getStatus() {
            return this.Status == null ? this.StatusDefault : this.Status;
        }
    }

    public class Dummy
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Regular<byte[]> dataDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<byte[]> wildcardDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<byte[]> getDataDescriptor() {
            return this.dataDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<byte[]> getWildcardDescriptor() {
            return this.wildcardDescriptor;
        }

        private Dummy() {
            this.descriptor = CoreModel.this.factory.apply().getEntity("dummy");
            this.dataDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("data"));
            this.wildcardDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("wildcard.*"));
        }
    }

    public class DummyWrapper
    implements Serializable {
        private byte[] Data = null;
        private final byte[] DataDefault = (byte[])CoreModel.access$000(CoreModel.this).apply().getEntity("dummy").getAttribute("data").getValueSerializer().getDefault();

        private DummyWrapper() {
        }

        public byte[] getData() {
            return this.Data == null ? this.DataDefault : this.Data;
        }
    }

    public class DirectOperator
    implements DataOperatorProvider<DirectDataOperator> {
        private transient DirectDataOperator direct;

        private DirectDataOperator direct() {
            if (this.direct == null) {
                this.direct = (DirectDataOperator)CoreModel.this.factory.apply().getOrCreateOperator(DirectDataOperator.class, new Consumer[0]);
            }
            return this.direct;
        }

        @Override
        public DirectDataOperator getOperator() {
            return this.direct();
        }

        public Optional<CommitLogReader> getCommitLog(AttributeDescriptor<?> ... attributes) {
            HashSet descriptors = new HashSet();
            for (AttributeDescriptor<?> attr : attributes) {
                Set commitLogs = this.direct().getFamiliesForAttribute(attr).stream().filter(af -> af.getDesc().getAccess().canReadCommitLog()).filter(af -> af.getCommitLogReader().isPresent()).collect(Collectors.toSet());
                if (commitLogs.isEmpty()) {
                    return Optional.empty();
                }
                descriptors.addAll(commitLogs);
            }
            if (descriptors.size() > 1) {
                throw new UnsupportedOperationException("Unsupported: multiple commit logs for multiple attributes");
            }
            return ((DirectAttributeFamilyDescriptor)descriptors.stream().findAny().get()).getCommitLogReader();
        }

        public CoreModel parent() {
            return CoreModel.this;
        }
    }

    @FunctionalInterface
    static interface DataOperatorProvider<T extends DataOperator>
    extends Serializable {
        public T getOperator();
    }

    @FunctionalInterface
    static interface EntityDescriptorProvider {
        public EntityDescriptor getDescriptor();
    }
}

