/*
 * The file is generated from /home/honza/git/proxima/proxima-platform/direct/core-testing/../../core/src/test/resources/test-reference.conf.
 * DO NOT EDIT! YOUR CHANGES WILL BE OVERWRITTEN.
 */

package cz.o2.proxima.testing.model;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.repository.ConfigRepository;
import cz.o2.proxima.repository.DataOperator;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor.Regular;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor.Wildcard;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

/* operator specific imports */
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.direct.randomaccess.KeyValue;
import cz.o2.proxima.direct.commitlog.CommitLogReader;
import cz.o2.proxima.direct.randomaccess.RandomAccessReader;
import cz.o2.proxima.direct.core.DirectAttributeFamilyDescriptor;

public class CoreModel implements Serializable {

  private static final String GENERATED_FROM = "{\n"
 + "  entities: {\n"
 + "    event: {\n"
 + "      attributes: {\n"
 + "        data: { scheme: \"bytes\" }\n"
 + "      }\n"
 + "    }\n"
 + "\n"
 + "    gateway: {\n"
 + "      attributes: {\n"
 + "        armed: { scheme: bytes }\n"
 + "        users: { scheme: bytes }\n"
 + "        status: { scheme: bytes }\n"
 + "\n"
 + "        # the following defines a pattern for attributes\n"
 + "        # each attribute that matches the pattern is treated the same\n"
 + "        \"device.*\": { scheme: bytes }\n"
 + "\n"
 + "        # settings for specific rule\n"
 + "        \"rule.*\": { scheme: bytes }\n"
 + "\n"
 + "        # this is fake attribute that always fails validation\n"
 + "        fail: { scheme: \"fail:whenever\" }\n"
 + "\n"
 + "        bytes: { scheme: bytes }\n"
 + "        metric: { scheme: float }\n"
 + "      }\n"
 + "    }\n"
 + "\n"
 + "    dummy: {\n"
 + "      attributes: {\n"
 + "        data: { scheme: bytes }\n"
 + "        \"wildcard.*\": { scheme: \"bytes\" }\n"
 + "      }\n"
 + "    }\n"
 + "\n"
 + "    batch {\n"
 + "      from: dummy\n"
 + "    }\n"
 + "\n"
 + "    proxied {\n"
 + "\n"
 + "      attributes {\n"
 + "        # this is \"protected\" field and should not be accessed directly\n"
 + "        \"_e.*\": { scheme: bytes }\n"
 + "\n"
 + "        \"raw.*\": { scheme: bytes }\n"
 + "\n"
 + "        \"ints.*\" { scheme: integer }\n"
 + "\n"
 + "        \"dummy\": { scheme: bytes }\n"
 + "\n"
 + "        # this is proxy public attribute performing transformation\n"
 + "        \"event.*\": {\n"
 + "          proxy: \"_e.*\"\n"
 + "          apply: cz.o2.proxima.transform.EventTransform\n"
 + "        }\n"
 + "\n"
 + "        # this is asymmetric proxy attribute\n"
 + "        # with different transformations on read and write\n"
 + "        # e.g. the attribute has to have storage for reading\n"
 + "        # but writes are transformed to another attribute\n"
 + "        # typical use-case: replication\n"
 + "        \"asymmetric.*\": {\n"
 + "          proxy {\n"
 + "            write {\n"
 + "              into: \"_e.*\"\n"
 + "              apply: cz.o2.proxima.transform.WriteProxy\n"
 + "            }\n"
 + "            read {\n"
 + "              from: \"raw.*\"\n"
 + "              apply: cz.o2.proxima.transform.ReadProxy\n"
 + "            }\n"
 + "          }\n"
 + "        }\n"
 + "\n"
 + "        # applied explicit scheme\n"
 + "        \"schemeAsymmetric.*\" {\n"
 + "          proxy {\n"
 + "            write {\n"
 + "              into: \"_e.*\"\n"
 + "              apply: cz.o2.proxima.transform.WriteProxy\n"
 + "            }\n"
 + "            read {\n"
 + "              from: \"ints.*\"\n"
 + "              apply: cz.o2.proxima.transform.ReadProxy\n"
 + "            }\n"
 + "          }\n"
 + "          # need explicit scheme\n"
 + "          scheme: float\n"
 + "        }\n"
 + "\n"
 + "        # attribute with one-side proxy transformation\n"
 + "        \"writeAsymmetric.*\" {\n"
 + "          proxy {\n"
 + "            write {\n"
 + "              into: \"_e.*\"\n"
 + "              apply: cz.o2.proxima.transform.WriteProxy\n"
 + "            }\n"
 + "          }\n"
 + "          # when the attribute has only single-side transformation\n"
 + "          # it has to have scheme (because it is regular attribute also\n"
 + "          # by itself)\n"
 + "          scheme: bytes\n"
 + "        }\n"
 + "\n"
 + "        # this is just to validate parsing\n"
 + "        differentScheme {\n"
 + "          proxy: dummy\n"
 + "          scheme: integer\n"
 + "          apply: cz.o2.proxima.transform.EventTransform\n"
 + "        }\n"
 + "      }\n"
 + "\n"
 + "    }\n"
 + "\n"
 + "    replica {\n"
 + "      from: gateway\n"
 + "    }\n"
 + "\n"
 + "  }\n"
 + "\n"
 + "  attributeFamilies: {\n"
 + "    event-storage-stream: {\n"
 + "      entity: event\n"
 + "      attributes: [ data ]\n"
 + "      # this is testing only storage\n"
 + "      storage: \"inmem:///proxima_events\"\n"
 + "      type: primary\n"
 + "      access: commit-log\n"
 + "    }\n"
 + "\n"
 + "    event-storage-bulk {\n"
 + "      entity: event\n"
 + "      attributes: [ data ]\n"
 + "      storage: \"inmem-bulk:///proxima_events/bulk\"\n"
 + "      type: replica\n"
 + "      access: [ write-only ]\n"
 + "      filter: cz.o2.proxima.util.DummyFilter\n"
 + "    }\n"
 + "\n"
 + "    gateway-storage-stream: {\n"
 + "      entity: gateway\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"inmem:///proxima_gateway\"\n"
 + "      type: primary\n"
 + "      access: [ commit-log, cached-view, random-access ]\n"
 + "    }\n"
 + "\n"
 + "    gateway-storage-batch: {\n"
 + "      entity: gateway\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"inmem:///proxima_gateway_batch\"\n"
 + "      type: replica\n"
 + "      access: [ batch-snapshot, batch-updates ]\n"
 + "    }\n"
 + "\n"
 + "    dummy-storage: {\n"
 + "      entity: dummy\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"inmem:///proxima/dummy\"\n"
 + "      type: primary\n"
 + "      access: [ commit-log, random-access ]\n"
 + "    }\n"
 + "\n"
 + "    dummy-storage-bulk: {\n"
 + "      entity: dummy\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"inmem-bulk:///proxima/dummy-bulk\"\n"
 + "      type: replica\n"
 + "      access: batch-updates\n"
 + "    }\n"
 + "\n"
 + "    batch-storage {\n"
 + "      entity: batch\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"inmem:///proxima/batch\"\n"
 + "      type: primary\n"
 + "      access: batch-updates\n"
 + "    }\n"
 + "\n"
 + "    proxy-primary {\n"
 + "      entity: proxied\n"
 + "      attributes: [ \"_e.*\" ]\n"
 + "      storage: \"inmem:///proxima/proxy\"\n"
 + "      type: primary\n"
 + "      access: [ commit-log, random-access, cached-view, batch-snapshot, list-primary-key ]\n"
 + "    }\n"
 + "\n"
 + "    # this is family that will be remove, but has to be accessible by name\n"
 + "    proxy-event-storage {\n"
 + "      entity: proxied\n"
 + "      attributes: [\"event.*\"]\n"
 + "      storage: \"inmem:///proxima/proxy/event\"\n"
 + "      type: primary\n"
 + "      access: commit-log\n"
 + "    }\n"
 + "\n"
 + "    raw-storage {\n"
 + "      entity: proxied\n"
 + "      attributes: [ \"raw.*\" ]\n"
 + "      storage: \"inmem:///proxima/raw\"\n"
 + "      type: primary\n"
 + "      access: [ commit-log, random-access ]\n"
 + "    }\n"
 + "\n"
 + "    proxied-other-storage {\n"
 + "      entity: proxied\n"
 + "      attributes: [ \"dummy\", \"ints.*\" ]\n"
 + "      storage: \"inmem:///proxima/proxied-dummy\"\n"
 + "      type: primary\n"
 + "      access: [ commit-log, random-access ]\n"
 + "    }\n"
 + "\n"
 + "    writeAsymmetric-read-storage {\n"
 + "      entity: proxied\n"
 + "      attributes: [ \"writeAsymmetric.*\" ]\n"
 + "      storage: \"inmem:///proxima/writeAsymmetric\"\n"
 + "      type: primary\n"
 + "      access: [ commit-log, random-access, read-only ]\n"
 + "    }\n"
 + "\n"
 + "    replica-storage {\n"
 + "      entity: replica\n"
 + "      attributes: [ \"*\" ]\n"
 + "      storage: \"inmem:///proxima/replica\"\n"
 + "      type: primary\n"
 + "      access: commit-log\n"
 + "    }\n"
 + "\n"
 + "    event-data-storage-with-suffix {\n"
 + "      entity: event\n"
 + "      attributes: [ data ]\n"
 + "      # this is testing only storage\n"
 + "      storage: \"inmem:///proxima_events-with-suffix\"\n"
 + "      type: replica\n"
 + "      access: commit-log\n"
 + "      replication.consumer.name.suffix: \"-my-suffix\"\n"
 + "      transformer.consumer.name.suffix: \"-my-suffix\"\n"
 + "    }\n"
 + "\n"
 + "  }\n"
 + "\n"
 + "  transformations {\n"
 + "    event-data-to-dummy-wildcard {\n"
 + "      entity: event\n"
 + "      attributes: [ \"data\" ]\n"
 + "      using: cz.o2.proxima.transform.EventDataToDummy\n"
 + "      # this is default, but add it to test parsing\n"
 + "      filter: cz.o2.proxima.util.DummyFilter\n"
 + "    }\n"
 + "\n"
 + "    disabled {\n"
 + "      entity: event\n"
 + "      attributes: [ \"data\" ]\n"
 + "      using: cz.o2.proxima.transform.EventDataToDummy\n"
 + "      # this is default, but add it to test parsing\n"
 + "      filter: cz.o2.proxima.storage.PassthroughFilter\n"
 + "      disabled: true\n"
 + "    }\n"
 + "\n"
 + "  }\n"
 + "\n"
 + "}\n"
 + "\n";

  /**
   * Create instance of {@code CoreModel} for production usage.
   *
   * @param cfg configuration to use
   * @return CoreModel
   **/
  public static CoreModel of(Config cfg) {
    return new CoreModel(ConfigRepository.Builder.of(
        cfg.withFallback(ConfigFactory.parseString(GENERATED_FROM))));
  }

  /**
   * Create instance of {@code CoreModel} with specified {@code ConfigRepository.Builder}.
   *
   * @param builder configuration to use
   * @return CoreModel
   **/
  public static CoreModel of(ConfigRepository.Builder builder) {
    return new CoreModel(builder);
  }

  /**
   * Create instance of {@code CoreModel} for testing purposes.
   *
   * @param config the configuration to use
   * @param validations which validations to perform
   * @return CoreModel
   **/
  public static CoreModel ofTest(Config config, Repository.Validate... validations) {
    return new CoreModel(
        ConfigRepository.Builder
            .ofTest(config.withFallback(ConfigFactory.parseString(GENERATED_FROM)))
            .withValidate(validations));
  }

  @FunctionalInterface
  static interface EntityDescriptorProvider {
    EntityDescriptor getDescriptor();
  }

  @FunctionalInterface
  static interface DataOperatorProvider<T extends DataOperator> extends Serializable {

    T getOperator();

  }

  public class DirectOperator implements DataOperatorProvider<cz.o2.proxima.direct.core.DirectDataOperator> {

    
    private transient DirectDataOperator direct;

    private DirectDataOperator direct() {
      if (direct == null) {
        direct = factory.apply().getOrCreateOperator(DirectDataOperator.class);
      }
      return direct;
    }

    @Override
    public DirectDataOperator getOperator() {
      return direct();
    }

    public Optional<CommitLogReader> getCommitLog(AttributeDescriptor<?>... attributes) {
      Set<DirectAttributeFamilyDescriptor> descriptors = new HashSet<>();
      for (AttributeDescriptor<?> attr : attributes) {
        Set<DirectAttributeFamilyDescriptor> commitLogs = direct().getFamiliesForAttribute(attr)
            .stream()
            .filter(af -> af.getDesc().getAccess().canReadCommitLog())
            .filter(af -> af.getCommitLogReader().isPresent())
            .collect(Collectors.toSet());
        if (commitLogs.isEmpty()) {
          return Optional.empty();
        }
        descriptors.addAll(commitLogs);
      }
      // FIXME: we cannot join multiple commit logs together for now
      // so we have to throw exception here
      if (descriptors.size() > 1) {
        throw new UnsupportedOperationException("Unsupported: multiple commit logs for multiple attributes");
      }
      return descriptors.stream().findAny().get().getCommitLogReader();
    }


    public CoreModel parent() {
      return CoreModel.this;
    }

  }
  private final DirectOperator direct;
  public static DirectOperator direct(Config cfg) {
    return of(cfg).direct();
  }
  public static DirectOperator direct(ConfigRepository.Builder builder) {
    return of(builder).direct();
  }
  public DirectOperator direct() {
    return direct;
  }
  public cz.o2.proxima.direct.core.DirectDataOperator directOperator() {
    return direct.getOperator();
  }


  /**
   * Class wrapping access to attribute data of entity dummy.
   **/
  public class DummyWrapper implements Serializable {

    private byte[] Data = null;
    @SuppressWarnings("unchecked")
    private final byte[] DataDefault = (byte[])
      factory.apply().getEntity("dummy").getAttribute("data").getValueSerializer().getDefault();
     

    private DummyWrapper() {

    }

    public byte[] getData() {
      return Data == null ? DataDefault : Data;
    }
         

  }

  /**
   * Class wrapping views on entity dummy
   **/
  public class Dummy implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("dummy");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Regular<byte[]> dataDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("data"));
    public Regular<byte[]> getDataDescriptor() {
      return dataDescriptor;
    }
     
      private final Wildcard<byte[]> wildcardDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("wildcard.*"));
    public Wildcard<byte[]> getWildcardDescriptor() {
      return wildcardDescriptor;
    }
 
   

    private Dummy() { }

  }



  /**
   * Class wrapping access to attribute data of entity replica.
   **/
  public class ReplicaWrapper implements Serializable {

    private byte[] Fail = null;
    @SuppressWarnings("unchecked")
    private final byte[] FailDefault = (byte[])
      factory.apply().getEntity("replica").getAttribute("fail").getValueSerializer().getDefault();
        private Float Metric = null;
    @SuppressWarnings("unchecked")
    private final Float MetricDefault = (Float)
      factory.apply().getEntity("replica").getAttribute("metric").getValueSerializer().getDefault();
      private byte[] Bytes = null;
    @SuppressWarnings("unchecked")
    private final byte[] BytesDefault = (byte[])
      factory.apply().getEntity("replica").getAttribute("bytes").getValueSerializer().getDefault();
      private byte[] Armed = null;
    @SuppressWarnings("unchecked")
    private final byte[] ArmedDefault = (byte[])
      factory.apply().getEntity("replica").getAttribute("armed").getValueSerializer().getDefault();
      private byte[] Users = null;
    @SuppressWarnings("unchecked")
    private final byte[] UsersDefault = (byte[])
      factory.apply().getEntity("replica").getAttribute("users").getValueSerializer().getDefault();
        private byte[] Status = null;
    @SuppressWarnings("unchecked")
    private final byte[] StatusDefault = (byte[])
      factory.apply().getEntity("replica").getAttribute("status").getValueSerializer().getDefault();
   

    private ReplicaWrapper() {

    }

    public byte[] getFail() {
      return Fail == null ? FailDefault : Fail;
    }
            public Float getMetric() {
      return Metric == null ? MetricDefault : Metric;
    }
        public byte[] getBytes() {
      return Bytes == null ? BytesDefault : Bytes;
    }
        public byte[] getArmed() {
      return Armed == null ? ArmedDefault : Armed;
    }
        public byte[] getUsers() {
      return Users == null ? UsersDefault : Users;
    }
            public byte[] getStatus() {
      return Status == null ? StatusDefault : Status;
    }
     

  }

  /**
   * Class wrapping views on entity replica
   **/
  public class Replica implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("replica");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Regular<byte[]> failDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("fail"));
    public Regular<byte[]> getFailDescriptor() {
      return failDescriptor;
    }
     
      private final Wildcard<byte[]> ruleDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("rule.*"));
    public Wildcard<byte[]> getRuleDescriptor() {
      return ruleDescriptor;
    }
 
      private final Regular<Float> metricDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("metric"));
    public Regular<Float> getMetricDescriptor() {
      return metricDescriptor;
    }
     
      private final Regular<byte[]> bytesDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("bytes"));
    public Regular<byte[]> getBytesDescriptor() {
      return bytesDescriptor;
    }
     
      private final Regular<byte[]> armedDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("armed"));
    public Regular<byte[]> getArmedDescriptor() {
      return armedDescriptor;
    }
     
      private final Regular<byte[]> usersDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("users"));
    public Regular<byte[]> getUsersDescriptor() {
      return usersDescriptor;
    }
     
      private final Wildcard<byte[]> deviceDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("device.*"));
    public Wildcard<byte[]> getDeviceDescriptor() {
      return deviceDescriptor;
    }
 
      private final Regular<byte[]> statusDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("status"));
    public Regular<byte[]> getStatusDescriptor() {
      return statusDescriptor;
    }
     
   

    private Replica() { }

  }



  /**
   * Class wrapping access to attribute data of entity batch.
   **/
  public class BatchWrapper implements Serializable {

    private byte[] Data = null;
    @SuppressWarnings("unchecked")
    private final byte[] DataDefault = (byte[])
      factory.apply().getEntity("batch").getAttribute("data").getValueSerializer().getDefault();
     

    private BatchWrapper() {

    }

    public byte[] getData() {
      return Data == null ? DataDefault : Data;
    }
         

  }

  /**
   * Class wrapping views on entity batch
   **/
  public class Batch implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("batch");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Regular<byte[]> dataDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("data"));
    public Regular<byte[]> getDataDescriptor() {
      return dataDescriptor;
    }
     
      private final Wildcard<byte[]> wildcardDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("wildcard.*"));
    public Wildcard<byte[]> getWildcardDescriptor() {
      return wildcardDescriptor;
    }
 
   

    private Batch() { }

  }



  /**
   * Class wrapping access to attribute data of entity proxied.
   **/
  public class ProxiedWrapper implements Serializable {

      private byte[] Dummy = null;
    @SuppressWarnings("unchecked")
    private final byte[] DummyDefault = (byte[])
      factory.apply().getEntity("proxied").getAttribute("dummy").getValueSerializer().getDefault();
                private Integer DifferentScheme = null;
    @SuppressWarnings("unchecked")
    private final Integer DifferentSchemeDefault = (Integer)
      factory.apply().getEntity("proxied").getAttribute("differentScheme").getValueSerializer().getDefault();
   

    private ProxiedWrapper() {

    }

        public byte[] getDummy() {
      return Dummy == null ? DummyDefault : Dummy;
    }
                            public Integer getDifferentScheme() {
      return DifferentScheme == null ? DifferentSchemeDefault : DifferentScheme;
    }
     

  }

  /**
   * Class wrapping views on entity proxied
   **/
  public class Proxied implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("proxied");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Wildcard<byte[]> rawDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("raw.*"));
    public Wildcard<byte[]> getRawDescriptor() {
      return rawDescriptor;
    }
 
      private final Regular<byte[]> dummyDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("dummy"));
    public Regular<byte[]> getDummyDescriptor() {
      return dummyDescriptor;
    }
     
      private final Wildcard<Integer> intsDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("ints.*"));
    public Wildcard<Integer> getIntsDescriptor() {
      return intsDescriptor;
    }
 
      private final Wildcard<byte[]> eventDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("event.*"));
    public Wildcard<byte[]> getEventDescriptor() {
      return eventDescriptor;
    }
 
      private final Wildcard<byte[]> asymmetricDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("asymmetric.*"));
    public Wildcard<byte[]> getAsymmetricDescriptor() {
      return asymmetricDescriptor;
    }
 
      private final Wildcard<Float> schemeAsymmetricDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("schemeAsymmetric.*"));
    public Wildcard<Float> getSchemeAsymmetricDescriptor() {
      return schemeAsymmetricDescriptor;
    }
 
      private final Wildcard<byte[]> writeAsymmetricDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("writeAsymmetric.*"));
    public Wildcard<byte[]> getWriteAsymmetricDescriptor() {
      return writeAsymmetricDescriptor;
    }
 
      private final Regular<Integer> differentSchemeDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("differentScheme"));
    public Regular<Integer> getDifferentSchemeDescriptor() {
      return differentSchemeDescriptor;
    }
     
   

    private Proxied() { }

  }



  /**
   * Class wrapping access to attribute data of entity event.
   **/
  public class EventWrapper implements Serializable {

    private byte[] Data = null;
    @SuppressWarnings("unchecked")
    private final byte[] DataDefault = (byte[])
      factory.apply().getEntity("event").getAttribute("data").getValueSerializer().getDefault();
   

    private EventWrapper() {

    }

    public byte[] getData() {
      return Data == null ? DataDefault : Data;
    }
     

  }

  /**
   * Class wrapping views on entity event
   **/
  public class Event implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("event");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Regular<byte[]> dataDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("data"));
    public Regular<byte[]> getDataDescriptor() {
      return dataDescriptor;
    }
     
   

    private Event() { }

  }



  /**
   * Class wrapping access to attribute data of entity gateway.
   **/
  public class GatewayWrapper implements Serializable {

    private byte[] Fail = null;
    @SuppressWarnings("unchecked")
    private final byte[] FailDefault = (byte[])
      factory.apply().getEntity("gateway").getAttribute("fail").getValueSerializer().getDefault();
        private Float Metric = null;
    @SuppressWarnings("unchecked")
    private final Float MetricDefault = (Float)
      factory.apply().getEntity("gateway").getAttribute("metric").getValueSerializer().getDefault();
      private byte[] Bytes = null;
    @SuppressWarnings("unchecked")
    private final byte[] BytesDefault = (byte[])
      factory.apply().getEntity("gateway").getAttribute("bytes").getValueSerializer().getDefault();
      private byte[] Armed = null;
    @SuppressWarnings("unchecked")
    private final byte[] ArmedDefault = (byte[])
      factory.apply().getEntity("gateway").getAttribute("armed").getValueSerializer().getDefault();
      private byte[] Users = null;
    @SuppressWarnings("unchecked")
    private final byte[] UsersDefault = (byte[])
      factory.apply().getEntity("gateway").getAttribute("users").getValueSerializer().getDefault();
        private byte[] Status = null;
    @SuppressWarnings("unchecked")
    private final byte[] StatusDefault = (byte[])
      factory.apply().getEntity("gateway").getAttribute("status").getValueSerializer().getDefault();
   

    private GatewayWrapper() {

    }

    public byte[] getFail() {
      return Fail == null ? FailDefault : Fail;
    }
            public Float getMetric() {
      return Metric == null ? MetricDefault : Metric;
    }
        public byte[] getBytes() {
      return Bytes == null ? BytesDefault : Bytes;
    }
        public byte[] getArmed() {
      return Armed == null ? ArmedDefault : Armed;
    }
        public byte[] getUsers() {
      return Users == null ? UsersDefault : Users;
    }
            public byte[] getStatus() {
      return Status == null ? StatusDefault : Status;
    }
     

  }

  /**
   * Class wrapping views on entity gateway
   **/
  public class Gateway implements Serializable, EntityDescriptorProvider {

    private final EntityDescriptor descriptor = factory.apply().getEntity("gateway");

    @Override
    public EntityDescriptor getDescriptor() {
      return descriptor;
    }

    private final Regular<byte[]> failDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("fail"));
    public Regular<byte[]> getFailDescriptor() {
      return failDescriptor;
    }
     
      private final Wildcard<byte[]> ruleDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("rule.*"));
    public Wildcard<byte[]> getRuleDescriptor() {
      return ruleDescriptor;
    }
 
      private final Regular<Float> metricDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("metric"));
    public Regular<Float> getMetricDescriptor() {
      return metricDescriptor;
    }
     
      private final Regular<byte[]> bytesDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("bytes"));
    public Regular<byte[]> getBytesDescriptor() {
      return bytesDescriptor;
    }
     
      private final Regular<byte[]> armedDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("armed"));
    public Regular<byte[]> getArmedDescriptor() {
      return armedDescriptor;
    }
     
      private final Regular<byte[]> usersDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("users"));
    public Regular<byte[]> getUsersDescriptor() {
      return usersDescriptor;
    }
     
      private final Wildcard<byte[]> deviceDescriptor =
      EntityAwareAttributeDescriptor.Wildcard.of(descriptor, descriptor.getAttribute("device.*"));
    public Wildcard<byte[]> getDeviceDescriptor() {
      return deviceDescriptor;
    }
 
      private final Regular<byte[]> statusDescriptor =
      EntityAwareAttributeDescriptor.Regular.of(descriptor, descriptor.getAttribute("status"));
    public Regular<byte[]> getStatusDescriptor() {
      return statusDescriptor;
    }
     
   

    private Gateway() { }

  }



  private final Config cfg;
  private final RepositoryFactory factory;

  private final Dummy dummy;
  private final Replica replica;
  private final Batch batch;
  private final Proxied proxied;
  private final Event event;
  private final Gateway gateway;


  private CoreModel(ConfigRepository.Builder builder) {
    this.factory = Objects.requireNonNull(builder).build().asFactory();
    Repository repo = this.factory.apply();
    this.cfg = ((ConfigRepository) repo).getConfig();
    direct = new DirectOperator();
    dummy = new Dummy();
    replica = new Replica();
    batch = new Batch();
    proxied = new Proxied();
    event = new Event();
    gateway = new Gateway();
  }

  public Dummy getDummy() {
    return dummy;
  }
  public Replica getReplica() {
    return replica;
  }
  public Batch getBatch() {
    return batch;
  }
  public Proxied getProxied() {
    return proxied;
  }
  public Event getEvent() {
    return event;
  }
  public Gateway getGateway() {
    return gateway;
  }

  public Repository getRepo() {
    return factory.apply();
  }

}

