/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.testing.model;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import cz.o2.proxima.direct.commitlog.CommitLogReader;
import cz.o2.proxima.direct.core.DirectAttributeFamilyDescriptor;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.example.Example;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.ConfigRepository;
import cz.o2.proxima.repository.DataOperator;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Model
implements Serializable {
    private static final String GENERATED_FROM = " entities {\n   # user entity, let's make this really simple\n   user {\n     attributes {\n\n       # some details of user - e.g. name, email, ...\n       details { scheme: \"proto:cz.o2.proxima.example.Example.UserDetails\" }\n\n       # model of preferences based on events\n       preferences { scheme: \"proto:cz.o2.proxima.example.Example.UserPreferences\" }\n\n       # selected events are stored to user's history\n       \"event.*\" { scheme: \"proto:cz.o2.proxima.example.Example.BaseEvent\" }\n\n     }\n   }\n   # entity describing a single good we want to sell\n   product {\n     # note: we have to split to separate attributes each attribute that we want to be able\n     # to update *independently*\n     attributes {\n\n       # price, with some possible additional information, like VAT and other stuff\n       price { scheme: \"proto:cz.o2.proxima.example.Example.Price\" }\n\n       # some general details of the product\n       details { scheme: \"proto:cz.o2.proxima.example.Example.ProductDetails\" }\n\n       # list of associated categories\n       \"category.*\" { scheme: \"proto:cz.o2.proxima.example.Example.ProductCategory\" }\n\n     }\n   }\n\n   # the events which link users to goods\n   event {\n     attributes {\n\n       # the event is atomic entity with just a single attribute\n       data { scheme: \"proto:cz.o2.proxima.example.Example.BaseEvent\" }\n\n     }\n   }\n\n }\n\n attributeFamilies {\n\n    # we need this to be able to read user attributes 'details' and 'preferences' by user's key\n    user-random-access {\n      entity: user\n      attributes: [ \"details\", \"preferences\" ]\n      storage: \"cassandra://\"${cassandra.seed}/${cassandra.user-table}\"?primary=user\"\n      type: primary\n      access: random-access\n    }\n\n    # store incoming events to user's history\n    user-event-history-store {\n      entity: event\n      attributes: [ \"data\" ]\n      storage: \"cassandra://\"${cassandra.seed}/${cassandra.user-event-table}/\n      # this class defines how we transform incoming event to CQL\n      cqlFactory: cz.o2.proxima.example.EventHistoryCqlFactory\n      # this is filtering condition, we want to select only some events\n      filter: cz.o2.proxima.example.EventHistoryFilter\n      type: replica\n      access: write-only\n    }\n\n    # this family defines read access to the stored event history\n    user-event-history-read {\n      entity: user\n      attributes: [ \"event.*\" ]\n      storage: \"cassandra://\"${cassandra.seed}/${cassandra.user-event-table}\"?primary=user&secondary=stamp&data=event&reversed=true\"\n      # ignore this for now\n      converter: cz.o2.proxima.storage.cassandra.DateToLongConverter\n      type: replica\n      # we will not explicitly modify this, it will be updated automatically by incoming events\n      access: read-only\n    }\n\n    # random access to products\n    product-random-acesss {\n      entity: product\n      attributes: [ \"*\" ]\n      storage: \"cassandra://\"${cassandra.seed}/${cassandra.product-table}\n      type: primary\n      access: random-access\n    }\n\n    # event stream storage\n    event-commit-log {\n      entity: event\n      attributes: [ \"*\" ]\n      storage: \"kafka://\"${kafka.brokers}/${kafka.events-topic}\n      # this is our commit log\n      type: primary\n      access: commit-log\n    }\n\n    # store events for batch analytics\n    event-batch-storage {\n      entity: event\n      attributes: [ \"*\" ]\n      storage: \"hdfs://\"${hdfs.authority}/${hdfs.event-path}\n      type: replica\n      access: batch-updates\n    }\n\n  }\n\n  cassandra {\n    seed = \"cassandra:9042\"\n    user-table = \"user\"\n    product-table = \"product\"\n    user-event-table = \"user_event\"\n  }\n\n  kafka {\n    brokers = \"kafka1:9092,kafka2:9092,kafka3:9092\"\n    events-topic = \"events\"\n  }\n\n  hdfs {\n    authority = \"hdfs-master\"\n    event-path = \"/events\"\n  }\n\n";
    private final DirectOperator direct;
    private final Config cfg;
    private final RepositoryFactory factory;
    private final Product product;
    private final Event event;
    private final User user;

    public static Model of(Config cfg) {
        return new Model(ConfigRepository.Builder.of((Config)cfg.withFallback((ConfigMergeable)ConfigFactory.parseString((String)GENERATED_FROM))));
    }

    public static Model of(ConfigRepository.Builder builder) {
        return new Model(builder);
    }

    public static Model ofTest(Config config, Repository.Validate ... validations) {
        return new Model(ConfigRepository.Builder.ofTest((Config)config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)GENERATED_FROM))).withValidate(validations));
    }

    public static DirectOperator direct(Config cfg) {
        return Model.of(cfg).direct();
    }

    public static DirectOperator direct(ConfigRepository.Builder builder) {
        return Model.of(builder).direct();
    }

    public DirectOperator direct() {
        return this.direct;
    }

    public DirectDataOperator directOperator() {
        return this.direct.getOperator();
    }

    private Model(ConfigRepository.Builder builder) {
        this.factory = Objects.requireNonNull(builder).build().asFactory();
        Repository repo = this.factory.apply();
        this.cfg = ((ConfigRepository)repo).getConfig();
        this.direct = new DirectOperator();
        this.product = new Product();
        this.event = new Event();
        this.user = new User();
    }

    public Product getProduct() {
        return this.product;
    }

    public Event getEvent() {
        return this.event;
    }

    public User getUser() {
        return this.user;
    }

    public Repository getRepo() {
        return this.factory.apply();
    }

    public class User
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Regular<Example.UserPreferences> preferencesDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<Example.BaseEvent> eventDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<Example.UserDetails> detailsDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<Example.UserPreferences> getPreferencesDescriptor() {
            return this.preferencesDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<Example.BaseEvent> getEventDescriptor() {
            return this.eventDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<Example.UserDetails> getDetailsDescriptor() {
            return this.detailsDescriptor;
        }

        private User() {
            this.descriptor = Model.this.factory.apply().getEntity("user");
            this.preferencesDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("preferences"));
            this.eventDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("event.*"));
            this.detailsDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("details"));
        }
    }

    public class UserWrapper
    implements Serializable {
        private Example.UserPreferences Preferences = null;
        private final Example.UserPreferences PreferencesDefault = (Example.UserPreferences)Model.access$000(Model.this).apply().getEntity("user").getAttribute("preferences").getValueSerializer().getDefault();
        private Example.UserDetails Details = null;
        private final Example.UserDetails DetailsDefault = (Example.UserDetails)Model.access$000(Model.this).apply().getEntity("user").getAttribute("details").getValueSerializer().getDefault();

        private UserWrapper() {
        }

        public Example.UserPreferences getPreferences() {
            return this.Preferences == null ? this.PreferencesDefault : this.Preferences;
        }

        public Example.UserDetails getDetails() {
            return this.Details == null ? this.DetailsDefault : this.Details;
        }
    }

    public class Event
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Regular<Example.BaseEvent> dataDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<Example.BaseEvent> getDataDescriptor() {
            return this.dataDescriptor;
        }

        private Event() {
            this.descriptor = Model.this.factory.apply().getEntity("event");
            this.dataDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("data"));
        }
    }

    public class EventWrapper
    implements Serializable {
        private Example.BaseEvent Data = null;
        private final Example.BaseEvent DataDefault = (Example.BaseEvent)Model.access$000(Model.this).apply().getEntity("event").getAttribute("data").getValueSerializer().getDefault();

        private EventWrapper() {
        }

        public Example.BaseEvent getData() {
            return this.Data == null ? this.DataDefault : this.Data;
        }
    }

    public class Product
    implements Serializable,
    EntityDescriptorProvider {
        private final EntityDescriptor descriptor;
        private final EntityAwareAttributeDescriptor.Regular<Example.Price> priceDescriptor;
        private final EntityAwareAttributeDescriptor.Regular<Example.ProductDetails> detailsDescriptor;
        private final EntityAwareAttributeDescriptor.Wildcard<Example.ProductCategory> categoryDescriptor;

        @Override
        public EntityDescriptor getDescriptor() {
            return this.descriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<Example.Price> getPriceDescriptor() {
            return this.priceDescriptor;
        }

        public EntityAwareAttributeDescriptor.Regular<Example.ProductDetails> getDetailsDescriptor() {
            return this.detailsDescriptor;
        }

        public EntityAwareAttributeDescriptor.Wildcard<Example.ProductCategory> getCategoryDescriptor() {
            return this.categoryDescriptor;
        }

        private Product() {
            this.descriptor = Model.this.factory.apply().getEntity("product");
            this.priceDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("price"));
            this.detailsDescriptor = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("details"));
            this.categoryDescriptor = EntityAwareAttributeDescriptor.Wildcard.of((EntityDescriptor)this.descriptor, (AttributeDescriptor)this.descriptor.getAttribute("category.*"));
        }
    }

    public class ProductWrapper
    implements Serializable {
        private Example.Price Price = null;
        private final Example.Price PriceDefault = (Example.Price)Model.access$000(Model.this).apply().getEntity("product").getAttribute("price").getValueSerializer().getDefault();
        private Example.ProductDetails Details = null;
        private final Example.ProductDetails DetailsDefault = (Example.ProductDetails)Model.access$000(Model.this).apply().getEntity("product").getAttribute("details").getValueSerializer().getDefault();

        private ProductWrapper() {
        }

        public Example.Price getPrice() {
            return this.Price == null ? this.PriceDefault : this.Price;
        }

        public Example.ProductDetails getDetails() {
            return this.Details == null ? this.DetailsDefault : this.Details;
        }
    }

    public class DirectOperator
    implements DataOperatorProvider<DirectDataOperator> {
        private transient DirectDataOperator direct;

        private DirectDataOperator direct() {
            if (this.direct == null) {
                this.direct = (DirectDataOperator)Model.this.factory.apply().getOrCreateOperator(DirectDataOperator.class, new Consumer[0]);
            }
            return this.direct;
        }

        @Override
        public DirectDataOperator getOperator() {
            return this.direct();
        }

        public Optional<CommitLogReader> getCommitLog(AttributeDescriptor<?> ... attributes) {
            HashSet descriptors = new HashSet();
            for (AttributeDescriptor<?> attr : attributes) {
                Set commitLogs = this.direct().getFamiliesForAttribute(attr).stream().filter(af -> af.getDesc().getAccess().canReadCommitLog()).filter(af -> af.getCommitLogReader().isPresent()).collect(Collectors.toSet());
                if (commitLogs.isEmpty()) {
                    return Optional.empty();
                }
                descriptors.addAll(commitLogs);
            }
            if (descriptors.size() > 1) {
                throw new UnsupportedOperationException("Unsupported: multiple commit logs for multiple attributes");
            }
            return ((DirectAttributeFamilyDescriptor)descriptors.stream().findAny().get()).getCommitLogReader();
        }

        public Model parent() {
            return Model.this;
        }
    }

    @FunctionalInterface
    static interface DataOperatorProvider<T extends DataOperator>
    extends Serializable {
        public T getOperator();
    }

    @FunctionalInterface
    static interface EntityDescriptorProvider {
        public EntityDescriptor getDescriptor();
    }
}

