/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct;

import cz.o2.proxima.storage.Partition;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.time.WatermarkSupplier;
import java.io.Serializable;

public interface LogObserver<OffsetT extends Serializable, ContextT extends OnNextContext<OffsetT>>
extends Serializable {
    default public void onCompleted() {
    }

    default public void onCancelled() {
    }

    default public boolean onError(Throwable error) {
        if (error instanceof Error) {
            return this.onFatalError((Error)error);
        }
        if (error instanceof Exception) {
            return this.onException((Exception)error);
        }
        throw new UnsupportedOperationException(String.format("Unknown throwable implementation [%s].", error.getClass()));
    }

    default public boolean onException(Exception exception) {
        throw new IllegalStateException("Unhandled exception.", exception);
    }

    default public boolean onFatalError(Error error) {
        throw error;
    }

    public boolean onNext(StreamElement var1, ContextT var2);

    public static interface OnNextContext<OffsetT extends Serializable>
    extends WatermarkSupplier {
        public Partition getPartition();

        public OffsetT getOffset();
    }
}

