/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.batch;

import cz.o2.proxima.direct.batch.BatchLogObserver;
import cz.o2.proxima.direct.batch.Offset;
import cz.o2.proxima.storage.Partition;
import cz.o2.proxima.time.WatermarkSupplier;
import javax.annotation.Nullable;
import lombok.Generated;

public class BatchLogObservers {
    public static BatchLogObserver.OnNextContext defaultContext(Partition partition) {
        return new SimpleOnNextContext(partition, null, Long.MIN_VALUE);
    }

    public static BatchLogObserver.OnNextContext withWatermarkSupplier(Partition partition, Offset offset, WatermarkSupplier watermark) {
        return new SimpleOnNextContext(partition, offset, watermark.getWatermark());
    }

    public static BatchLogObserver.OnNextContext withWatermark(Partition partition, Offset offset, long watermark) {
        return new SimpleOnNextContext(partition, offset, watermark);
    }

    private BatchLogObservers() {
    }

    private static final class SimpleOnNextContext
    implements BatchLogObserver.OnNextContext {
        private static final long serialVersionUID = 1L;
        private final Partition partition;
        @Nullable
        private final Offset offset;
        private final long watermark;

        @Override
        public Offset getOffset() {
            if (this.offset == null) {
                throw new UnsupportedOperationException("Unable to calculate offset, because the underlying data store is not known to be immutable.");
            }
            return this.offset;
        }

        @Generated
        public SimpleOnNextContext(Partition partition, @Nullable Offset offset, long watermark) {
            this.partition = partition;
            this.offset = offset;
            this.watermark = watermark;
        }

        @Override
        @Generated
        public Partition getPartition() {
            return this.partition;
        }

        @Override
        @Generated
        public long getWatermark() {
            return this.watermark;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleOnNextContext)) {
                return false;
            }
            SimpleOnNextContext other = (SimpleOnNextContext)o;
            if (this.getWatermark() != other.getWatermark()) {
                return false;
            }
            Partition this$partition = this.getPartition();
            Partition other$partition = other.getPartition();
            if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
                return false;
            }
            Offset this$offset = this.getOffset();
            Offset other$offset = other.getOffset();
            return !(this$offset == null ? other$offset != null : !this$offset.equals(other$offset));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $watermark = this.getWatermark();
            result = result * 59 + (int)($watermark >>> 32 ^ $watermark);
            Partition $partition = this.getPartition();
            result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
            Offset $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : $offset.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BatchLogObservers.SimpleOnNextContext(partition=" + this.getPartition() + ", offset=" + this.getOffset() + ", watermark=" + this.getWatermark() + ")";
        }
    }
}

