/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.batch;

import cz.o2.proxima.direct.batch.BatchLogObserver;
import cz.o2.proxima.direct.batch.ObserveHandle;
import cz.o2.proxima.direct.batch.Offset;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.storage.Partition;
import cz.o2.proxima.storage.StreamElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface BatchLogReader {
    default public List<Partition> getPartitions() {
        return this.getPartitions(Long.MIN_VALUE);
    }

    default public List<Partition> getPartitions(long startStamp) {
        return this.getPartitions(startStamp, Long.MAX_VALUE);
    }

    public List<Partition> getPartitions(long var1, long var3);

    public ObserveHandle observe(List<Partition> var1, List<AttributeDescriptor<?>> var2, BatchLogObserver var3);

    default public ObserveHandle observeOffsets(List<Offset> offsets, List<AttributeDescriptor<?>> attributes, final BatchLogObserver observer) {
        final Map partitions = offsets.stream().collect(Collectors.toMap(Offset::getPartition, Function.identity()));
        return this.observe(new ArrayList<Partition>(partitions.keySet()), attributes, new BatchLogObserver(){

            @Override
            public boolean onNext(StreamElement element, BatchLogObserver.OnNextContext context) {
                Offset startOffset = (Offset)partitions.get(context.getPartition());
                if (startOffset.getElementIndex() <= ((Offset)context.getOffset()).getElementIndex()) {
                    observer.onNext(element, context);
                }
                return true;
            }

            @Override
            public void onCompleted() {
                observer.onCompleted();
            }

            @Override
            public void onCancelled() {
                observer.onCancelled();
            }

            @Override
            public boolean onError(Throwable error) {
                return observer.onError(error);
            }
        });
    }

    public Factory<?> asFactory();

    @FunctionalInterface
    public static interface Factory<T extends BatchLogReader>
    extends UnaryFunction<Repository, T> {
    }
}

