/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.batch;

import cz.o2.proxima.direct.batch.BatchLogObserver;
import cz.o2.proxima.direct.batch.ObserveHandle;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminationContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerminationContext.class);
    private final BatchLogObserver observer;
    private final CountDownLatch terminateLatch = new CountDownLatch(1);
    private volatile boolean cancelled = false;
    private volatile Thread runningThread;

    public TerminationContext(BatchLogObserver observer) {
        this.observer = observer;
    }

    public boolean isCancelled() {
        return this.cancelled || this.runningThread == Thread.currentThread() && this.runningThread.isInterrupted();
    }

    public void cancel() {
        this.setCancelled();
        while (!Thread.currentThread().isInterrupted()) {
            ExceptionUtils.ignoringInterrupted((ExceptionUtils.ThrowingRunnable & Serializable)() -> this.terminateLatch.await(1L, TimeUnit.SECONDS));
            if (this.terminateLatch.getCount() <= 0L) break;
            Optional.ofNullable(this.runningThread).ifPresent(Thread::interrupt);
        }
    }

    public void setRunningThread() {
        this.runningThread = Thread.currentThread();
    }

    public void finished() {
        if (this.isCancelled()) {
            this.observer.onCancelled();
        } else {
            this.observer.onCompleted();
        }
        this.terminateLatch.countDown();
    }

    public ObserveHandle asObserveHandle() {
        return () -> {
            this.cancel();
            ExceptionUtils.ignoringInterrupted(this.terminateLatch::await);
        };
    }

    public void handleErrorCaught(Throwable err, Runnable retry) {
        if (ExceptionUtils.isInterrupted((Throwable)err)) {
            this.setCancelled();
            this.finished();
        } else {
            log.warn("Exception while running batch observe", err);
            if (this.observer.onError(err)) {
                retry.run();
            } else {
                this.terminateLatch.countDown();
            }
        }
    }

    private void setCancelled() {
        this.cancelled = true;
    }
}

