/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.commitlog;

import cz.o2.proxima.direct.commitlog.CommitLogObserver;
import cz.o2.proxima.direct.commitlog.ObserveHandle;
import cz.o2.proxima.direct.commitlog.Offset;
import cz.o2.proxima.direct.commitlog.OffsetExternalizer;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.storage.Partition;
import cz.o2.proxima.storage.commitlog.Position;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface CommitLogReader {
    public URI getUri();

    public List<Partition> getPartitions();

    public ObserveHandle observe(String var1, Position var2, CommitLogObserver var3);

    default public ObserveHandle observe(String name, CommitLogObserver observer) {
        return this.observe(name, Position.NEWEST, observer);
    }

    public ObserveHandle observePartitions(String var1, Collection<Partition> var2, Position var3, boolean var4, CommitLogObserver var5);

    default public ObserveHandle observePartitions(Collection<Partition> partitions, Position position, boolean stopAtCurrent, CommitLogObserver observer) {
        return this.observePartitions("unnamed-proxima-bulk-consumer-" + UUID.randomUUID().toString(), partitions, position, stopAtCurrent, observer);
    }

    default public ObserveHandle observePartitions(Collection<Partition> partitions, Position position, CommitLogObserver observer) {
        return this.observePartitions(partitions, position, false, observer);
    }

    default public ObserveHandle observePartitions(Collection<Partition> partitions, CommitLogObserver observer) {
        return this.observePartitions(partitions, Position.NEWEST, observer);
    }

    public ObserveHandle observeBulk(String var1, Position var2, boolean var3, CommitLogObserver var4);

    default public ObserveHandle observeBulk(String name, Position position, CommitLogObserver observer) {
        return this.observeBulk(name, position, false, observer);
    }

    default public ObserveHandle observeBulk(String name, CommitLogObserver observer) {
        return this.observeBulk(name, Position.NEWEST, observer);
    }

    default public ObserveHandle observeBulkPartitions(String name, Collection<Partition> partitions, Position position, CommitLogObserver observer) {
        return this.observeBulkPartitions(name, partitions, position, false, observer);
    }

    public ObserveHandle observeBulkPartitions(String var1, Collection<Partition> var2, Position var3, boolean var4, CommitLogObserver var5);

    default public ObserveHandle observeBulkPartitions(Collection<Partition> partitions, Position position, boolean stopAtCurrent, CommitLogObserver observer) {
        return this.observeBulkPartitions("unnamed-proxima-bulk-consumer-" + UUID.randomUUID().toString(), partitions, position, stopAtCurrent, observer);
    }

    default public ObserveHandle observeBulkPartitions(Collection<Partition> partitions, Position position, CommitLogObserver observer) {
        return this.observeBulkPartitions(partitions, position, false, observer);
    }

    default public ObserveHandle observeBulkOffsets(Collection<Offset> offsets, CommitLogObserver observer) {
        return this.observeBulkOffsets(offsets, false, observer);
    }

    public ObserveHandle observeBulkOffsets(Collection<Offset> var1, boolean var2, CommitLogObserver var3);

    default public boolean hasExternalizableOffsets() {
        return false;
    }

    default public OffsetExternalizer getOffsetExternalizer() {
        if (this.hasExternalizableOffsets()) {
            throw new IllegalStateException("Not implemented yet");
        }
        throw new UnsupportedOperationException("Offsets are not externalizable");
    }

    default public boolean restoresSequentialIds() {
        return false;
    }

    default public Map<Partition, Offset> fetchOffsets(Position position, List<Partition> partitions) {
        if (!this.hasExternalizableOffsets()) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not have externalizable offsets. Fetch offsets not supported.");
        }
        throw new IllegalStateException("Unimplemented. This is bug, please file an issue");
    }

    public Factory<?> asFactory();

    @FunctionalInterface
    public static interface Factory<T extends CommitLogReader>
    extends UnaryFunction<Repository, T> {
    }
}

