/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.commitlog;

import cz.o2.proxima.direct.commitlog.CommitLogObserver;
import cz.o2.proxima.direct.commitlog.CommitLogObservers;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.storage.StreamElement;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryableLogObserver
implements CommitLogObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryableLogObserver.class);
    private final int maxRetries;
    private final String name;
    UnaryFunction<Throwable, CommitLogObservers.TerminationStrategy> onRetriesExhausted;
    final boolean retryErrors;
    private int numFailures;
    private final CommitLogObserver delegate;

    RetryableLogObserver(String name, int maxRetries, UnaryFunction<Throwable, CommitLogObservers.TerminationStrategy> onRetriesExhausted, boolean retryErrors, CommitLogObserver delegate) {
        this.maxRetries = maxRetries;
        this.name = name;
        this.onRetriesExhausted = onRetriesExhausted;
        this.retryErrors = retryErrors;
        this.delegate = delegate;
    }

    @Override
    public final boolean onNext(StreamElement ingest, CommitLogObserver.OnNextContext context) {
        boolean ret = this.delegate.onNext(ingest, context);
        this.numFailures = 0;
        return ret;
    }

    @Override
    public boolean onError(Throwable throwable) {
        if (this.delegate.onError(throwable) && (this.retryErrors || !(throwable instanceof Error)) && ++this.numFailures <= this.maxRetries) {
            log.error("Error in observer {}, retry {} out of {}", new Object[]{this.name, this.numFailures, this.maxRetries, throwable});
            return true;
        }
        log.error("Error in observer {} (non-retryable)", (Object)this.name, (Object)throwable);
        CommitLogObservers.TerminationStrategy strategy = (CommitLogObservers.TerminationStrategy)((Object)this.onRetriesExhausted.apply((Object)throwable));
        return RetryableLogObserver.handleThrowableWithStrategy(this.name, throwable, strategy);
    }

    @VisibleForTesting
    static boolean handleThrowableWithStrategy(String name, Throwable throwable, CommitLogObservers.TerminationStrategy strategy) {
        switch (strategy) {
            case EXIT: {
                log.error("Exception caught processing {}. Exiting.", (Object)name, (Object)throwable);
                System.exit(1);
            }
            case STOP_PROCESSING: {
                log.error("Exception caught processing {}. Terminating consumption as requested.", (Object)name, (Object)throwable);
                return false;
            }
            case RETHROW: {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new IllegalStateException("Retries exhausted retrying observer " + name, throwable);
            }
        }
        throw new IllegalStateException(String.format("Unknown TerminationStrategy %s in %s", new Object[]{strategy, name}), throwable);
    }

    @Override
    public void onCompleted() {
        this.delegate.onCompleted();
    }

    @Override
    public void onCancelled() {
        this.delegate.onCancelled();
    }

    @Override
    public void onRepartition(CommitLogObserver.OnRepartitionContext context) {
        this.delegate.onRepartition(context);
    }

    @Override
    public void onIdle(CommitLogObserver.OnIdleContext context) {
        this.delegate.onIdle(context);
    }

    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

