/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.core;

import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;

@FunctionalInterface
public interface CommitCallback {
    public static CommitCallback afterNumCommits(int numCommits, CommitCallback delegate) {
        Preconditions.checkState((numCommits > 0 ? 1 : 0) != 0, (String)"numCommits must be positive, got %s", (int)numCommits);
        AtomicInteger missingCommits = new AtomicInteger(numCommits);
        return (succ, exc) -> {
            if (succ) {
                if (missingCommits.decrementAndGet() == 0) {
                    delegate.commit(true, null);
                }
            } else if (missingCommits.get() > 0) {
                missingCommits.set(-1);
                delegate.commit(false, exc);
            }
        };
    }

    public static CommitCallback noop() {
        return (success, error) -> {};
    }

    public void commit(boolean var1, Throwable var2);
}

