/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.core;

import cz.o2.proxima.direct.core.ContextProvider;
import cz.o2.proxima.direct.core.DirectAttributeFamilyDescriptor;
import cz.o2.proxima.functional.Factory;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class Context
implements Serializable,
ContextProvider {
    private static final long serialVersionUID = 1L;
    private final UnaryFunction<AttributeFamilyDescriptor, DirectAttributeFamilyDescriptor> resolver;
    private final Factory<ExecutorService> executorFactory;
    private transient boolean initialized = false;
    private transient ExecutorService service;

    protected Context(UnaryFunction<AttributeFamilyDescriptor, DirectAttributeFamilyDescriptor> attributeFamilyResolver, Factory<ExecutorService> executorFactory) {
        this.resolver = Objects.requireNonNull(attributeFamilyResolver);
        this.executorFactory = Objects.requireNonNull(executorFactory);
    }

    public ExecutorService getExecutorService() {
        this.initialize();
        return this.service;
    }

    @VisibleForTesting
    public Factory<ExecutorService> getExecutorFactory() {
        return this.executorFactory;
    }

    public Optional<DirectAttributeFamilyDescriptor> resolve(AttributeFamilyDescriptor family) {
        return Optional.ofNullable(this.resolver.apply((Object)family));
    }

    public DirectAttributeFamilyDescriptor resolveRequired(AttributeFamilyDescriptor family) {
        DirectAttributeFamilyDescriptor result = (DirectAttributeFamilyDescriptor)this.resolver.apply((Object)family);
        if (result == null) {
            throw new IllegalStateException("Missing direct family descriptor for " + family);
        }
        return result;
    }

    private synchronized void initialize() {
        if (!this.initialized) {
            this.service = (ExecutorService)this.executorFactory.apply();
            this.initialized = true;
        }
    }

    @Override
    public Context getContext() {
        return this;
    }
}

