/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.core;

import cz.o2.proxima.direct.batch.BatchLogReader;
import cz.o2.proxima.direct.commitlog.CommitLogReader;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.core.DataAccessor;
import cz.o2.proxima.direct.randomaccess.RandomAccessReader;
import cz.o2.proxima.direct.view.CachedView;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import cz.o2.proxima.util.ExceptionUtils;
import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;

public class DirectAttributeFamilyDescriptor
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final AttributeFamilyDescriptor desc;
    private final RepositoryFactory repositoryFactory;
    @Nullable
    private final AttributeWriterBase.Factory<?> writerFactory;
    @Nullable
    private final CommitLogReader.Factory<?> commitLogReaderFactory;
    @Nullable
    private final BatchLogReader.Factory<?> batchReaderFactory;
    @Nullable
    private final RandomAccessReader.Factory<?> randomAccessReaderFactory;
    @Nullable
    private final CachedView.Factory cachedViewFactory;
    @Nullable
    private transient AttributeWriterBase writer;
    @Nullable
    private transient CommitLogReader commitLogReader;
    @Nullable
    private transient BatchLogReader batchReader;
    @Nullable
    private transient RandomAccessReader randomAccessReader;
    @Nullable
    private transient CachedView cachedView;
    @Nullable
    private transient Repository repo;

    DirectAttributeFamilyDescriptor(Repository repository, AttributeFamilyDescriptor desc, Optional<AttributeWriterBase> writer, Optional<CommitLogReader> commitLogReader, Optional<BatchLogReader> batchLogReader, Optional<RandomAccessReader> randomAccessReader, Optional<CachedView> cachedView) {
        this.repositoryFactory = repository.asFactory();
        this.desc = desc;
        this.writerFactory = writer.map(AttributeWriterBase::asFactory).orElse(null);
        this.commitLogReaderFactory = commitLogReader.map(CommitLogReader::asFactory).orElse(null);
        this.batchReaderFactory = batchLogReader.map(BatchLogReader::asFactory).orElse(null);
        this.randomAccessReaderFactory = randomAccessReader.map(RandomAccessReader::asFactory).orElse(null);
        this.cachedViewFactory = cachedView.map(CachedView::asFactory).orElse(null);
        this.writer = writer.orElse(null);
        this.commitLogReader = commitLogReader.orElse(null);
        this.batchReader = batchLogReader.orElse(null);
        this.randomAccessReader = randomAccessReader.orElse(null);
        this.cachedView = cachedView.orElse(null);
    }

    DirectAttributeFamilyDescriptor(Repository repo, AttributeFamilyDescriptor desc, Context context, DataAccessor accessor) {
        this(repo, desc, accessor.getWriter(context), accessor.getCommitLogReader(context), accessor.getBatchLogReader(context), accessor.getRandomAccessReader(context), accessor.getCachedView(context));
        this.closeAll();
    }

    private void closeAll() {
        Optional.ofNullable(this.writer).ifPresent(AttributeWriterBase::close);
        Optional.ofNullable(this.randomAccessReader).ifPresent(arg_0 -> ((Consumer)ExceptionUtils.uncheckedConsumer(Closeable::close)).accept(arg_0));
        Optional.ofNullable(this.cachedView).ifPresent(CachedView::close);
        this.writer = null;
        this.randomAccessReader = null;
        this.cachedView = null;
    }

    public List<AttributeDescriptor<?>> getAttributes() {
        return this.desc.getAttributes();
    }

    public String toString() {
        return this.desc.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectAttributeFamilyDescriptor) {
            DirectAttributeFamilyDescriptor other = (DirectAttributeFamilyDescriptor)obj;
            return other.desc.equals((Object)this.desc);
        }
        return false;
    }

    public int hashCode() {
        return this.desc.hashCode();
    }

    public Optional<AttributeWriterBase> getWriter() {
        if (!this.desc.getAccess().isReadonly()) {
            return Optional.of(Objects.requireNonNull(this.writer(), () -> "Family " + this.desc.getName() + " has no writer"));
        }
        return Optional.empty();
    }

    private AttributeWriterBase writer() {
        if (this.writer == null) {
            this.writer = (AttributeWriterBase)Objects.requireNonNull(this.writerFactory).apply(this.repo());
        }
        return this.writer;
    }

    public Optional<CommitLogReader> getCommitLogReader() {
        if (this.desc.getAccess().canReadCommitLog()) {
            return Optional.of(Objects.requireNonNull(this.commitLogReader(), () -> "Family " + this.desc.getName() + " doesn't have commit-log reader"));
        }
        return Optional.empty();
    }

    private CommitLogReader commitLogReader() {
        if (this.commitLogReader == null) {
            this.commitLogReader = (CommitLogReader)Objects.requireNonNull(this.commitLogReaderFactory).apply(this.repo());
        }
        return this.commitLogReader;
    }

    public Optional<BatchLogReader> getBatchReader() {
        if (this.hasBatchReader()) {
            return Optional.of(Objects.requireNonNull(this.batchReader(), () -> "Family " + this.desc.getName() + " doesn't have batch reader"));
        }
        return Optional.empty();
    }

    private BatchLogReader batchReader() {
        if (this.batchReader == null) {
            this.batchReader = (BatchLogReader)Objects.requireNonNull(this.batchReaderFactory).apply(this.repo());
        }
        return this.batchReader;
    }

    public Optional<RandomAccessReader> getRandomAccessReader() {
        if (this.hasRandomAccessReader()) {
            return Optional.of(Objects.requireNonNull(this.randomAccessReader(), () -> "Family " + this.desc.getName() + " doesn't have random access reader"));
        }
        return Optional.empty();
    }

    private RandomAccessReader randomAccessReader() {
        if (this.randomAccessReader == null) {
            this.randomAccessReader = (RandomAccessReader)Objects.requireNonNull(this.randomAccessReaderFactory).apply(this.repo());
        }
        return this.randomAccessReader;
    }

    public Optional<CachedView> getCachedView() {
        if (this.hasCachedView()) {
            return Optional.of(Objects.requireNonNull(this.cachedView(), () -> "Family " + this.desc.getName() + " cannot create cached view"));
        }
        return Optional.empty();
    }

    private CachedView cachedView() {
        if (this.cachedView == null) {
            this.cachedView = (CachedView)Objects.requireNonNull(this.cachedViewFactory).apply(this.repo());
        }
        return this.cachedView;
    }

    public Optional<String> getSource() {
        return this.desc.getSource();
    }

    boolean hasBatchReader() {
        return this.desc.getAccess().canReadBatchSnapshot() || this.desc.getAccess().canReadBatchUpdates();
    }

    boolean hasCachedView() {
        return this.desc.getAccess().canCreateCachedView();
    }

    boolean hasCommitLogReader() {
        return this.desc.getAccess().canReadCommitLog();
    }

    boolean hasRandomAccessReader() {
        return this.desc.getAccess().canRandomRead();
    }

    private Repository repo() {
        if (this.repo == null) {
            this.repo = this.repositoryFactory.apply();
        }
        return this.repo;
    }

    @Generated
    public AttributeFamilyDescriptor getDesc() {
        return this.desc;
    }
}

