/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.core;

import cz.o2.proxima.direct.batch.BatchLogObserver;
import cz.o2.proxima.direct.batch.BatchLogReader;
import cz.o2.proxima.direct.batch.ObserveHandle;
import cz.o2.proxima.direct.commitlog.CommitLogObserver;
import cz.o2.proxima.direct.commitlog.CommitLogReader;
import cz.o2.proxima.direct.commitlog.Offset;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.CommitCallback;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.core.DirectAttributeFamilyDescriptor;
import cz.o2.proxima.direct.core.OnlineAttributeWriter;
import cz.o2.proxima.direct.randomaccess.KeyValue;
import cz.o2.proxima.direct.randomaccess.RandomAccessReader;
import cz.o2.proxima.direct.randomaccess.RandomOffset;
import cz.o2.proxima.direct.randomaccess.RawOffset;
import cz.o2.proxima.direct.view.CachedView;
import cz.o2.proxima.direct.view.LocalCachedPartitionedView;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.repository.AttributeFamilyProxyDescriptor;
import cz.o2.proxima.repository.AttributeProxyDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.storage.Partition;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.storage.commitlog.Position;
import cz.o2.proxima.transform.ElementWiseProxyTransform;
import cz.o2.proxima.transform.ProxyTransform;
import cz.o2.proxima.util.Pair;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectAttributeFamilyProxyDescriptor
extends DirectAttributeFamilyDescriptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DirectAttributeFamilyProxyDescriptor.class);
    private static final long serialVersionUID = 1L;

    static DirectAttributeFamilyProxyDescriptor of(Repository repo, Context context, AttributeFamilyProxyDescriptor proxy) {
        return new DirectAttributeFamilyProxyDescriptor(repo, context, proxy, new AttrLookup(proxy));
    }

    private static Optional<CommitLogReader> getCommitLogReader(AttrLookup lookup, Context context, AttributeFamilyProxyDescriptor desc) {
        return context.resolve(desc.getTargetFamilyRead()).flatMap(DirectAttributeFamilyDescriptor::getCommitLogReader).map(reader -> new ProxyCommitLogReader((CommitLogReader)reader, lookup));
    }

    DirectAttributeFamilyProxyDescriptor(Repository repo, Context context, AttributeFamilyProxyDescriptor desc, AttrLookup lookup) {
        super(repo, (AttributeFamilyDescriptor)desc, DirectAttributeFamilyProxyDescriptor.getWriter(lookup, context, desc), DirectAttributeFamilyProxyDescriptor.getCommitLogReader(lookup, context, desc), DirectAttributeFamilyProxyDescriptor.getBatchReader(lookup, context, desc), DirectAttributeFamilyProxyDescriptor.getRandomAccess(lookup, context, desc), DirectAttributeFamilyProxyDescriptor.getPartitionedCachedView(lookup, context, desc));
    }

    private static Optional<AttributeWriterBase> getWriter(AttrLookup lookup, Context context, AttributeFamilyProxyDescriptor desc) {
        URI uri = desc.getStorageUri();
        Optional w = context.resolve(desc.getTargetFamilyWrite()).flatMap(DirectAttributeFamilyDescriptor::getWriter);
        if (!w.isPresent() || !(w.get() instanceof OnlineAttributeWriter)) {
            return Optional.empty();
        }
        OnlineAttributeWriter writer = ((AttributeWriterBase)w.get()).online();
        return Optional.of(new ProxyOnlineAttributeWriter(writer, lookup, uri));
    }

    private static Optional<BatchLogReader> getBatchReader(AttrLookup lookup, Context context, AttributeFamilyProxyDescriptor desc) {
        return context.resolve(desc.getTargetFamilyRead()).flatMap(DirectAttributeFamilyDescriptor::getBatchReader).map(reader -> new ProxyBatchLogReader((BatchLogReader)reader, lookup));
    }

    private static Optional<RandomAccessReader> getRandomAccess(AttrLookup lookup, Context context, AttributeFamilyProxyDescriptor desc) {
        return context.resolve(desc.getTargetFamilyRead()).flatMap(DirectAttributeFamilyDescriptor::getRandomAccessReader).map(reader -> new ProxyRandomAccessReader((RandomAccessReader)reader, lookup));
    }

    private static Optional<CachedView> getPartitionedCachedView(AttrLookup lookup, Context context, AttributeFamilyProxyDescriptor desc) {
        if (desc.getTargetFamilyRead().getAccess().canReadCommitLog() && !desc.getTargetFamilyWrite().getAccess().isReadonly() && desc.getTargetFamilyRead().getAccess().canCreateCachedView()) {
            Optional<CommitLogReader> maybeReader = DirectAttributeFamilyProxyDescriptor.getCommitLogReader(lookup, context, desc);
            Optional<OnlineAttributeWriter> maybeWriter = DirectAttributeFamilyProxyDescriptor.getWriter(lookup, context, desc).map(AttributeWriterBase::online);
            if (maybeReader.isPresent() && maybeWriter.isPresent()) {
                return Optional.of(new LocalCachedPartitionedView(desc.getTargetFamilyRead().getEntity(), maybeReader.get(), maybeWriter.get()));
            }
        }
        return Optional.empty();
    }

    private static CommitLogObserver wrapTransformed(final AttrLookup lookup, final CommitLogObserver observer) {
        return new CommitLogObserver(){

            @Override
            public boolean onNext(StreamElement ingest, CommitLogObserver.OnNextContext context) {
                try {
                    return lookup.lookupRead(ingest.getAttributeDescriptor().getName()).stream().map(attr -> observer.onNext(DirectAttributeFamilyProxyDescriptor.transformToProxy(ingest, attr), context)).filter(c -> c == false).findFirst().orElse(true);
                }
                catch (Exception ex) {
                    log.error("Failed to transform ingest {}", (Object)ingest, (Object)ex);
                    context.fail(ex);
                    return false;
                }
            }

            @Override
            public void onRepartition(CommitLogObserver.OnRepartitionContext context) {
                observer.onRepartition(context);
            }

            @Override
            public void onIdle(CommitLogObserver.OnIdleContext context) {
                observer.onIdle(context);
            }

            @Override
            public void onCompleted() {
                observer.onCompleted();
            }

            @Override
            public void onCancelled() {
                observer.onCancelled();
            }

            @Override
            public boolean onError(Throwable error) {
                return observer.onError(error);
            }
        };
    }

    static BatchLogObserver wrapTransformed(final AttrLookup lookup, final BatchLogObserver observer) {
        return new BatchLogObserver(){

            @Override
            public boolean onNext(StreamElement ingest, BatchLogObserver.OnNextContext context) {
                try {
                    return lookup.lookupRead(ingest.getAttributeDescriptor().getName()).stream().map(attr -> observer.onNext(DirectAttributeFamilyProxyDescriptor.transformToProxy(ingest, attr), context)).filter(c -> c == false).findFirst().orElse(true);
                }
                catch (Exception ex) {
                    log.error("Failed to transform ingest {}", (Object)ingest, (Object)ex);
                    return true;
                }
            }

            @Override
            public void onCompleted() {
                observer.onCompleted();
            }

            @Override
            public boolean onError(Throwable error) {
                return observer.onError(error);
            }

            @Override
            public void onCancelled() {
                observer.onCancelled();
            }
        };
    }

    private static StreamElement transformToRaw(StreamElement data, AttributeProxyDescriptor<?> targetDesc) {
        return DirectAttributeFamilyProxyDescriptor.transform(data, targetDesc.getWriteTarget(), (UnaryFunction<String, String>)((UnaryFunction & Serializable)arg_0 -> ((ElementWiseProxyTransform)targetDesc.getWriteTransform().asElementWise()).fromProxy(arg_0)));
    }

    private static StreamElement transformToRawRead(StreamElement data, AttributeProxyDescriptor<?> targetReadDesc) {
        return DirectAttributeFamilyProxyDescriptor.transform(data, targetReadDesc.getReadTarget(), (UnaryFunction<String, String>)((UnaryFunction & Serializable)arg_0 -> ((ElementWiseProxyTransform)targetReadDesc.getReadTransform().asElementWise()).fromProxy(arg_0)));
    }

    private static StreamElement transformToProxy(StreamElement data, AttributeProxyDescriptor<?> targetDesc) {
        return DirectAttributeFamilyProxyDescriptor.transform(data, targetDesc, (UnaryFunction<String, String>)((UnaryFunction & Serializable)arg_0 -> ((ElementWiseProxyTransform)targetDesc.getReadTransform().asElementWise()).toProxy(arg_0)));
    }

    private static <T> KeyValue<T> transformKvToProxy(KeyValue<T> kv, AttributeProxyDescriptor<T> targetDesc) {
        return KeyValue.of(kv.getEntityDescriptor(), targetDesc, kv.getKey(), targetDesc.getReadTransform().asElementWise().toProxy(kv.getAttribute()), kv.getOffset(), kv.getParsedRequired(), kv.getValue(), kv.getStamp());
    }

    private static StreamElement transform(StreamElement data, AttributeDescriptor<?> target, UnaryFunction<String, String> transform) {
        if (data.isDeleteWildcard()) {
            return StreamElement.deleteWildcard((EntityDescriptor)data.getEntityDescriptor(), target, (String)data.getUuid(), (String)data.getKey(), (String)((String)transform.apply((Object)data.getAttribute())), (long)data.getStamp());
        }
        if (data.isDelete()) {
            return StreamElement.delete((EntityDescriptor)data.getEntityDescriptor(), target, (String)data.getUuid(), (String)data.getKey(), (String)((String)transform.apply((Object)data.getAttribute())), (long)data.getStamp());
        }
        return StreamElement.upsert((EntityDescriptor)data.getEntityDescriptor(), target, (String)data.getUuid(), (String)data.getKey(), (String)((String)transform.apply((Object)data.getAttribute())), (long)data.getStamp(), (byte[])data.getValue());
    }

    private static String toAttrName(String key) {
        int index = key.indexOf(46);
        if (index > 0) {
            return key.substring(0, index) + ".*";
        }
        return key;
    }

    private static class ProxyBatchLogReader
    implements BatchLogReader {
        private final BatchLogReader reader;
        private final AttrLookup lookup;

        public ProxyBatchLogReader(BatchLogReader reader, AttrLookup lookup) {
            this.reader = reader;
            this.lookup = lookup;
        }

        @Override
        public List<Partition> getPartitions(long startStamp, long endStamp) {
            return this.reader.getPartitions(startStamp, endStamp);
        }

        @Override
        public ObserveHandle observe(List<Partition> partitions, List<AttributeDescriptor<?>> attributes, BatchLogObserver observer) {
            return this.reader.observe(partitions, attributes.stream().map(a -> this.lookup.lookupProxy(a.getName())).collect(Collectors.toList()), DirectAttributeFamilyProxyDescriptor.wrapTransformed(this.lookup, observer));
        }

        @Override
        public BatchLogReader.Factory<?> asFactory() {
            BatchLogReader.Factory<?> readerFactory = this.reader.asFactory();
            AttrLookup lookup = this.lookup;
            return (BatchLogReader.Factory & Serializable)repo -> new ProxyBatchLogReader((BatchLogReader)readerFactory.apply(repo), lookup);
        }
    }

    private static class ProxyRandomAccessReader
    implements RandomAccessReader {
        private final RandomAccessReader reader;
        private final AttrLookup lookup;

        public ProxyRandomAccessReader(RandomAccessReader reader, AttrLookup lookup) {
            this.reader = reader;
            this.lookup = lookup;
        }

        @Override
        public RandomOffset fetchOffset(RandomAccessReader.Listing type, String key) {
            if (type == RandomAccessReader.Listing.ATTRIBUTE && !key.isEmpty()) {
                return this.reader.fetchOffset(type, this.lookup.lookupProxy(DirectAttributeFamilyProxyDescriptor.toAttrName(key)).getReadTransform().asElementWise().fromProxy(key));
            }
            return this.reader.fetchOffset(type, key);
        }

        @Override
        public <T> Optional<KeyValue<T>> get(String key, String attribute, AttributeDescriptor<T> desc, long stamp) {
            AttributeProxyDescriptor<?> targetAttribute = this.lookup.lookupProxy(desc.getName());
            ProxyTransform transform = targetAttribute.getReadTransform();
            return this.reader.get(key, transform.asElementWise().fromProxy(attribute), targetAttribute.getReadTarget(), stamp).map(kv -> DirectAttributeFamilyProxyDescriptor.transformKvToProxy(kv, targetAttribute));
        }

        @Override
        public <T> void scanWildcard(String key, AttributeDescriptor<T> wildcard, RandomOffset offset, long stamp, int limit, Consumer<KeyValue<T>> consumer) {
            AttributeProxyDescriptor<?> targetAttribute = this.lookup.lookupProxy(wildcard.getName());
            if (!targetAttribute.isWildcard()) {
                throw new IllegalArgumentException("Proxy target is not wildcard attribute!");
            }
            Preconditions.checkArgument((offset == null || offset instanceof RawOffset ? 1 : 0) != 0, (String)"Scanning through proxy can be done with RawOffests only, got %s", (Object)offset);
            this.reader.scanWildcard(key, targetAttribute.getReadTarget(), offset, stamp, limit, (Consumer & Serializable)kv -> consumer.accept((Object)DirectAttributeFamilyProxyDescriptor.transformKvToProxy(kv, targetAttribute)));
        }

        @Override
        public void scanWildcardAll(String key, RandomOffset offset, long stamp, int limit, Consumer<KeyValue<?>> consumer) {
            this.reader.scanWildcardAll(key, offset, stamp, limit, (Consumer & Serializable)kv -> this.lookup.lookupRead(kv.getAttributeDescriptor().getName()).forEach(attr -> consumer.accept((Object)DirectAttributeFamilyProxyDescriptor.transformKvToProxy(kv, attr))));
        }

        @Override
        public void listEntities(RandomOffset offset, int limit, Consumer<Pair<RandomOffset, String>> consumer) {
            this.reader.listEntities(offset, limit, consumer);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public EntityDescriptor getEntityDescriptor() {
            return this.reader.getEntityDescriptor();
        }

        @Override
        public RandomAccessReader.Factory<?> asFactory() {
            RandomAccessReader.Factory<?> readerFactory = this.reader.asFactory();
            AttrLookup lookup = this.lookup;
            return (RandomAccessReader.Factory & Serializable)repo -> new ProxyRandomAccessReader((RandomAccessReader)readerFactory.apply(repo), lookup);
        }
    }

    private static class ProxyCommitLogReader
    implements CommitLogReader {
        private final CommitLogReader reader;
        private final AttrLookup lookup;

        public ProxyCommitLogReader(CommitLogReader reader, AttrLookup lookup) {
            this.reader = reader;
            this.lookup = lookup;
        }

        @Override
        public URI getUri() {
            return this.reader.getUri();
        }

        @Override
        public List<Partition> getPartitions() {
            return this.reader.getPartitions();
        }

        @Override
        public cz.o2.proxima.direct.commitlog.ObserveHandle observe(String name, Position position, CommitLogObserver observer) {
            return this.reader.observe(name, position, DirectAttributeFamilyProxyDescriptor.wrapTransformed(this.lookup, observer));
        }

        @Override
        public cz.o2.proxima.direct.commitlog.ObserveHandle observePartitions(String name, Collection<Partition> partitions, Position position, boolean stopAtCurrent, CommitLogObserver observer) {
            return this.reader.observePartitions(name, partitions, position, stopAtCurrent, DirectAttributeFamilyProxyDescriptor.wrapTransformed(this.lookup, observer));
        }

        @Override
        public cz.o2.proxima.direct.commitlog.ObserveHandle observePartitions(Collection<Partition> partitions, Position position, boolean stopAtCurrent, CommitLogObserver observer) {
            return this.reader.observePartitions(partitions, position, stopAtCurrent, DirectAttributeFamilyProxyDescriptor.wrapTransformed(this.lookup, observer));
        }

        @Override
        public cz.o2.proxima.direct.commitlog.ObserveHandle observeBulk(String name, Position position, boolean stopAtCurrent, CommitLogObserver observer) {
            return this.reader.observeBulk(name, position, stopAtCurrent, DirectAttributeFamilyProxyDescriptor.wrapTransformed(this.lookup, observer));
        }

        @Override
        public cz.o2.proxima.direct.commitlog.ObserveHandle observeBulkPartitions(Collection<Partition> partitions, Position position, boolean stopAtCurrent, CommitLogObserver observer) {
            return this.reader.observeBulkPartitions(partitions, position, stopAtCurrent, DirectAttributeFamilyProxyDescriptor.wrapTransformed(this.lookup, observer));
        }

        @Override
        public cz.o2.proxima.direct.commitlog.ObserveHandle observeBulkPartitions(String name, Collection<Partition> partitions, Position position, boolean stopAtCurrent, CommitLogObserver observer) {
            return this.reader.observeBulkPartitions(name, partitions, position, stopAtCurrent, DirectAttributeFamilyProxyDescriptor.wrapTransformed(this.lookup, observer));
        }

        @Override
        public cz.o2.proxima.direct.commitlog.ObserveHandle observeBulkOffsets(Collection<Offset> offsets, boolean stopAtCurrent, CommitLogObserver observer) {
            return this.reader.observeBulkOffsets(offsets, stopAtCurrent, DirectAttributeFamilyProxyDescriptor.wrapTransformed(this.lookup, observer));
        }

        @Override
        public CommitLogReader.Factory<?> asFactory() {
            CommitLogReader.Factory<?> readerFactory = this.reader.asFactory();
            AttrLookup lookup = this.lookup;
            return (CommitLogReader.Factory & Serializable)repo -> new ProxyCommitLogReader((CommitLogReader)readerFactory.apply(repo), lookup);
        }
    }

    private static class ProxyOnlineAttributeWriter
    implements OnlineAttributeWriter {
        private final OnlineAttributeWriter writer;
        private final AttrLookup lookup;
        private final URI uri;

        public ProxyOnlineAttributeWriter(OnlineAttributeWriter writer, AttrLookup lookup, URI uri) {
            this.writer = writer;
            this.lookup = lookup;
            this.uri = uri;
        }

        @Override
        public void rollback() {
            this.writer.rollback();
        }

        @Override
        public void write(StreamElement data, CommitCallback statusCallback) {
            AttributeProxyDescriptor<?> target = this.lookup.lookupProxy(data.getAttributeDescriptor().getName());
            log.debug("proxying write of {} to target {} using writer {}", new Object[]{data, target, this.writer.getUri()});
            this.writer.write(DirectAttributeFamilyProxyDescriptor.transformToRaw(data, target), statusCallback);
        }

        @Override
        public OnlineAttributeWriter.Factory<?> asFactory() {
            AttributeWriterBase.Factory writerFactory = this.writer.asFactory();
            AttrLookup lookup = this.lookup;
            URI uri = this.uri;
            return arg_0 -> ProxyOnlineAttributeWriter.lambda$asFactory$bf9abbc1$1((OnlineAttributeWriter.Factory)writerFactory, lookup, uri, arg_0);
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public void close() {
            this.writer.close();
        }

        private static /* synthetic */ OnlineAttributeWriter lambda$asFactory$bf9abbc1$1(OnlineAttributeWriter.Factory writerFactory, AttrLookup lookup, URI uri, Repository repo) {
            return new ProxyOnlineAttributeWriter((OnlineAttributeWriter)writerFactory.apply(repo), lookup, uri);
        }
    }

    static class AttrLookup
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<AttributeProxyDescriptor<?>> attrs;
        private final Map<String, AttributeProxyDescriptor<?>> proxyNameToDesc;
        private final Map<String, List<AttributeProxyDescriptor<?>>> readNameToDesc;
        private final String familyName;

        AttrLookup(AttributeFamilyProxyDescriptor proxy) {
            this.familyName = proxy.getName();
            this.attrs = proxy.getAttributes().stream().map(AttributeDescriptor::asProxy).collect(Collectors.toList());
            this.proxyNameToDesc = this.attrs.stream().collect(Collectors.toMap(AttributeDescriptor::getName, Function.identity()));
            this.readNameToDesc = this.attrs.stream().map(a -> Pair.of((Object)a.getReadTarget().getName(), (Object)a)).collect(Collectors.groupingBy(Pair::getFirst, Collectors.mapping(Pair::getSecond, Collectors.toList())));
        }

        List<AttributeProxyDescriptor<?>> lookupRead(String name) {
            List<AttributeProxyDescriptor<?>> read = this.readNameToDesc.get(name);
            if (read == null) {
                log.debug("Fallbacking to lookup of proxy attribute with name {} in family {}. ", (Object)name, (Object)this.familyName);
                try {
                    return Collections.singletonList(this.lookupProxy(name));
                }
                catch (Exception ex) {
                    log.warn("Error during lookup of {} in family {}.This might indicate serious problem.", new Object[]{name, this.familyName, ex});
                    return Collections.emptyList();
                }
            }
            return read;
        }

        AttributeProxyDescriptor<?> lookupProxy(String name) {
            return this.lookup(this.proxyNameToDesc, name);
        }

        private <T> T lookup(Map<String, T> map, String name) {
            T result = map.get(name);
            if (result != null) {
                return result;
            }
            int index = name.lastIndexOf(36);
            if (index >= 0 && index < name.length() - 1) {
                String truncated = name.substring(index + 1);
                log.warn("Truncating name {} to {}", (Object)name, (Object)truncated);
                return this.lookup(map, truncated);
            }
            throw new IllegalStateException("Missing name " + name + " in " + map);
        }

        @Generated
        public List<AttributeProxyDescriptor<?>> getAttrs() {
            return this.attrs;
        }
    }
}

