/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.core;

import com.google.auto.service.AutoService;
import cz.o2.proxima.direct.core.AbstractOnlineAttributeWriter;
import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.CommitCallback;
import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.core.DataAccessor;
import cz.o2.proxima.direct.core.DataAccessorFactory;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.direct.core.OnlineAttributeWriter;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.storage.internal.AbstractDataAccessorFactory;
import java.io.Serializable;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;

@AutoService(value={DataAccessorFactory.class})
public class StdoutStorage
implements DataAccessorFactory {
    private static final long serialVersionUID = 1L;

    public AbstractDataAccessorFactory.Accept accepts(URI uri) {
        return uri.getScheme().equals("stdout") ? AbstractDataAccessorFactory.Accept.ACCEPT : AbstractDataAccessorFactory.Accept.REJECT;
    }

    public DataAccessor createAccessor(DirectDataOperator operator, AttributeFamilyDescriptor familyDescriptor) {
        return new StdoutDataAccessor(familyDescriptor.getEntity(), familyDescriptor.getStorageUri());
    }

    private static class StdoutDataAccessor
    implements DataAccessor {
        private static final long serialVersionUID = 1L;
        private final EntityDescriptor entity;
        private final URI uri;

        public StdoutDataAccessor(EntityDescriptor entity, URI uri) {
            this.entity = entity;
            this.uri = uri;
        }

        @Override
        public Optional<AttributeWriterBase> getWriter(final Context context) {
            return Optional.of(new AbstractOnlineAttributeWriter(this.entity, this.uri){

                @Override
                public void write(StreamElement data, CommitCallback callback) {
                    System.out.println(String.format("Writing entity %s to attribute %s with key %s and value of size %d", data.getEntityDescriptor(), data.getAttributeDescriptor(), data.getKey(), data.getValue().length));
                    callback.commit(true, null);
                }

                @Override
                public OnlineAttributeWriter.Factory<?> asFactory() {
                    return (OnlineAttributeWriter.Factory & Serializable)repo -> this.getWriter(context).get().online();
                }
            });
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }
    }
}

