/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.randomaccess;

import cz.o2.proxima.direct.randomaccess.RandomOffset;
import cz.o2.proxima.internal.shaded.com.google.common.base.MoreObjects;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.StreamElement;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;

public class KeyValue<T>
extends StreamElement {
    private final RandomOffset offset;

    public static <T> KeyValue<T> of(EntityDescriptor entityDesc, AttributeDescriptor<T> attrDesc, String key, String attribute, RandomOffset offset, byte[] valueBytes) {
        return KeyValue.of(entityDesc, attrDesc, key, attribute, offset, valueBytes, System.currentTimeMillis());
    }

    public static <T> KeyValue<T> of(EntityDescriptor entityDesc, AttributeDescriptor<T> attrDesc, String key, String attribute, RandomOffset offset, byte[] valueBytes, long stamp) {
        return KeyValue.of(entityDesc, attrDesc, -1L, key, attribute, offset, valueBytes, stamp);
    }

    public static <T> KeyValue<T> of(EntityDescriptor entityDesc, AttributeDescriptor<T> attrDesc, long seqId, String key, String attribute, RandomOffset offset, byte[] valueBytes, long stamp) {
        Optional value = attrDesc.getValueSerializer().deserialize(valueBytes);
        if (!value.isPresent()) {
            throw new IllegalArgumentException("Cannot parse given bytes of length " + valueBytes.length + " to value with serializer " + attrDesc.getValueSerializer());
        }
        if (seqId > 0L) {
            return new KeyValue<T>(entityDesc, attrDesc, seqId, key, attribute, offset, value.get(), valueBytes, stamp);
        }
        return new KeyValue<T>(entityDesc, attrDesc, key, attribute, offset, value.get(), valueBytes, stamp);
    }

    public static <T> KeyValue<T> of(EntityDescriptor entityDesc, AttributeDescriptor<T> attrDesc, String key, String attribute, RandomOffset offset, T value, byte[] valueBytes) {
        return new KeyValue<T>(entityDesc, attrDesc, key, attribute, offset, value, valueBytes, System.currentTimeMillis());
    }

    public static <T> KeyValue<T> of(EntityDescriptor entityDesc, AttributeDescriptor<T> attrDesc, String key, String attribute, RandomOffset offset, T value, byte[] valueBytes, long stamp) {
        return new KeyValue<T>(entityDesc, attrDesc, key, attribute, offset, value, valueBytes, stamp);
    }

    public static <T> KeyValue<T> of(EntityDescriptor entityDesc, AttributeDescriptor<T> attrDesc, long seqId, String key, String attribute, RandomOffset offset, T value, byte[] valueBytes, long stamp) {
        return new KeyValue<T>(entityDesc, attrDesc, seqId, key, attribute, offset, value, valueBytes, stamp);
    }

    private KeyValue(EntityDescriptor entityDesc, AttributeDescriptor<T> attrDesc, String key, String attribute, RandomOffset offset, T value, @Nullable byte[] valueBytes, long stamp) {
        super(entityDesc, attrDesc, UUID.randomUUID().toString(), key, attribute, stamp, false, KeyValue.asValueBytes(attrDesc, value, valueBytes));
        this.offset = Objects.requireNonNull(offset);
        this.setParsed(value);
    }

    private KeyValue(EntityDescriptor entityDesc, AttributeDescriptor<T> attrDesc, long sequenceId, String key, String attribute, RandomOffset offset, T value, @Nullable byte[] valueBytes, long stamp) {
        super(entityDesc, attrDesc, sequenceId, key, attribute, stamp, false, KeyValue.asValueBytes(attrDesc, value, valueBytes));
        this.offset = Objects.requireNonNull(offset);
        this.setParsed(value);
    }

    private static <T> byte[] asValueBytes(AttributeDescriptor<T> attr, T value, byte[] valueBytes) {
        if (valueBytes == null) {
            return attr.getValueSerializer().serialize(value);
        }
        return valueBytes;
    }

    public T getParsedRequired() {
        return this.getParsed().orElseThrow(() -> new IllegalStateException(String.format("Missing value in %s", new Object[]{this})));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("entityDescriptor", (Object)this.getEntityDescriptor()).add("attributeDescriptor", (Object)this.getAttributeDescriptor()).add("key", (Object)this.getKey()).add("attribute", (Object)this.getAttribute()).add("stamp", this.getStamp()).add("offset", (Object)this.getOffset()).add("value", this.getParsed().orElse(null)).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyValue)) {
            return false;
        }
        return super.equals(obj) && ((KeyValue)((Object)obj)).getOffset().equals(this.offset);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.offset);
    }

    @Generated
    public RandomOffset getOffset() {
        return this.offset;
    }
}

