/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.randomaccess;

import cz.o2.proxima.direct.core.Context;
import cz.o2.proxima.direct.randomaccess.KeyValue;
import cz.o2.proxima.direct.randomaccess.RandomAccessReader;
import cz.o2.proxima.direct.randomaccess.RandomOffset;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Iterables;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.util.Pair;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiAccessBuilder
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiAccessBuilder.class);
    private static final long serialVersionUID = 1L;
    private transient Repository repo;
    private final Context context;
    private final Map<AttributeDescriptor<?>, RandomAccessReader.Factory<?>> attrMapToFactory;

    MultiAccessBuilder(Repository repo, Context context) {
        this.repo = Objects.requireNonNull(repo);
        this.attrMapToFactory = new HashMap();
        this.context = context;
    }

    public MultiAccessBuilder addAttributes(RandomAccessReader reader, AttributeDescriptor<?> ... attrs) {
        for (AttributeDescriptor<?> a : attrs) {
            this.attrMapToFactory.put(a, reader.asFactory());
        }
        return this;
    }

    public MultiAccessBuilder addFamily(AttributeFamilyDescriptor family) {
        RandomAccessReader reader = this.context.resolveRequired(family).getRandomAccessReader().orElseThrow(() -> new IllegalArgumentException("Family " + family + " has no random access reader"));
        family.getAttributes().forEach(a -> this.attrMapToFactory.put((AttributeDescriptor<?>)a, reader.asFactory()));
        return this;
    }

    public RandomAccessReader build() {
        final Map<AttributeDescriptor<?>, RandomAccessReader> attrMapToReader = this.materializeReaders(this.repo);
        final EntityDescriptor entity = this.getSingleEntityOrNull(attrMapToReader);
        return new RandomAccessReader(){

            @Override
            public RandomOffset fetchOffset(RandomAccessReader.Listing type, String key) {
                if (type == RandomAccessReader.Listing.ENTITY) {
                    throw new UnsupportedOperationException("Please use specific attribute family to scan entities.");
                }
                Map<RandomAccessReader, RandomOffset> offsets = attrMapToReader.values().stream().distinct().map(ra -> Pair.of((Object)ra, (Object)ra.fetchOffset(type, key))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
                return new SequentialOffset(offsets);
            }

            @Override
            public <T> Optional<KeyValue<T>> get(String key, String attribute, AttributeDescriptor<T> desc, long stamp) {
                return Optional.ofNullable(attrMapToReader.get(desc)).map(ra -> ra.get(key, attribute, desc, stamp)).orElseGet(() -> {
                    log.warn("Missing family for attribute {} in MultiAccessBuilder", (Object)desc);
                    return Optional.empty();
                });
            }

            @Override
            public void scanWildcardAll(String key, RandomOffset offset, long stamp, int limit, Consumer<KeyValue<?>> consumer) {
                AtomicInteger missing = new AtomicInteger(limit);
                SequentialOffset soff = (SequentialOffset)offset;
                AtomicReference<SequentialOffset> current = new AtomicReference<SequentialOffset>();
                if (soff != null) {
                    current.set(new SequentialOffset(soff));
                } else {
                    HashMap<RandomAccessReader, RandomOffset> m = new HashMap<RandomAccessReader, RandomOffset>();
                    attrMapToReader.values().stream().distinct().forEach(ra -> {
                        RandomOffset cfr_ignored_0 = m.put((RandomAccessReader)ra, (RandomOffset)null);
                    });
                    current.set(new SequentialOffset(m));
                }
                ((SequentialOffset)current.get()).offsetMap.entrySet().forEach(e -> ((RandomAccessReader)e.getKey()).scanWildcardAll(key, (RandomOffset)e.getValue(), stamp, missing.get(), (Consumer & Serializable)kv -> {
                    missing.decrementAndGet();
                    current.set(new SequentialOffset((SequentialOffset)current.get()).update((RandomAccessReader)e.getKey(), kv.getOffset()));
                    KeyValue<byte[]> mapped = KeyValue.of(kv.getEntityDescriptor(), kv.getAttributeDescriptor(), kv.getKey(), kv.getAttribute(), (RandomOffset)current.get(), kv.getValue(), kv.getValue(), kv.getStamp());
                    consumer.accept(mapped);
                }));
            }

            @Override
            public <T> void scanWildcard(String key, AttributeDescriptor<T> wildcard, RandomOffset offset, long stamp, int limit, Consumer<KeyValue<T>> consumer) {
                Optional.ofNullable(attrMapToReader.get(wildcard)).ifPresent(ra -> ra.scanWildcard(key, wildcard, offset, stamp, limit, consumer));
            }

            @Override
            public void listEntities(RandomOffset offset, int limit, Consumer<Pair<RandomOffset, String>> consumer) {
                throw new UnsupportedOperationException("Not supported. Please select specific family to list entities from.");
            }

            @Override
            public EntityDescriptor getEntityDescriptor() {
                if (entity != null) {
                    return entity;
                }
                throw new IllegalArgumentException("Multiple options. This is compound reader that can work on multiple entities.");
            }

            @Override
            public RandomAccessReader.Factory<?> asFactory() {
                return (RandomAccessReader.Factory & Serializable)repo -> {
                    MultiAccessBuilder builder = new MultiAccessBuilder((Repository)repo, MultiAccessBuilder.this.context);
                    MultiAccessBuilder.this.attrMapToFactory.forEach((attr, factory) -> builder.addAttributes((RandomAccessReader)factory.apply(repo), (AttributeDescriptor<?>)attr));
                    return builder.build();
                };
            }

            @Override
            public void close() {
                attrMapToReader.values().forEach(this::closeQuietly);
            }

            private void closeQuietly(RandomAccessReader c) {
                try {
                    c.close();
                }
                catch (IOException ex) {
                    log.warn("Failed to close {}", (Object)c, (Object)ex);
                }
            }
        };
    }

    private Map<AttributeDescriptor<?>, RandomAccessReader> materializeReaders(Repository repo) {
        return this.attrMapToFactory.entrySet().stream().map(e -> Pair.of(e.getKey(), (Object)((RandomAccessReader.Factory)e.getValue()).apply(repo))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Nullable
    private EntityDescriptor getSingleEntityOrNull(Map<AttributeDescriptor<?>, RandomAccessReader> attrMap) {
        Set entities = attrMap.values().stream().map(RandomAccessReader::getEntityDescriptor).collect(Collectors.toSet());
        if (entities.size() == 1) {
            return (EntityDescriptor)Objects.requireNonNull(Iterables.getOnlyElement(entities));
        }
        log.debug("Attribute map {} contains multiple entities. Some functionality of this multi access reader might be limited.", attrMap);
        return null;
    }

    private static class SequentialOffset
    implements RandomOffset {
        private static final long serialVersionUID = 1L;
        private final Map<RandomAccessReader, RandomOffset> offsetMap;

        SequentialOffset(Map<RandomAccessReader, RandomOffset> offsetMap) {
            this.offsetMap = offsetMap;
        }

        SequentialOffset(SequentialOffset copy) {
            this.offsetMap = new HashMap<RandomAccessReader, RandomOffset>(copy.offsetMap);
        }

        SequentialOffset update(RandomAccessReader reader, RandomOffset offset) {
            this.offsetMap.put(reader, offset);
            return this;
        }
    }
}

