/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.time;

import cz.o2.proxima.direct.time.NotProgressingWatermarkIdlePolicy;
import cz.o2.proxima.direct.time.WatermarkConfiguration;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.time.AbstractWatermarkEstimator;
import cz.o2.proxima.time.WatermarkEstimator;
import cz.o2.proxima.time.WatermarkEstimatorFactory;
import cz.o2.proxima.time.WatermarkIdlePolicy;
import cz.o2.proxima.time.WatermarkIdlePolicyFactory;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class BoundedOutOfOrdernessWatermarkEstimator
extends AbstractWatermarkEstimator {
    private static final long serialVersionUID = 1L;
    public static final String MAX_OUT_OF_ORDERNESS_MS = "max-out-of-orderness";
    public static final long DEFAULT_MAX_OUT_OF_ORDERNESS_MS = 0L;
    private final long maxOutOfOrderness;
    private long minWatermark;
    private Long maxTimestamp;

    private BoundedOutOfOrdernessWatermarkEstimator(long maxOutOfOrderness, long minWatermark, WatermarkIdlePolicy idlePolicy) {
        super(idlePolicy);
        this.maxOutOfOrderness = maxOutOfOrderness;
        this.minWatermark = minWatermark;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    protected long estimateWatermark() {
        if (this.maxTimestamp != null) {
            return Math.max(this.minWatermark, this.maxTimestamp - this.maxOutOfOrderness);
        }
        return this.minWatermark;
    }

    public void updateWatermark(StreamElement element) {
        this.maxTimestamp = this.maxTimestamp != null ? Long.valueOf(Math.max(element.getStamp(), this.maxTimestamp)) : Long.valueOf(element.getStamp());
    }

    public void setMinWatermark(long minWatermark) {
        this.minWatermark = minWatermark;
    }

    @Generated
    public long getMaxOutOfOrderness() {
        return this.maxOutOfOrderness;
    }

    @Generated
    public long getMinWatermark() {
        return this.minWatermark;
    }

    public static class Builder {
        private final long maxOutOfOrderness;
        private final long minWatermark;
        private final WatermarkIdlePolicy watermarkIdlePolicy;

        Builder() {
            this(0L, Long.MIN_VALUE, new NotProgressingWatermarkIdlePolicy());
        }

        private Builder(long maxOutOfOrderness, long minWatermark, WatermarkIdlePolicy idlePolicy) {
            this.maxOutOfOrderness = maxOutOfOrderness;
            this.minWatermark = minWatermark;
            this.watermarkIdlePolicy = idlePolicy;
        }

        public Builder withMaxOutOfOrderness(long maxOutOfOrderness) {
            return new Builder(maxOutOfOrderness, this.minWatermark, this.watermarkIdlePolicy);
        }

        public Builder withMinWatermark(long minWatermark) {
            return new Builder(this.maxOutOfOrderness, minWatermark, this.watermarkIdlePolicy);
        }

        public Builder withWatermarkIdlePolicy(WatermarkIdlePolicy watermarkIdlePolicy) {
            return new Builder(this.maxOutOfOrderness, this.minWatermark, watermarkIdlePolicy);
        }

        public BoundedOutOfOrdernessWatermarkEstimator build() {
            return new BoundedOutOfOrdernessWatermarkEstimator(this.maxOutOfOrderness, this.minWatermark, this.watermarkIdlePolicy);
        }
    }

    public static class Factory
    implements WatermarkEstimatorFactory {
        private static final long serialVersionUID = 1L;

        public WatermarkEstimator create(Map<String, Object> cfg, WatermarkIdlePolicyFactory idlePolicyFactory) {
            long maxOutOfOrderness = Optional.ofNullable(cfg.get(WatermarkConfiguration.prefixedKey(BoundedOutOfOrdernessWatermarkEstimator.MAX_OUT_OF_ORDERNESS_MS))).map(v -> Long.valueOf(v.toString())).orElse(0L);
            return BoundedOutOfOrdernessWatermarkEstimator.newBuilder().withMaxOutOfOrderness(maxOutOfOrderness).withWatermarkIdlePolicy(idlePolicyFactory.create(cfg)).build();
        }
    }
}

