/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.time;

import cz.o2.proxima.internal.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.time.PartitionedWatermarkEstimator;
import cz.o2.proxima.time.WatermarkEstimator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MinimalPartitionWatermarkEstimator
implements PartitionedWatermarkEstimator {
    private static final long serialVersionUID = 1L;
    private final ConcurrentHashMap<Integer, WatermarkEstimator> estimators;

    public MinimalPartitionWatermarkEstimator(Map<Integer, WatermarkEstimator> partitionEstimators) {
        Preconditions.checkArgument((!partitionEstimators.isEmpty() ? 1 : 0) != 0);
        this.estimators = new ConcurrentHashMap<Integer, WatermarkEstimator>(partitionEstimators);
    }

    public long getWatermark() {
        return this.estimators.values().stream().map(WatermarkEstimator::getWatermark).min(Long::compare).orElseThrow(IllegalStateException::new);
    }

    public long getWatermark(int partition) {
        return this.getEstimator(partition).getWatermark();
    }

    public void update(int partition, StreamElement element) {
        this.getEstimator(partition).update(element);
    }

    public void idle(int partition) {
        this.getEstimator(partition).idle();
    }

    private WatermarkEstimator getEstimator(int partition) {
        WatermarkEstimator watermarkEstimator = this.estimators.get(partition);
        if (watermarkEstimator == null) {
            throw new IllegalStateException(String.format("Watermark estimator for partition %d not found.", partition));
        }
        return watermarkEstimator;
    }
}

