/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.time;

import cz.o2.proxima.direct.time.NotProgressingWatermarkIdlePolicy;
import cz.o2.proxima.direct.time.TimestampSupplier;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.time.AbstractWatermarkEstimator;
import cz.o2.proxima.time.WatermarkEstimator;
import cz.o2.proxima.time.WatermarkEstimatorFactory;
import cz.o2.proxima.time.WatermarkIdlePolicy;
import cz.o2.proxima.time.WatermarkIdlePolicyFactory;
import java.util.Map;

public class ProcessingTimeWatermarkEstimator
extends AbstractWatermarkEstimator {
    private static final long serialVersionUID = 1L;
    private final TimestampSupplier timestampSupplier;
    private long minWatermark;

    ProcessingTimeWatermarkEstimator(long minWatermark, TimestampSupplier timestampSupplier, WatermarkIdlePolicy idlePolicy) {
        super(idlePolicy);
        this.minWatermark = minWatermark;
        this.timestampSupplier = timestampSupplier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    protected long estimateWatermark() {
        return Math.max(this.timestampSupplier.get(), this.minWatermark);
    }

    protected void updateWatermark(StreamElement element) {
    }

    public void setMinWatermark(long minWatermark) {
        this.minWatermark = minWatermark;
    }

    public static class Builder {
        private final long minWatermark;
        private final TimestampSupplier timestampSupplier;
        private final WatermarkIdlePolicy watermarkIdlePolicy;

        Builder() {
            this(Long.MIN_VALUE, System::currentTimeMillis, new NotProgressingWatermarkIdlePolicy());
        }

        private Builder(long minWatermark, TimestampSupplier timestampSupplier, WatermarkIdlePolicy idlePolicy) {
            this.minWatermark = minWatermark;
            this.timestampSupplier = timestampSupplier;
            this.watermarkIdlePolicy = idlePolicy;
        }

        public Builder withMinWatermark(long minWatermark) {
            return new Builder(minWatermark, this.timestampSupplier, this.watermarkIdlePolicy);
        }

        public Builder withTimestampSupplier(TimestampSupplier timestampSupplier) {
            return new Builder(this.minWatermark, timestampSupplier, this.watermarkIdlePolicy);
        }

        public Builder withWatermarkIdlePolicy(WatermarkIdlePolicy watermarkIdlePolicy) {
            return new Builder(this.minWatermark, this.timestampSupplier, watermarkIdlePolicy);
        }

        public ProcessingTimeWatermarkEstimator build() {
            return new ProcessingTimeWatermarkEstimator(this.minWatermark, this.timestampSupplier, this.watermarkIdlePolicy);
        }
    }

    public static class Factory
    implements WatermarkEstimatorFactory {
        private static final long serialVersionUID = 1L;

        public WatermarkEstimator create(Map<String, Object> cfg, WatermarkIdlePolicyFactory idlePolicyFactory) {
            return ProcessingTimeWatermarkEstimator.newBuilder().withWatermarkIdlePolicy(idlePolicyFactory.create(cfg)).build();
        }
    }
}

