/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.time;

import cz.o2.proxima.time.WatermarkEstimatorFactory;
import cz.o2.proxima.time.WatermarkIdlePolicyFactory;
import cz.o2.proxima.util.Classpath;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WatermarkConfiguration
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WatermarkConfiguration.class);
    private static final long serialVersionUID = 1L;
    public static final String CFG_PREFIX = "watermark.";
    public static final String CFG_ESTIMATOR_FACTORY = "estimator-factory";
    public static final String CFG_IDLE_POLICY_FACTORY = "idle-policy-factory";
    private final Map<String, Object> cfg;
    private WatermarkIdlePolicyFactory watermarkIdlePolicyFactory;
    private WatermarkEstimatorFactory watermarkEstimatorFactory;

    protected WatermarkConfiguration(Map<String, Object> cfg) {
        this.cfg = cfg;
    }

    public static String prefixedKey(String cfgName) {
        if (cfgName.startsWith(CFG_PREFIX)) {
            return cfgName;
        }
        return CFG_PREFIX + cfgName;
    }

    protected abstract WatermarkIdlePolicyFactory getDefaultIdlePolicyFactory();

    protected abstract WatermarkEstimatorFactory getDefaultEstimatorFactory();

    protected void configure() {
        this.watermarkIdlePolicyFactory = Optional.ofNullable(this.cfg.get(WatermarkConfiguration.prefixedKey(CFG_IDLE_POLICY_FACTORY))).map(Object::toString).map(cls -> (WatermarkIdlePolicyFactory)Classpath.newInstance((String)cls, WatermarkIdlePolicyFactory.class)).orElse(this.getDefaultIdlePolicyFactory());
        this.watermarkEstimatorFactory = Optional.ofNullable(this.cfg.get(WatermarkConfiguration.prefixedKey(CFG_ESTIMATOR_FACTORY))).map(Object::toString).map(cls -> (WatermarkEstimatorFactory)Classpath.newInstance((String)cls, WatermarkEstimatorFactory.class)).orElse(this.getDefaultEstimatorFactory());
        log.debug("Configured watermark with watermarkEstimatorFactory {}, idlePolicyFactory {}", (Object)this.watermarkEstimatorFactory, (Object)this.watermarkIdlePolicyFactory);
    }

    @Generated
    public Map<String, Object> getCfg() {
        return this.cfg;
    }

    @Generated
    public WatermarkIdlePolicyFactory getWatermarkIdlePolicyFactory() {
        return this.watermarkIdlePolicyFactory;
    }

    @Generated
    public WatermarkEstimatorFactory getWatermarkEstimatorFactory() {
        return this.watermarkEstimatorFactory;
    }
}

