/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.transaction;

import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.CommitCallback;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.direct.core.OnlineAttributeWriter;
import cz.o2.proxima.direct.transaction.TransactionalOnlineAttributeWriter;
import cz.o2.proxima.direct.transform.DirectElementWiseTransform;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityAwareAttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.transaction.Commit;
import cz.o2.proxima.util.Optionals;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCommitTransformation
implements DirectElementWiseTransform {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransactionCommitTransformation.class);
    private final Map<String, OnlineAttributeWriter> writers = new HashMap<String, OnlineAttributeWriter>();
    private RepositoryFactory repositoryFactory;
    private EntityAwareAttributeDescriptor.Regular<Commit> commitDesc;
    private transient DirectDataOperator direct;

    @Override
    public void setup(Repository repo, DirectDataOperator directDataOperator, Map<String, Object> cfg) {
        EntityDescriptor transaction = repo.getEntity("_transaction");
        this.repositoryFactory = repo.asFactory();
        this.commitDesc = EntityAwareAttributeDescriptor.Regular.of((EntityDescriptor)transaction, (AttributeDescriptor)transaction.getAttribute("commit"));
    }

    @Override
    public void transform(StreamElement input, CommitCallback commitCallback) {
        if (input.getAttributeDescriptor().equals(this.commitDesc)) {
            Optional commit = this.commitDesc.valueOf(input);
            if (commit.isPresent()) {
                this.handleCommit((Commit)commit.get(), commitCallback);
            } else {
                log.warn("Unparseable value in {}", (Object)input);
            }
        }
    }

    private void handleCommit(Commit commit, CommitCallback commitCallback) {
        log.debug("Received commit {}", (Object)commit);
        if (commit.getUpdates().isEmpty() && commit.getTransactionUpdates().isEmpty()) {
            log.warn("Received empty commit {}", (Object)commit);
            commitCallback.commit(true, null);
        } else if (commit.getUpdates().isEmpty()) {
            CommitCallback totalCallback = CommitCallback.afterNumCommits(commit.getTransactionUpdates().size(), commitCallback);
            commit.getTransactionUpdates().forEach(update -> this.getWriterForFamily(update.getTargetFamily()).write(update.getUpdate(), totalCallback));
        } else {
            CommitCallback totalCallback = CommitCallback.afterNumCommits(commit.getUpdates().size(), commitCallback);
            commit.getUpdates().forEach(update -> this.nonTransactional((OnlineAttributeWriter)Optionals.get(this.direct().getWriter(update.getAttributeDescriptor()))).write((StreamElement)update, totalCallback));
        }
    }

    private DirectDataOperator direct() {
        if (this.direct == null) {
            this.direct = (DirectDataOperator)this.repositoryFactory.apply().getOrCreateOperator(DirectDataOperator.class, new Consumer[0]);
        }
        return this.direct;
    }

    private OnlineAttributeWriter nonTransactional(OnlineAttributeWriter writer) {
        if (writer.isTransactional()) {
            return ((TransactionalOnlineAttributeWriter)writer).getDelegate();
        }
        return writer;
    }

    private OnlineAttributeWriter getWriterForFamily(String family) {
        return this.writers.computeIfAbsent(family, k -> ((AttributeWriterBase)Optionals.get(this.direct().getFamilyByName(family).getWriter())).online());
    }

    @Override
    public void close() {
        this.writers.values().forEach(AttributeWriterBase::close);
        this.writers.clear();
    }
}

