/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.transaction;

import cz.o2.proxima.direct.core.AttributeWriterBase;
import cz.o2.proxima.direct.core.CommitCallback;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.direct.core.OnlineAttributeWriter;
import cz.o2.proxima.direct.transaction.DelegatingCachedView;
import cz.o2.proxima.direct.transaction.TransactionalOnlineAttributeWriter;
import cz.o2.proxima.direct.view.CachedView;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.TransactionMode;
import cz.o2.proxima.storage.StreamElement;
import java.io.Serializable;

public class TransactionalCachedView
extends DelegatingCachedView {
    private final TransactionalOnlineAttributeWriter transactionalWriter;

    public TransactionalCachedView(DirectDataOperator direct, CachedView delegate) {
        super(delegate);
        this.transactionalWriter = TransactionalOnlineAttributeWriter.of(direct, delegate);
    }

    @Override
    public OnlineAttributeWriter online() {
        return this;
    }

    @Override
    public AttributeWriterBase.Type getType() {
        return AttributeWriterBase.Type.ONLINE;
    }

    @Override
    public void write(StreamElement data, CommitCallback statusCallback) {
        if (data.getAttributeDescriptor().getTransactionMode() != TransactionMode.NONE) {
            this.transactionalWriter.write(data, statusCallback);
        } else {
            this.delegate.write(data, statusCallback);
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public TransactionalOnlineAttributeWriter transactional() {
        return this.transactionalWriter;
    }

    @Override
    public CachedView.Factory asFactory() {
        CachedView.Factory factory = this.delegate.asFactory();
        return (CachedView.Factory & Serializable)repo -> new TransactionalCachedView((DirectDataOperator)repo.getOrCreateOperator(DirectDataOperator.class, new Consumer[0]), (CachedView)factory.apply(repo));
    }

    @Override
    public void close() {
        this.delegate.close();
        this.transactionalWriter.close();
    }
}

