/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.view;

import cz.o2.proxima.functional.BiFunction;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.functional.UnaryFunction;
import cz.o2.proxima.internal.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeBoundedVersionedCache
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeBoundedVersionedCache.class);
    private static final long serialVersionUID = 1L;
    private final EntityDescriptor entity;
    private final long keepDuration;
    private final Map<String, NavigableMap<String, NavigableMap<Long, Payload>>> cache;

    TimeBoundedVersionedCache(EntityDescriptor entity, long keepDuration) {
        this.entity = entity;
        this.keepDuration = keepDuration;
        this.cache = new LinkedHashMap<String, NavigableMap<String, NavigableMap<Long, Payload>>>();
    }

    @Nullable
    synchronized Pair<Long, Payload> get(String key, String attribute, long stamp) {
        Map.Entry floorEntry;
        NavigableMap valueMap;
        NavigableMap<String, NavigableMap<Long, Payload>> attrMap = this.cache.get(key);
        if (attrMap != null && (valueMap = (NavigableMap)attrMap.get(attribute)) != null && (floorEntry = valueMap.floorEntry(stamp)) != null) {
            return Pair.of((Object)floorEntry.getKey(), floorEntry.getValue());
        }
        return null;
    }

    @VisibleForTesting
    NavigableMap<String, NavigableMap<Long, Payload>> get(String key) {
        return this.cache.get(key);
    }

    void scan(String key, String prefix, long stamp, UnaryFunction<String, String> parentRecordExtractor, BiFunction<String, Pair<Long, Payload>, Boolean> consumer) {
        this.scan(key, prefix, prefix, stamp, parentRecordExtractor, consumer);
    }

    synchronized void scan(String key, String prefix, String offset, long stamp, UnaryFunction<String, String> parentRecordExtractor, BiFunction<String, Pair<Long, Payload>, Boolean> consumer) {
        NavigableMap<String, NavigableMap<Long, Payload>> attrMap = this.cache.get(key);
        if (attrMap == null) {
            return;
        }
        String lastParent = null;
        Pair<Long, Payload> parentEntry = null;
        long parentTombstoneStamp = stamp;
        for (Map.Entry<String, NavigableMap<Long, Payload>> e : attrMap.tailMap(offset).entrySet()) {
            if (e.getKey().startsWith(prefix)) {
                Map.Entry<Long, Payload> floorEntry;
                if (e.getKey().equals(offset)) continue;
                if (lastParent == null || !e.getKey().startsWith(lastParent)) {
                    lastParent = (String)parentRecordExtractor.apply((Object)e.getKey());
                    parentEntry = lastParent == null ? null : this.get(key, lastParent, stamp);
                    boolean isDelete = parentEntry != null && ((Payload)parentEntry.getSecond()).getData() == null;
                    long l = parentTombstoneStamp = isDelete ? (Long)parentEntry.getFirst() : -1L;
                }
                if ((floorEntry = e.getValue().floorEntry(stamp)) == null || parentTombstoneStamp >= floorEntry.getKey() || ((Boolean)consumer.apply((Object)e.getKey(), (Object)Pair.of((Object)floorEntry.getKey(), (Object)floorEntry.getValue()))).booleanValue()) continue;
                return;
            }
            return;
        }
    }

    public synchronized void clearStaleRecords(long cleanTime) {
        long now = System.currentTimeMillis();
        AtomicInteger removed = new AtomicInteger();
        ArrayList<String> emptyKeys = new ArrayList<String>();
        for (Map.Entry<String, NavigableMap<String, NavigableMap<Long, Payload>>> candidate : this.cache.entrySet()) {
            ArrayList<String> emptyAttributes = new ArrayList<String>();
            candidate.getValue().forEach((key, value) -> {
                Set<Long> remove = value.headMap(cleanTime).keySet();
                removed.addAndGet(remove.size());
                remove.removeIf(tmp -> true);
                if (value.isEmpty()) {
                    emptyAttributes.add((String)key);
                }
            });
            emptyAttributes.forEach(k -> {
                NavigableMap cfr_ignored_0 = (NavigableMap)((NavigableMap)candidate.getValue()).remove(k);
            });
            if (!candidate.getValue().isEmpty()) continue;
            emptyKeys.add(candidate.getKey());
        }
        emptyKeys.forEach(this.cache::remove);
        log.info("Cleared {} elements from cache older than {} in {} ms", new Object[]{removed.get(), cleanTime, System.currentTimeMillis() - now});
    }

    synchronized int findPosition(String key) {
        if (key.isEmpty()) {
            return 0;
        }
        int ret = 0;
        for (String k : this.cache.keySet()) {
            if (k.equals(key)) break;
            ++ret;
        }
        return ret;
    }

    synchronized void keys(int offset, int limit, Consumer<String> keyConsumer) {
        int toTake = limit;
        int toSkip = offset;
        for (String key : this.cache.keySet()) {
            if (toSkip-- > 0) continue;
            if (toTake == 0) break;
            keyConsumer.accept((Object)key);
            --toTake;
        }
    }

    synchronized boolean put(String key, String attribute, long stamp, long sequenceId, boolean overwrite, @Nullable Object value) {
        AtomicBoolean updated = new AtomicBoolean();
        this.cache.compute(key, (k, attrMap) -> {
            long first;
            NavigableMap valueMap;
            if (attrMap == null) {
                attrMap = new TreeMap<String, NavigableMap>();
            }
            if ((valueMap = attrMap.computeIfAbsent(attribute, tmp -> new TreeMap())).isEmpty() || (Long)valueMap.firstKey() - this.keepDuration < stamp) {
                Payload oldPayload = (Payload)valueMap.get(stamp);
                if (overwrite || oldPayload == null || oldPayload.overridable) {
                    this.logPayloadUpdateIfNecessary(key, attribute, stamp, value);
                    Payload newPayload = new Payload(value, sequenceId, !overwrite);
                    valueMap.put(stamp, newPayload);
                    updated.set(!newPayload.equals(oldPayload));
                }
            }
            while ((first = ((Long)valueMap.firstKey()).longValue()) + this.keepDuration < stamp) {
                valueMap.remove(first);
            }
            return attrMap;
        });
        return updated.get();
    }

    private void logPayloadUpdateIfNecessary(String key, String attribute, long stamp, @Nullable Object value) {
        if (log.isDebugEnabled()) {
            AttributeDescriptor attrDesc = this.entity.findAttribute(attribute).orElse(null);
            if (attrDesc != null) {
                log.debug("Caching attribute {} for key {} at {} with payload {}", new Object[]{attribute, key, stamp, value == null ? "(null)" : attrDesc.getValueSerializer().getLogString(value)});
            } else {
                log.warn("Failed to find attribute descriptor {} in {}", (Object)attribute, (Object)this.entity);
            }
        }
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keepDuration, this.entity);
    }

    public boolean equals(Object o) {
        if (o instanceof TimeBoundedVersionedCache) {
            return super.equals(o) && this.entity.equals(((TimeBoundedVersionedCache)o).entity) && ((TimeBoundedVersionedCache)o).keepDuration == this.keepDuration;
        }
        return false;
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    static final class Payload {
        @Nullable
        private final Object data;
        private final long seqId;
        private final boolean overridable;

        @Generated
        public Payload(@Nullable Object data, long seqId, boolean overridable) {
            this.data = data;
            this.seqId = seqId;
            this.overridable = overridable;
        }

        @Nullable
        @Generated
        public Object getData() {
            return this.data;
        }

        @Generated
        public long getSeqId() {
            return this.seqId;
        }

        @Generated
        public boolean isOverridable() {
            return this.overridable;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payload)) {
                return false;
            }
            Payload other = (Payload)o;
            if (this.getSeqId() != other.getSeqId()) {
                return false;
            }
            if (this.isOverridable() != other.isOverridable()) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $seqId = this.getSeqId();
            result = result * 59 + (int)($seqId >>> 32 ^ $seqId);
            result = result * 59 + (this.isOverridable() ? 79 : 97);
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TimeBoundedVersionedCache.Payload(data=" + this.getData() + ", seqId=" + this.getSeqId() + ", overridable=" + this.isOverridable() + ")";
        }
    }
}

