/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.ExtendedAuthProvider;
import com.datastax.driver.core.ProtocolV1Authenticator;
import com.datastax.driver.core.exceptions.AuthenticationException;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Charsets;
import cz.o2.proxima.cassandra.shaded.com.google.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.Map;

public class PlainTextAuthProvider
implements ExtendedAuthProvider {
    private volatile String username;
    private volatile String password;

    public PlainTextAuthProvider(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Authenticator newAuthenticator(EndPoint host, String authenticator) {
        return new PlainTextAuthenticator(this.username, this.password);
    }

    @Override
    public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) throws AuthenticationException {
        throw new AssertionError((Object)("The driver should never call this method on an object that implements " + this.getClass().getSimpleName()));
    }

    static class PlainTextAuthenticator
    extends ProtocolV1Authenticator
    implements Authenticator {
        private final byte[] username;
        private final byte[] password;

        public PlainTextAuthenticator(String username, String password) {
            this.username = username.getBytes(Charsets.UTF_8);
            this.password = password.getBytes(Charsets.UTF_8);
        }

        @Override
        public byte[] initialResponse() {
            byte[] initialToken = new byte[this.username.length + this.password.length + 2];
            initialToken[0] = 0;
            System.arraycopy(this.username, 0, initialToken, 1, this.username.length);
            initialToken[this.username.length + 1] = 0;
            System.arraycopy(this.password, 0, initialToken, this.username.length + 2, this.password.length);
            return initialToken;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) {
            return null;
        }

        @Override
        public void onAuthenticationSuccess(byte[] token) {
        }

        @Override
        Map<String, String> getCredentials() {
            return ImmutableMap.of("username", new String(this.username, Charsets.UTF_8), "password", new String(this.password, Charsets.UTF_8));
        }
    }
}

