/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.ExtendedRemoteEndpointAwareSslOptions;
import com.datastax.driver.core.JdkSSLOptions;
import cz.o2.proxima.cassandra.shaded.io.netty.channel.socket.SocketChannel;
import cz.o2.proxima.cassandra.shaded.io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class RemoteEndpointAwareJdkSSLOptions
extends JdkSSLOptions
implements ExtendedRemoteEndpointAwareSslOptions {
    public static Builder builder() {
        return new Builder();
    }

    protected RemoteEndpointAwareJdkSSLOptions(SSLContext context, String[] cipherSuites) {
        super(context, cipherSuites);
    }

    @Override
    public SslHandler newSSLHandler(SocketChannel channel) {
        throw new AssertionError((Object)"This class implements RemoteEndpointAwareSSLOptions, this method should not be called");
    }

    @Override
    public SslHandler newSSLHandler(SocketChannel channel, EndPoint remoteEndpoint) {
        SSLEngine engine = this.newSSLEngine(channel, remoteEndpoint == null ? null : remoteEndpoint.resolve());
        return new SslHandler(engine);
    }

    @Override
    public SslHandler newSSLHandler(SocketChannel channel, InetSocketAddress remoteEndpoint) {
        throw new AssertionError((Object)("The driver should never call this method on an object that implements " + this.getClass().getSimpleName()));
    }

    protected SSLEngine newSSLEngine(SocketChannel channel, InetSocketAddress remoteEndpoint) {
        SSLEngine engine = remoteEndpoint == null ? this.context.createSSLEngine() : this.context.createSSLEngine(remoteEndpoint.getHostName(), remoteEndpoint.getPort());
        engine.setUseClientMode(true);
        if (this.cipherSuites != null) {
            engine.setEnabledCipherSuites(this.cipherSuites);
        }
        return engine;
    }

    public static class Builder
    extends JdkSSLOptions.Builder {
        @Override
        public Builder withSSLContext(SSLContext context) {
            super.withSSLContext(context);
            return this;
        }

        @Override
        public Builder withCipherSuites(String[] cipherSuites) {
            super.withCipherSuites(cipherSuites);
            return this;
        }

        @Override
        public RemoteEndpointAwareJdkSSLOptions build() {
            return new RemoteEndpointAwareJdkSSLOptions(this.context, this.cipherSuites);
        }
    }
}

