/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CancelledSpeculativeExecutionException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.MetricsUtil;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.QueryLogger;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.BusyConnectionException;
import com.datastax.driver.core.exceptions.BusyPoolException;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.ReadFailureException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.ServerError;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteFailureException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import cz.o2.proxima.cassandra.shaded.com.codahale.metrics.Timer;
import cz.o2.proxima.cassandra.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.cassandra.shaded.com.google.common.collect.Iterators;
import cz.o2.proxima.cassandra.shaded.com.google.common.collect.Sets;
import cz.o2.proxima.cassandra.shaded.com.google.common.util.concurrent.FutureCallback;
import cz.o2.proxima.cassandra.shaded.com.google.common.util.concurrent.ListenableFuture;
import cz.o2.proxima.cassandra.shaded.io.netty.util.Timeout;
import cz.o2.proxima.cassandra.shaded.io.netty.util.Timer;
import cz.o2.proxima.cassandra.shaded.io.netty.util.TimerTask;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private static final boolean HOST_METRICS_ENABLED = Boolean.getBoolean("com.datastax.driver.HOST_METRICS_ENABLED");
    private static final QueryLogger QUERY_LOGGER = QueryLogger.builder().build();
    static final String DISABLE_QUERY_WARNING_LOGS = "com.datastax.driver.DISABLE_QUERY_WARNING_LOGS";
    final String id;
    private final SessionManager manager;
    private final Callback callback;
    private final QueryPlan queryPlan;
    private final SpeculativeExecutionPolicy.SpeculativeExecutionPlan speculativeExecutionPlan;
    private final boolean allowSpeculativeExecutions;
    private final Set<SpeculativeExecution> runningExecutions = Sets.newCopyOnWriteArraySet();
    private final Set<Timeout> scheduledExecutions = Sets.newCopyOnWriteArraySet();
    private final Statement statement;
    private final Timer scheduler;
    private volatile List<Host> triedHosts;
    private volatile ConcurrentMap<EndPoint, Throwable> errors;
    private final Timer.Context timerContext;
    private final long startTime;
    private final AtomicBoolean isDone = new AtomicBoolean();
    private final AtomicInteger executionIndex = new AtomicInteger();
    private final TimerTask newExecutionTask = new TimerTask(){

        @Override
        public void run(Timeout timeout) throws Exception {
            RequestHandler.this.scheduledExecutions.remove(timeout);
            if (!RequestHandler.this.isDone.get()) {
                RequestHandler.this.manager.executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        RequestHandler.this.scheduleExecutionImmediately();
                    }
                });
            }
        }
    };

    public RequestHandler(SessionManager manager, Callback callback, Statement statement) {
        this.id = Long.toString(System.identityHashCode(this));
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] {}", (Object)this.id, (Object)statement);
        }
        this.manager = manager;
        this.callback = callback;
        this.scheduler = manager.cluster.manager.connectionFactory.timer;
        callback.register(this);
        this.queryPlan = statement.getHost() != null ? new QueryPlan(Iterators.singletonIterator(statement.getHost())) : new QueryPlan(manager.loadBalancingPolicy().newQueryPlan(manager.poolsState.keyspace, statement));
        this.speculativeExecutionPlan = manager.speculativeExecutionPolicy().newPlan(manager.poolsState.keyspace, statement);
        this.allowSpeculativeExecutions = statement != Statement.DEFAULT && statement.isIdempotentWithDefault(manager.configuration().getQueryOptions());
        this.statement = statement;
        this.timerContext = this.metricsEnabled() ? this.metrics().getRequestsTimer().time() : null;
        this.startTime = System.nanoTime();
    }

    void sendRequest() {
        this.startNewExecution();
    }

    void cancel() {
        if (!this.isDone.compareAndSet(false, true)) {
            return;
        }
        this.cancelPendingExecutions(null);
    }

    private void startNewExecution() {
        if (this.isDone.get()) {
            return;
        }
        Message.Request request = this.callback.request();
        int position = this.executionIndex.getAndIncrement();
        SpeculativeExecution execution = new SpeculativeExecution(request, position);
        this.runningExecutions.add(execution);
        execution.findNextHostAndQuery();
    }

    private void scheduleExecution(long delayMillis) {
        if (this.isDone.get() || delayMillis < 0L) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Schedule next speculative execution in {} ms", (Object)this.id, (Object)delayMillis);
        }
        if (delayMillis == 0L) {
            this.scheduleExecutionImmediately();
        } else {
            this.scheduledExecutions.add(this.scheduler.newTimeout(this.newExecutionTask, delayMillis, TimeUnit.MILLISECONDS));
        }
    }

    private void scheduleExecutionImmediately() {
        if (this.metricsEnabled()) {
            this.metrics().getErrorMetrics().getSpeculativeExecutions().inc();
        }
        this.startNewExecution();
    }

    private void cancelPendingExecutions(SpeculativeExecution ignore) {
        for (SpeculativeExecution speculativeExecution : this.runningExecutions) {
            if (speculativeExecution == ignore) continue;
            speculativeExecution.cancel();
        }
        for (Timeout timeout : this.scheduledExecutions) {
            timeout.cancel();
        }
    }

    private void setFinalResult(SpeculativeExecution execution, Connection connection, Message.Response response) {
        if (!this.isDone.compareAndSet(false, true)) {
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Got beaten to setting the result", (Object)execution.id);
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Setting final result", (Object)execution.id);
        }
        this.cancelPendingExecutions(execution);
        try {
            ExecutionInfo info;
            if (this.timerContext != null) {
                this.timerContext.stop();
            }
            int speculativeExecutions = this.executionIndex.get() - 1;
            if (execution.position == 0 && speculativeExecutions == 0 && this.triedHosts == null && execution.retryConsistencyLevel == null && response.getCustomPayload() == null) {
                info = ((SpeculativeExecution)execution).current.defaultExecutionInfo;
            } else {
                List<Host> hosts;
                if (this.triedHosts == null) {
                    hosts = ImmutableList.of(execution.current);
                } else {
                    hosts = this.triedHosts;
                    hosts.add(execution.current);
                }
                info = new ExecutionInfo(speculativeExecutions, execution.position, hosts, execution.retryConsistencyLevel, response.getCustomPayload());
            }
            if (response.warnings != null && !response.warnings.isEmpty() && !Boolean.getBoolean(DISABLE_QUERY_WARNING_LOGS) && logger.isWarnEnabled()) {
                this.logServerWarnings(response.warnings);
            }
            this.callback.onSet(connection, response, info, this.statement, System.nanoTime() - this.startTime);
        }
        catch (Exception e) {
            this.callback.onException(connection, new DriverInternalError("Unexpected exception while setting final result from " + response, e), System.nanoTime() - this.startTime, 0);
        }
    }

    private void logServerWarnings(List<String> warnings) {
        String queryString = QUERY_LOGGER.statementAsString(this.statement);
        for (String warning : warnings) {
            logger.warn("Query '{}' generated server side warning(s): {}", (Object)queryString, (Object)warning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFinalException(SpeculativeExecution execution, Connection connection, Exception exception) {
        if (!this.isDone.compareAndSet(false, true)) {
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Got beaten to setting final exception", (Object)execution.id);
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] Setting final exception", (Object)execution.id);
        }
        this.cancelPendingExecutions(execution);
        try {
            if (this.timerContext != null) {
                this.timerContext.stop();
            }
        }
        finally {
            this.callback.onException(connection, exception, System.nanoTime() - this.startTime, 0);
        }
    }

    private void reportNoMoreHosts(SpeculativeExecution execution) {
        this.runningExecutions.remove(execution);
        if (this.runningExecutions.isEmpty()) {
            this.setFinalException(execution, null, new NoHostAvailableException(this.errors == null ? Collections.emptyMap() : this.errors));
        }
    }

    private boolean metricsEnabled() {
        return this.manager.configuration().getMetricsOptions().isEnabled();
    }

    private boolean hostMetricsEnabled() {
        return HOST_METRICS_ENABLED && this.metricsEnabled();
    }

    private Metrics metrics() {
        return this.manager.cluster.manager.metrics;
    }

    private RetryPolicy retryPolicy() {
        return this.statement.getRetryPolicy() == null ? this.manager.configuration().getPolicies().getRetryPolicy() : this.statement.getRetryPolicy();
    }

    static class QueryPlan {
        private final Iterator<Host> iterator;

        QueryPlan(Iterator<Host> iterator) {
            this.iterator = iterator;
        }

        synchronized Host next() {
            return this.iterator.hasNext() ? this.iterator.next() : null;
        }
    }

    static class QueryState {
        static final QueryState INITIAL = new QueryState(-1, false);
        static final QueryState CANCELLED_WHILE_IN_PROGRESS = new QueryState(Integer.MIN_VALUE, false);
        static final QueryState CANCELLED_WHILE_COMPLETE = new QueryState(-2147483647, false);
        final int retryCount;
        final boolean inProgress;

        private QueryState(int count, boolean inProgress) {
            this.retryCount = count;
            this.inProgress = inProgress;
        }

        boolean isInProgressAt(int retryCount) {
            return this.inProgress && this.retryCount == retryCount;
        }

        QueryState complete() {
            assert (this.inProgress);
            return new QueryState(this.retryCount, false);
        }

        QueryState startNext() {
            assert (!this.inProgress);
            return new QueryState(this.retryCount + 1, true);
        }

        public boolean isCancelled() {
            return this == CANCELLED_WHILE_IN_PROGRESS || this == CANCELLED_WHILE_COMPLETE;
        }

        public String toString() {
            return String.format("QueryState(count=%d, inProgress=%s, cancelled=%s)", this.retryCount, this.inProgress, this.isCancelled());
        }
    }

    class SpeculativeExecution
    implements Connection.ResponseCallback {
        final String id;
        private final Message.Request request;
        private final int position;
        private volatile Host current;
        private volatile ConsistencyLevel retryConsistencyLevel;
        private final AtomicReference<QueryState> queryStateRef;
        private final AtomicBoolean nextExecutionScheduled = new AtomicBoolean();
        private final long startTime = System.nanoTime();
        private volatile int retriesByPolicy;
        private volatile Connection.ResponseHandler connectionHandler;

        SpeculativeExecution(Message.Request request, int position) {
            this.id = RequestHandler.this.id + "-" + position;
            this.request = request;
            this.position = position;
            this.queryStateRef = new AtomicReference<QueryState>(QueryState.INITIAL);
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Starting", (Object)this.id);
            }
        }

        void findNextHostAndQuery() {
            try {
                Host host;
                while (!RequestHandler.this.isDone.get() && (host = RequestHandler.this.queryPlan.next()) != null && !this.queryStateRef.get().isCancelled()) {
                    if (this.query(host)) {
                        if (RequestHandler.this.hostMetricsEnabled()) {
                            RequestHandler.this.metrics().getRegistry().counter(MetricsUtil.hostMetricName("writes.", host)).inc();
                        }
                        return;
                    }
                    if (!RequestHandler.this.hostMetricsEnabled()) continue;
                    RequestHandler.this.metrics().getRegistry().counter(MetricsUtil.hostMetricName("write-errors.", host)).inc();
                }
                if (this.current != null) {
                    if (RequestHandler.this.triedHosts == null) {
                        RequestHandler.this.triedHosts = new CopyOnWriteArrayList();
                    }
                    RequestHandler.this.triedHosts.add(this.current);
                }
                RequestHandler.this.reportNoMoreHosts(this);
            }
            catch (Exception e) {
                this.setFinalException(null, new DriverInternalError("An unexpected error happened while sending requests", e));
            }
        }

        private boolean query(final Host host) {
            HostConnectionPool pool = (HostConnectionPool)((RequestHandler)RequestHandler.this).manager.pools.get(host);
            if (pool == null || pool.isClosed()) {
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Querying node {}", (Object)this.id, (Object)host);
            }
            if (RequestHandler.this.allowSpeculativeExecutions && this.nextExecutionScheduled.compareAndSet(false, true)) {
                RequestHandler.this.scheduleExecution(RequestHandler.this.speculativeExecutionPlan.nextExecution(host));
            }
            PoolingOptions poolingOptions = RequestHandler.this.manager.configuration().getPoolingOptions();
            ListenableFuture<Connection> connectionFuture = pool.borrowConnection(poolingOptions.getPoolTimeoutMillis(), TimeUnit.MILLISECONDS, poolingOptions.getMaxQueueSize());
            GuavaCompatibility.INSTANCE.addCallback(connectionFuture, new FutureCallback<Connection>(){

                @Override
                public void onSuccess(Connection connection) {
                    if (RequestHandler.this.isDone.get()) {
                        connection.release();
                        return;
                    }
                    if (SpeculativeExecution.this.current != null) {
                        if (RequestHandler.this.triedHosts == null) {
                            RequestHandler.this.triedHosts = new CopyOnWriteArrayList();
                        }
                        RequestHandler.this.triedHosts.add(SpeculativeExecution.this.current);
                    }
                    SpeculativeExecution.this.current = host;
                    try {
                        SpeculativeExecution.this.write(connection, SpeculativeExecution.this);
                    }
                    catch (ConnectionException e) {
                        if (RequestHandler.this.metricsEnabled()) {
                            RequestHandler.this.metrics().getErrorMetrics().getConnectionErrors().inc();
                        }
                        if (connection != null) {
                            connection.release();
                        }
                        SpeculativeExecution.this.logError(host.getEndPoint(), e);
                        SpeculativeExecution.this.findNextHostAndQuery();
                    }
                    catch (BusyConnectionException e) {
                        connection.release(true);
                        SpeculativeExecution.this.logError(host.getEndPoint(), e);
                        SpeculativeExecution.this.findNextHostAndQuery();
                    }
                    catch (RuntimeException e) {
                        if (connection != null) {
                            connection.release();
                        }
                        logger.warn("Unexpected error while querying {} - [{}]. Find next host to query.", (Object)host.getEndPoint(), (Object)e.toString());
                        SpeculativeExecution.this.logError(host.getEndPoint(), e);
                        SpeculativeExecution.this.findNextHostAndQuery();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    if (t instanceof BusyPoolException) {
                        SpeculativeExecution.this.logError(host.getEndPoint(), t);
                    } else {
                        logger.warn("Unexpected error while querying {} - [{}]. Find next host to query.", (Object)host.getEndPoint(), (Object)t.toString());
                        SpeculativeExecution.this.logError(host.getEndPoint(), t);
                    }
                    SpeculativeExecution.this.findNextHostAndQuery();
                }
            });
            return true;
        }

        private void write(Connection connection, Connection.ResponseCallback responseCallback) throws ConnectionException, BusyConnectionException {
            QueryState previous;
            this.connectionHandler = null;
            do {
                if (!(previous = this.queryStateRef.get()).isCancelled()) continue;
                connection.release();
                return;
            } while (!previous.inProgress && !this.queryStateRef.compareAndSet(previous, previous.startNext()));
            this.connectionHandler = connection.write(responseCallback, RequestHandler.this.statement.getReadTimeoutMillis(), false);
            this.connectionHandler.startTimeout();
            if (this.queryStateRef.get() == QueryState.CANCELLED_WHILE_IN_PROGRESS && this.connectionHandler.cancelHandler()) {
                connection.release();
            }
        }

        private RetryPolicy.RetryDecision computeRetryDecisionOnRequestError(DriverException exception) {
            RetryPolicy.RetryDecision decision = RequestHandler.this.statement.isIdempotentWithDefault(((RequestHandler)RequestHandler.this).manager.cluster.getConfiguration().getQueryOptions()) ? RequestHandler.this.retryPolicy().onRequestError(RequestHandler.this.statement, this.request().consistency(), exception, this.retriesByPolicy) : RetryPolicy.RetryDecision.rethrow();
            if (RequestHandler.this.metricsEnabled()) {
                if (exception instanceof OperationTimedOutException) {
                    RequestHandler.this.metrics().getErrorMetrics().getClientTimeouts().inc();
                    if (decision.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                        RequestHandler.this.metrics().getErrorMetrics().getRetriesOnClientTimeout().inc();
                    }
                    if (decision.getType() == RetryPolicy.RetryDecision.Type.IGNORE) {
                        RequestHandler.this.metrics().getErrorMetrics().getIgnoresOnClientTimeout().inc();
                    }
                } else if (exception instanceof ConnectionException) {
                    RequestHandler.this.metrics().getErrorMetrics().getConnectionErrors().inc();
                    if (decision.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                        RequestHandler.this.metrics().getErrorMetrics().getRetriesOnConnectionError().inc();
                    }
                    if (decision.getType() == RetryPolicy.RetryDecision.Type.IGNORE) {
                        RequestHandler.this.metrics().getErrorMetrics().getIgnoresOnConnectionError().inc();
                    }
                } else {
                    RequestHandler.this.metrics().getErrorMetrics().getOthers().inc();
                    if (decision.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                        RequestHandler.this.metrics().getErrorMetrics().getRetriesOnOtherErrors().inc();
                    }
                    if (decision.getType() == RetryPolicy.RetryDecision.Type.IGNORE) {
                        RequestHandler.this.metrics().getErrorMetrics().getIgnoresOnOtherErrors().inc();
                    }
                }
            }
            return decision;
        }

        private void processRetryDecision(RetryPolicy.RetryDecision retryDecision, Connection connection, Exception exceptionToReport) {
            switch (retryDecision.getType()) {
                case RETRY: {
                    ++this.retriesByPolicy;
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{}] Doing retry {} for query {} at consistency {}", new Object[]{this.id, this.retriesByPolicy, RequestHandler.this.statement, retryDecision.getRetryConsistencyLevel()});
                    }
                    if (RequestHandler.this.metricsEnabled()) {
                        RequestHandler.this.metrics().getErrorMetrics().getRetries().inc();
                    }
                    if (!retryDecision.isRetryCurrent()) {
                        this.logError(connection.endPoint, exceptionToReport);
                    }
                    this.retry(retryDecision.isRetryCurrent(), retryDecision.getRetryConsistencyLevel());
                    break;
                }
                case RETHROW: {
                    this.setFinalException(connection, exceptionToReport);
                    break;
                }
                case IGNORE: {
                    if (RequestHandler.this.metricsEnabled()) {
                        RequestHandler.this.metrics().getErrorMetrics().getIgnores().inc();
                    }
                    this.setFinalResult(connection, new Responses.Result.Void());
                }
            }
        }

        private void retry(boolean retryCurrent, ConsistencyLevel newConsistencyLevel) {
            Host h = this.current;
            if (newConsistencyLevel != null) {
                this.retryConsistencyLevel = newConsistencyLevel;
            }
            if (this.queryStateRef.get().isCancelled()) {
                return;
            }
            if (!retryCurrent || !this.query(h)) {
                this.findNextHostAndQuery();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logError(EndPoint endPoint, Throwable exception) {
            logger.debug("[{}] Error querying {} : {}", new Object[]{this.id, endPoint, exception.toString()});
            if (RequestHandler.this.errors == null) {
                RequestHandler requestHandler = RequestHandler.this;
                synchronized (requestHandler) {
                    if (RequestHandler.this.errors == null) {
                        RequestHandler.this.errors = new ConcurrentHashMap();
                    }
                }
            }
            RequestHandler.this.errors.put(endPoint, exception);
        }

        void cancel() {
            Host queriedHost;
            QueryState previous;
            do {
                Host queriedHost2;
                if ((previous = this.queryStateRef.get()).isCancelled()) {
                    return;
                }
                if (!previous.inProgress || !this.queryStateRef.compareAndSet(previous, QueryState.CANCELLED_WHILE_IN_PROGRESS)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("[{}] Cancelled while in progress", (Object)this.id);
                }
                if (this.connectionHandler != null && this.connectionHandler.cancelHandler()) {
                    this.connectionHandler.connection.release();
                }
                if ((queriedHost2 = this.current) != null && RequestHandler.this.statement != Statement.DEFAULT) {
                    ((RequestHandler)RequestHandler.this).manager.cluster.manager.reportQuery(queriedHost2, RequestHandler.this.statement, CancelledSpeculativeExecutionException.INSTANCE, System.nanoTime() - this.startTime);
                }
                return;
            } while (previous.inProgress || !this.queryStateRef.compareAndSet(previous, QueryState.CANCELLED_WHILE_COMPLETE));
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Cancelled while complete", (Object)this.id);
            }
            if ((queriedHost = this.current) != null && RequestHandler.this.statement != Statement.DEFAULT) {
                ((RequestHandler)RequestHandler.this).manager.cluster.manager.reportQuery(queriedHost, RequestHandler.this.statement, CancelledSpeculativeExecutionException.INSTANCE, System.nanoTime() - this.startTime);
            }
        }

        @Override
        public Message.Request request() {
            if (this.retryConsistencyLevel != null && this.retryConsistencyLevel != this.request.consistency()) {
                return this.request.copy(this.retryConsistencyLevel);
            }
            return this.request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
            QueryState queryState = this.queryStateRef.get();
            if (!queryState.isInProgressAt(retryCount) || !this.queryStateRef.compareAndSet(queryState, queryState.complete())) {
                logger.debug("onSet triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, this.queryStateRef.get()});
                return;
            }
            Host queriedHost = this.current;
            Exception exceptionToReport = null;
            try {
                switch (response.type) {
                    case RESULT: {
                        connection.release();
                        this.setFinalResult(connection, response);
                        return;
                    }
                    case ERROR: {
                        Responses.Error err = (Responses.Error)response;
                        exceptionToReport = err.asException(connection.endPoint);
                        RetryPolicy.RetryDecision retry = null;
                        RetryPolicy retryPolicy = RequestHandler.this.retryPolicy();
                        switch (err.code) {
                            case READ_TIMEOUT: {
                                connection.release();
                                assert (err.infos instanceof ReadTimeoutException);
                                ReadTimeoutException rte = (ReadTimeoutException)err.infos;
                                retry = retryPolicy.onReadTimeout(RequestHandler.this.statement, rte.getConsistencyLevel(), rte.getRequiredAcknowledgements(), rte.getReceivedAcknowledgements(), rte.wasDataRetrieved(), this.retriesByPolicy);
                                if (!RequestHandler.this.metricsEnabled()) break;
                                RequestHandler.this.metrics().getErrorMetrics().getReadTimeouts().inc();
                                if (retry.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                                    RequestHandler.this.metrics().getErrorMetrics().getRetriesOnReadTimeout().inc();
                                }
                                if (retry.getType() != RetryPolicy.RetryDecision.Type.IGNORE) break;
                                RequestHandler.this.metrics().getErrorMetrics().getIgnoresOnReadTimeout().inc();
                                break;
                            }
                            case WRITE_TIMEOUT: {
                                connection.release();
                                assert (err.infos instanceof WriteTimeoutException);
                                WriteTimeoutException wte = (WriteTimeoutException)err.infos;
                                retry = RequestHandler.this.statement.isIdempotentWithDefault(((RequestHandler)RequestHandler.this).manager.cluster.getConfiguration().getQueryOptions()) ? retryPolicy.onWriteTimeout(RequestHandler.this.statement, wte.getConsistencyLevel(), wte.getWriteType(), wte.getRequiredAcknowledgements(), wte.getReceivedAcknowledgements(), this.retriesByPolicy) : RetryPolicy.RetryDecision.rethrow();
                                if (!RequestHandler.this.metricsEnabled()) break;
                                RequestHandler.this.metrics().getErrorMetrics().getWriteTimeouts().inc();
                                if (retry.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                                    RequestHandler.this.metrics().getErrorMetrics().getRetriesOnWriteTimeout().inc();
                                }
                                if (retry.getType() != RetryPolicy.RetryDecision.Type.IGNORE) break;
                                RequestHandler.this.metrics().getErrorMetrics().getIgnoresOnWriteTimeout().inc();
                                break;
                            }
                            case UNAVAILABLE: {
                                connection.release();
                                assert (err.infos instanceof UnavailableException);
                                UnavailableException ue = (UnavailableException)err.infos;
                                retry = retryPolicy.onUnavailable(RequestHandler.this.statement, ue.getConsistencyLevel(), ue.getRequiredReplicas(), ue.getAliveReplicas(), this.retriesByPolicy);
                                if (!RequestHandler.this.metricsEnabled()) break;
                                RequestHandler.this.metrics().getErrorMetrics().getUnavailables().inc();
                                if (retry.getType() == RetryPolicy.RetryDecision.Type.RETRY) {
                                    RequestHandler.this.metrics().getErrorMetrics().getRetriesOnUnavailable().inc();
                                }
                                if (retry.getType() != RetryPolicy.RetryDecision.Type.IGNORE) break;
                                RequestHandler.this.metrics().getErrorMetrics().getIgnoresOnUnavailable().inc();
                                break;
                            }
                            case OVERLOADED: {
                                connection.release();
                                assert (exceptionToReport instanceof OverloadedException);
                                logger.warn("Host {} is overloaded.", (Object)connection.endPoint);
                                retry = this.computeRetryDecisionOnRequestError((OverloadedException)exceptionToReport);
                                break;
                            }
                            case SERVER_ERROR: {
                                connection.release();
                                assert (exceptionToReport instanceof ServerError);
                                logger.warn("{} replied with server error ({}), defuncting connection.", (Object)connection.endPoint, (Object)err.message);
                                connection.defunct(exceptionToReport);
                                retry = this.computeRetryDecisionOnRequestError((ServerError)exceptionToReport);
                                break;
                            }
                            case IS_BOOTSTRAPPING: {
                                connection.release();
                                assert (exceptionToReport instanceof BootstrappingException);
                                logger.error("Query sent to {} but it is bootstrapping. This shouldn't happen but trying next host.", (Object)connection.endPoint);
                                if (RequestHandler.this.metricsEnabled()) {
                                    RequestHandler.this.metrics().getErrorMetrics().getOthers().inc();
                                }
                                this.logError(connection.endPoint, exceptionToReport);
                                this.retry(false, null);
                                return;
                            }
                            case UNPREPARED: {
                                assert (err.infos instanceof MD5Digest);
                                MD5Digest id = (MD5Digest)err.infos;
                                PreparedStatement toPrepare = (PreparedStatement)((RequestHandler)RequestHandler.this).manager.cluster.manager.preparedQueries.get(id);
                                if (toPrepare == null) {
                                    connection.release();
                                    String msg = String.format("Tried to execute unknown prepared query %s", id);
                                    logger.error(msg);
                                    this.setFinalException(connection, new DriverInternalError(msg));
                                    return;
                                }
                                String currentKeyspace = connection.keyspace();
                                String prepareKeyspace = toPrepare.getQueryKeyspace();
                                if (!(prepareKeyspace == null || currentKeyspace != null && currentKeyspace.equals(prepareKeyspace))) {
                                    connection.release();
                                    throw new IllegalStateException(String.format("Statement was prepared on keyspace %s, can't execute it on %s (%s)", toPrepare.getQueryKeyspace(), connection.keyspace(), toPrepare.getQueryString()));
                                }
                                logger.info("Query {} is not prepared on {}, preparing before retrying executing. Seeing this message a few times is fine, but seeing it a lot may be source of performance problems", new Object[]{toPrepare.getQueryString(), toPrepare.getQueryKeyspace(), connection.endPoint});
                                this.write(connection, this.prepareAndRetry(toPrepare.getQueryString()));
                                return;
                            }
                            case READ_FAILURE: {
                                assert (exceptionToReport instanceof ReadFailureException);
                                connection.release();
                                retry = this.computeRetryDecisionOnRequestError((ReadFailureException)exceptionToReport);
                                break;
                            }
                            case WRITE_FAILURE: {
                                assert (exceptionToReport instanceof WriteFailureException);
                                connection.release();
                                if (RequestHandler.this.statement.isIdempotentWithDefault(((RequestHandler)RequestHandler.this).manager.cluster.getConfiguration().getQueryOptions())) {
                                    retry = this.computeRetryDecisionOnRequestError((WriteFailureException)exceptionToReport);
                                    break;
                                }
                                retry = RetryPolicy.RetryDecision.rethrow();
                                break;
                            }
                            default: {
                                connection.release();
                                if (!RequestHandler.this.metricsEnabled()) break;
                                RequestHandler.this.metrics().getErrorMetrics().getOthers().inc();
                            }
                        }
                        if (retry == null) {
                            this.setFinalResult(connection, response);
                            return;
                        } else {
                            this.processRetryDecision(retry, connection, exceptionToReport);
                            return;
                        }
                    }
                    default: {
                        connection.release();
                        this.setFinalResult(connection, response);
                        return;
                    }
                }
            }
            catch (Exception e) {
                exceptionToReport = e;
                this.setFinalException(connection, e);
                return;
            }
            finally {
                if (queriedHost != null && RequestHandler.this.statement != Statement.DEFAULT) {
                    ((RequestHandler)RequestHandler.this).manager.cluster.manager.reportQuery(queriedHost, RequestHandler.this.statement, exceptionToReport, latency);
                }
            }
        }

        private Connection.ResponseCallback prepareAndRetry(final String toPrepare) {
            return new Connection.ResponseCallback(){

                @Override
                public Message.Request request() {
                    Requests.Prepare request = new Requests.Prepare(toPrepare);
                    request.setCustomPayload(RequestHandler.this.statement.getOutgoingPayload());
                    return request;
                }

                @Override
                public int retryCount() {
                    return SpeculativeExecution.this.retryCount();
                }

                @Override
                public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
                    QueryState queryState = (QueryState)SpeculativeExecution.this.queryStateRef.get();
                    if (!queryState.isInProgressAt(retryCount) || !SpeculativeExecution.this.queryStateRef.compareAndSet(queryState, queryState.complete())) {
                        logger.debug("onSet triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, SpeculativeExecution.this.queryStateRef.get()});
                        return;
                    }
                    connection.release();
                    switch (response.type) {
                        case RESULT: {
                            if (((Responses.Result)response).kind == Responses.Result.Kind.PREPARED) {
                                logger.debug("Scheduling retry now that query is prepared");
                                SpeculativeExecution.this.retry(true, null);
                                break;
                            }
                            SpeculativeExecution.this.logError(connection.endPoint, new DriverException("Got unexpected response to prepare message: " + response));
                            SpeculativeExecution.this.retry(false, null);
                            break;
                        }
                        case ERROR: {
                            SpeculativeExecution.this.logError(connection.endPoint, new DriverException("Error preparing query, got " + response));
                            if (RequestHandler.this.metricsEnabled()) {
                                RequestHandler.this.metrics().getErrorMetrics().getOthers().inc();
                            }
                            SpeculativeExecution.this.retry(false, null);
                            break;
                        }
                        default: {
                            SpeculativeExecution.this.setFinalResult(connection, response);
                        }
                    }
                }

                @Override
                public void onException(Connection connection, Exception exception, long latency, int retryCount) {
                    SpeculativeExecution.this.onException(connection, exception, latency, retryCount);
                }

                @Override
                public boolean onTimeout(Connection connection, long latency, int retryCount) {
                    QueryState queryState = (QueryState)SpeculativeExecution.this.queryStateRef.get();
                    if (!queryState.isInProgressAt(retryCount) || !SpeculativeExecution.this.queryStateRef.compareAndSet(queryState, queryState.complete())) {
                        logger.debug("onTimeout triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, SpeculativeExecution.this.queryStateRef.get()});
                        return false;
                    }
                    connection.release();
                    SpeculativeExecution.this.logError(connection.endPoint, new OperationTimedOutException(connection.endPoint, "Timed out waiting for response to PREPARE message"));
                    SpeculativeExecution.this.retry(false, null);
                    return true;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onException(Connection connection, Exception exception, long latency, int retryCount) {
            QueryState queryState = this.queryStateRef.get();
            if (!queryState.isInProgressAt(retryCount) || !this.queryStateRef.compareAndSet(queryState, queryState.complete())) {
                logger.debug("onException triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, this.queryStateRef.get()});
                return;
            }
            Host queriedHost = this.current;
            try {
                connection.release();
                if (exception instanceof ConnectionException) {
                    RetryPolicy.RetryDecision decision = this.computeRetryDecisionOnRequestError((ConnectionException)exception);
                    this.processRetryDecision(decision, connection, exception);
                    return;
                }
                this.setFinalException(connection, exception);
            }
            catch (Exception e) {
                this.setFinalException(null, new DriverInternalError("An unexpected error happened while handling exception " + exception, e));
            }
            finally {
                if (queriedHost != null && RequestHandler.this.statement != Statement.DEFAULT) {
                    ((RequestHandler)RequestHandler.this).manager.cluster.manager.reportQuery(queriedHost, RequestHandler.this.statement, exception, latency);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onTimeout(Connection connection, long latency, int retryCount) {
            QueryState queryState = this.queryStateRef.get();
            if (!queryState.isInProgressAt(retryCount) || !this.queryStateRef.compareAndSet(queryState, queryState.complete())) {
                logger.debug("onTimeout triggered but the response was completed by another thread, cancelling (retryCount = {}, queryState = {}, queryStateRef = {})", new Object[]{retryCount, queryState, this.queryStateRef.get()});
                return false;
            }
            Host queriedHost = this.current;
            OperationTimedOutException timeoutException = new OperationTimedOutException(connection.endPoint, "Timed out waiting for server response");
            try {
                connection.release();
                RetryPolicy.RetryDecision decision = this.computeRetryDecisionOnRequestError(timeoutException);
                this.processRetryDecision(decision, connection, timeoutException);
            }
            catch (Exception e) {
                this.setFinalException(null, new DriverInternalError("An unexpected error happened while handling timeout", e));
            }
            finally {
                if (queriedHost != null && RequestHandler.this.statement != Statement.DEFAULT) {
                    ((RequestHandler)RequestHandler.this).manager.cluster.manager.reportQuery(queriedHost, RequestHandler.this.statement, timeoutException, latency);
                }
            }
            return true;
        }

        @Override
        public int retryCount() {
            return this.queryStateRef.get().retryCount;
        }

        private void setFinalException(Connection connection, Exception exception) {
            RequestHandler.this.setFinalException(this, connection, exception);
        }

        private void setFinalResult(Connection connection, Message.Response response) {
            RequestHandler.this.setFinalResult(this, connection, response);
        }
    }

    static interface Callback
    extends Connection.ResponseCallback {
        public void onSet(Connection var1, Message.Response var2, ExecutionInfo var3, Statement var4, long var5);

        public void register(RequestHandler var1);
    }
}

