/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.FunctionExecutionException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.QueryConsistencyException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.policies.ChainableLoadBalancingPolicy;
import com.datastax.driver.core.policies.Clock;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RollingCount;
import cz.o2.proxima.cassandra.shaded.com.google.common.annotations.Beta;
import cz.o2.proxima.cassandra.shaded.com.google.common.annotations.VisibleForTesting;
import cz.o2.proxima.cassandra.shaded.com.google.common.collect.AbstractIterator;
import cz.o2.proxima.cassandra.shaded.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ErrorAwarePolicy
implements ChainableLoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(ErrorAwarePolicy.class);
    private final LoadBalancingPolicy childPolicy;
    private final long retryPeriodNanos;
    PerHostErrorTracker errorTracker;

    private ErrorAwarePolicy(Builder builder) {
        this.childPolicy = builder.childPolicy;
        this.retryPeriodNanos = builder.retryPeriodNanos;
        this.errorTracker = new PerHostErrorTracker(builder.maxErrorsPerMinute, builder.errorFilter, builder.clock);
    }

    @Override
    public LoadBalancingPolicy getChildPolicy() {
        return this.childPolicy;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.childPolicy.init(cluster, hosts);
        cluster.register(this.errorTracker);
    }

    @Override
    public HostDistance distance(Host host) {
        return this.childPolicy.distance(host);
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        final Iterator<Host> childQueryPlan = this.childPolicy.newQueryPlan(loggedKeyspace, statement);
        return new AbstractIterator<Host>(){

            @Override
            protected Host computeNext() {
                while (childQueryPlan.hasNext()) {
                    Host host = (Host)childQueryPlan.next();
                    if (ErrorAwarePolicy.this.errorTracker.isExcluded(host)) continue;
                    return host;
                }
                return (Host)this.endOfData();
            }
        };
    }

    @Override
    public void onAdd(Host host) {
        this.childPolicy.onAdd(host);
    }

    @Override
    public void onUp(Host host) {
        this.childPolicy.onUp(host);
    }

    @Override
    public void onDown(Host host) {
        this.childPolicy.onDown(host);
    }

    @Override
    public void onRemove(Host host) {
        this.childPolicy.onRemove(host);
    }

    public static Builder builder(LoadBalancingPolicy childPolicy) {
        return new Builder(childPolicy);
    }

    @Override
    public void close() {
        this.childPolicy.close();
    }

    public static interface ErrorFilter {
        public boolean shouldConsiderError(Exception var1, Host var2, Statement var3);
    }

    static class DefaultErrorFilter
    implements ErrorFilter {
        private static final List<Class<? extends Exception>> IGNORED_EXCEPTIONS = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(FunctionExecutionException.class)).add(QueryConsistencyException.class)).add(UnavailableException.class)).add(AlreadyExistsException.class)).add(InvalidQueryException.class)).add(SyntaxError.class)).build();

        DefaultErrorFilter() {
        }

        @Override
        public boolean shouldConsiderError(Exception e, Host host, Statement statement) {
            for (Class<? extends Exception> ignoredException : IGNORED_EXCEPTIONS) {
                if (!ignoredException.isInstance(e)) continue;
                return false;
            }
            return true;
        }
    }

    class PerHostErrorTracker
    implements LatencyTracker {
        private final int maxErrorsPerMinute;
        private final ErrorFilter errorFilter;
        private final Clock clock;
        private final ConcurrentMap<Host, RollingCount> hostsCounts = new ConcurrentHashMap<Host, RollingCount>();
        private final ConcurrentMap<Host, Long> exclusionTimes = new ConcurrentHashMap<Host, Long>();

        PerHostErrorTracker(int maxErrorsPerMinute, ErrorFilter errorFilter, Clock clock) {
            this.maxErrorsPerMinute = maxErrorsPerMinute;
            this.errorFilter = errorFilter;
            this.clock = clock;
        }

        @Override
        public void update(Host host, Statement statement, Exception exception, long newLatencyNanos) {
            if (exception == null) {
                return;
            }
            if (!this.errorFilter.shouldConsiderError(exception, host, statement)) {
                return;
            }
            RollingCount hostCount = this.getOrCreateCount(host);
            hostCount.increment();
        }

        boolean isExcluded(Host host) {
            boolean expired;
            Long excludedTime = (Long)this.exclusionTimes.get(host);
            boolean bl = expired = excludedTime != null && this.clock.nanoTime() - excludedTime >= ErrorAwarePolicy.this.retryPeriodNanos;
            if (excludedTime == null || expired) {
                if (this.maybeExcludeNow(host, excludedTime)) {
                    return true;
                }
                if (expired) {
                    this.exclusionTimes.remove(host, excludedTime);
                }
                return false;
            }
            return true;
        }

        private boolean maybeExcludeNow(Host host, Long previousTime) {
            RollingCount rollingCount = this.getOrCreateCount(host);
            long count = rollingCount.get();
            if (count > (long)this.maxErrorsPerMinute) {
                this.excludeNow(host, count, previousTime);
                return true;
            }
            return false;
        }

        private void excludeNow(Host host, long count, Long previousTime) {
            boolean didNotRace;
            long now = this.clock.nanoTime();
            boolean bl = previousTime == null ? this.exclusionTimes.putIfAbsent(host, now) == null : (didNotRace = this.exclusionTimes.replace(host, previousTime, now));
            if (didNotRace && logger.isDebugEnabled()) {
                logger.debug(String.format("Host %s encountered %d errors in the last minute, which is more than the maximum allowed (%d). It will be excluded from query plans for the next %d nanoseconds.", host, count, this.maxErrorsPerMinute, ErrorAwarePolicy.this.retryPeriodNanos));
            }
        }

        private RollingCount getOrCreateCount(Host host) {
            RollingCount tmp;
            RollingCount hostCount = (RollingCount)this.hostsCounts.get(host);
            if (hostCount == null && (hostCount = this.hostsCounts.putIfAbsent(host, tmp = new RollingCount(this.clock))) == null) {
                hostCount = tmp;
            }
            return hostCount;
        }

        @Override
        public void onRegister(Cluster cluster) {
        }

        @Override
        public void onUnregister(Cluster cluster) {
        }
    }

    public static class Builder {
        final LoadBalancingPolicy childPolicy;
        private int maxErrorsPerMinute = 1;
        private long retryPeriodNanos = TimeUnit.NANOSECONDS.convert(2L, TimeUnit.MINUTES);
        private Clock clock = Clock.DEFAULT;
        private ErrorFilter errorFilter = new DefaultErrorFilter();

        public Builder(LoadBalancingPolicy childPolicy) {
            this.childPolicy = childPolicy;
        }

        public Builder withMaxErrorsPerMinute(int maxErrorsPerMinute) {
            this.maxErrorsPerMinute = maxErrorsPerMinute;
            return this;
        }

        public Builder withRetryPeriod(long retryPeriod, TimeUnit retryPeriodTimeUnit) {
            this.retryPeriodNanos = retryPeriodTimeUnit.toNanos(retryPeriod);
            return this;
        }

        public Builder withErrorsFilter(ErrorFilter errorFilter) {
            this.errorFilter = errorFilter;
            return this;
        }

        @VisibleForTesting
        Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public ErrorAwarePolicy build() {
            return new ErrorAwarePolicy(this);
        }
    }
}

