/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.utils;

import com.datastax.driver.core.Native;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Charsets;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UUIDs {
    public static final String PID_SYSTEM_PROPERTY = "com.datastax.driver.PID";
    private static final Logger LOGGER = LoggerFactory.getLogger(UUIDs.class);
    private static final long START_EPOCH = UUIDs.makeEpoch();
    private static final long CLOCK_SEQ_AND_NODE = UUIDs.makeClockSeqAndNode();
    private static final long MIN_CLOCK_SEQ_AND_NODE = -9187201950435737472L;
    private static final long MAX_CLOCK_SEQ_AND_NODE = 0x7F7F7F7F7F7F7F7FL;
    private static final AtomicLong lastTimestamp = new AtomicLong(0L);

    private UUIDs() {
    }

    private static long makeEpoch() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT-0"));
        c.set(1, 1582);
        c.set(2, 9);
        c.set(5, 15);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    private static long makeNode() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (String address : UUIDs.getAllLocalAddresses()) {
                UUIDs.update(digest, address);
            }
            Properties props = System.getProperties();
            UUIDs.update(digest, props.getProperty("java.vendor"));
            UUIDs.update(digest, props.getProperty("java.vendor.url"));
            UUIDs.update(digest, props.getProperty("java.version"));
            UUIDs.update(digest, props.getProperty("os.arch"));
            UUIDs.update(digest, props.getProperty("os.name"));
            UUIDs.update(digest, props.getProperty("os.version"));
            UUIDs.update(digest, UUIDs.getProcessPiece());
            byte[] hash = digest.digest();
            long node = 0L;
            for (int i = 0; i < 6; ++i) {
                node |= (0xFFL & (long)hash[i]) << i * 8;
            }
            return node | 0x10000000000L;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getProcessPiece() {
        ClassLoader loader;
        Integer pid = null;
        String pidProperty = System.getProperty(PID_SYSTEM_PROPERTY);
        if (pidProperty != null) {
            try {
                pid = Integer.parseInt(pidProperty);
                LOGGER.info("PID obtained from System property {}: {}", (Object)PID_SYSTEM_PROPERTY, (Object)pid);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Incorrect integer specified for PID in System property {}: {}", (Object)PID_SYSTEM_PROPERTY, (Object)pidProperty);
            }
        }
        if (pid == null && Native.isGetpidAvailable()) {
            try {
                pid = Native.processId();
                if (pid == 0) {
                    LOGGER.warn("PID returned through native call was 0, JNR versions incompatible?  Falling back to JMX.");
                    pid = null;
                } else {
                    LOGGER.info("PID obtained through native call to getpid(): {}", (Object)pid);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Native call to getpid() failed", (Throwable)e);
            }
        }
        if (pid == null) {
            try {
                String pidJmx = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
                pid = Integer.parseInt(pidJmx);
                LOGGER.info("PID obtained through JMX: {}", (Object)pid);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to obtain PID from JMX", (Throwable)e);
            }
        }
        if (pid == null) {
            pid = new Random().nextInt();
            LOGGER.warn("Could not determine PID, falling back to a random integer: {}", (Object)pid);
        }
        int loaderId = (loader = UUIDs.class.getClassLoader()) != null ? System.identityHashCode(loader) : 0;
        return Integer.toHexString(pid) + Integer.toHexString(loaderId);
    }

    private static void update(MessageDigest digest, String value) {
        if (value != null) {
            digest.update(value.getBytes(Charsets.UTF_8));
        }
    }

    private static long makeClockSeqAndNode() {
        long clock = new Random(System.currentTimeMillis()).nextLong();
        long node = UUIDs.makeNode();
        long lsb = 0L;
        lsb |= (clock & 0x3FFFL) << 48;
        lsb |= Long.MIN_VALUE;
        return lsb |= node;
    }

    public static UUID random() {
        return UUID.randomUUID();
    }

    public static UUID timeBased() {
        return new UUID(UUIDs.makeMSB(UUIDs.getCurrentTimestamp()), CLOCK_SEQ_AND_NODE);
    }

    public static UUID startOf(long timestamp) {
        return new UUID(UUIDs.makeMSB(UUIDs.fromUnixTimestamp(timestamp)), -9187201950435737472L);
    }

    public static UUID endOf(long timestamp) {
        long uuidTstamp = UUIDs.fromUnixTimestamp(timestamp + 1L) - 1L;
        return new UUID(UUIDs.makeMSB(uuidTstamp), 0x7F7F7F7F7F7F7F7FL);
    }

    public static long unixTimestamp(UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException(String.format("Can only retrieve the unix timestamp for version 1 uuid (provided version %d)", uuid.version()));
        }
        long timestamp = uuid.timestamp();
        return timestamp / 10000L + START_EPOCH;
    }

    private static long getCurrentTimestamp() {
        long candidate;
        while (true) {
            long last;
            long now;
            if ((now = UUIDs.fromUnixTimestamp(System.currentTimeMillis())) > (last = lastTimestamp.get())) {
                if (!lastTimestamp.compareAndSet(last, now)) continue;
                return now;
            }
            long lastMillis = UUIDs.millisOf(last);
            if (UUIDs.millisOf(now) < UUIDs.millisOf(last)) {
                return lastTimestamp.incrementAndGet();
            }
            candidate = last + 1L;
            if (UUIDs.millisOf(candidate) == lastMillis && lastTimestamp.compareAndSet(last, candidate)) break;
        }
        return candidate;
    }

    static long fromUnixTimestamp(long tstamp) {
        return (tstamp - START_EPOCH) * 10000L;
    }

    private static long millisOf(long timestamp) {
        return timestamp / 10000L;
    }

    static long makeMSB(long timestamp) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & timestamp) << 32;
        msb |= (0xFFFF00000000L & timestamp) >>> 16;
        msb |= (0xFFF000000000000L & timestamp) >>> 48;
        return msb |= 0x1000L;
    }

    private static Set<String> getAllLocalAddresses() {
        HashSet<String> allIps = new HashSet<String>();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            allIps.add(localhost.toString());
            allIps.add(localhost.getCanonicalHostName());
            InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (allMyIps != null) {
                for (int i = 0; i < allMyIps.length; ++i) {
                    allIps.add(allMyIps[i].toString());
                }
            }
        }
        catch (UnknownHostException localhost) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en != null) {
                while (en.hasMoreElements()) {
                    Enumeration<InetAddress> enumIpAddr = en.nextElement().getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        allIps.add(enumIpAddr.nextElement().toString());
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return allIps;
    }
}

