/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.jnr.constants.platform.windows;

import cz.o2.proxima.cassandra.shaded.jnr.constants.Constant;
import java.util.EnumMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    E2BIG(7),
    ENFILE(23),
    EPERM(1),
    EDEADLK(36),
    EBADF(9),
    EMFILE(24),
    ENXIO(6),
    ECHILD(10),
    ERANGE(34),
    EBUSY(16),
    EAGAIN(11),
    ESPIPE(29),
    EFBIG(27),
    EINVAL(22),
    EXDEV(18),
    EACCES(13),
    EIO(5),
    EDOM(33),
    ENOTEMPTY(41),
    ENOLCK(39),
    EINTR(4),
    ENOTDIR(20),
    EROFS(30),
    EISDIR(21),
    ENOMEM(12),
    ENODEV(19),
    ENOSPC(28),
    ENOEXEC(8),
    ENOSYS(40),
    EEXIST(17),
    ENOTTY(25),
    ENAMETOOLONG(38),
    EPIPE(32),
    ESRCH(3),
    EILSEQ(42),
    EFAULT(14),
    ENOENT(2),
    EMLINK(31);

    private final int value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 42L;

    private Errno(int value) {
        this.value = value;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map = new EnumMap<Errno, String>(Errno.class);
            map.put(E2BIG, "Arg list too long");
            map.put(ENFILE, "Too many open files in system");
            map.put(EPERM, "Operation not permitted");
            map.put(EDEADLK, "Resource deadlock avoided");
            map.put(EBADF, "Bad file descriptor");
            map.put(EMFILE, "Too many open files");
            map.put(ENXIO, "No such device or address");
            map.put(ECHILD, "No child processes");
            map.put(ERANGE, "Result too large");
            map.put(EBUSY, "Resource device");
            map.put(EAGAIN, "Resource temporarily unavailable");
            map.put(ESPIPE, "Invalid seek");
            map.put(EFBIG, "File too large");
            map.put(EINVAL, "Invalid argument");
            map.put(EXDEV, "Improper link");
            map.put(EACCES, "Permission denied");
            map.put(EIO, "Input/output error");
            map.put(EDOM, "Domain error");
            map.put(ENOTEMPTY, "Directory not empty");
            map.put(ENOLCK, "No locks available");
            map.put(EINTR, "Interrupted function call");
            map.put(ENOTDIR, "Not a directory");
            map.put(EROFS, "Read-only file system");
            map.put(EISDIR, "Is a directory");
            map.put(ENOMEM, "Not enough space");
            map.put(ENODEV, "No such device");
            map.put(ENOSPC, "No space left on device");
            map.put(ENOEXEC, "Exec format error");
            map.put(ENOSYS, "Function not implemented");
            map.put(EEXIST, "File exists");
            map.put(ENOTTY, "Inappropriate I/O control operation");
            map.put(ENAMETOOLONG, "Filename too long");
            map.put(EPIPE, "Broken pipe");
            map.put(ESRCH, "No such process");
            map.put(EILSEQ, "Illegal byte sequence");
            map.put(EFAULT, "Bad address");
            map.put(ENOENT, "No such file or directory");
            map.put(EMLINK, "Too many links");
            return map;
        }
    }
}

