/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.converters;

import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.ToNativeContext;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.ToNativeConverter;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class Long32ArrayParameterConverter
implements ToNativeConverter<long[], int[]> {
    private static final Long32ArrayParameterConverter IN = new Long32ArrayParameterConverter(2);
    private static final Long32ArrayParameterConverter OUT = new Out(1);
    private static final Long32ArrayParameterConverter INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<long[], int[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    private Long32ArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public int[] toNative(long[] array, ToNativeContext context) {
        if (array == null) {
            return null;
        }
        int[] primitive = new int[array.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i = 0; i < array.length; ++i) {
                primitive[i] = (int)array[i];
            }
        }
        return primitive;
    }

    @Override
    public Class<int[]> nativeType() {
        return int[].class;
    }

    public static final class Out
    extends Long32ArrayParameterConverter
    implements ToNativeConverter.PostInvocation<long[], int[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(long[] array, int[] primitive, ToNativeContext context) {
            if (array != null && primitive != null) {
                for (int i = 0; i < array.length; ++i) {
                    array[i] = primitive[i];
                }
            }
        }
    }
}

