/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi;

import cz.o2.proxima.cassandra.shaded.com.kenai.jffi.MemoryIO;
import cz.o2.proxima.cassandra.shaded.com.kenai.jffi.ObjectParameterStrategy;
import cz.o2.proxima.cassandra.shaded.com.kenai.jffi.ObjectParameterType;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.ParameterStrategy;
import java.nio.Buffer;
import java.util.EnumSet;

public final class BufferParameterStrategy
extends ParameterStrategy {
    private final int shift;
    private static final BufferParameterStrategy[] DIRECT_BUFFER_PARAMETER_STRATEGIES;
    private static final BufferParameterStrategy[] HEAP_BUFFER_PARAMETER_STRATEGIES;

    private BufferParameterStrategy(ObjectParameterStrategy.StrategyType type, ObjectParameterType.ComponentType componentType) {
        super(type, ObjectParameterType.create(ObjectParameterType.ObjectType.ARRAY, componentType));
        this.shift = BufferParameterStrategy.calculateShift(componentType);
    }

    public long address(Buffer buffer) {
        return buffer != null && buffer.isDirect() ? MemoryIO.getInstance().getDirectBufferAddress(buffer) + (long)(buffer.position() << this.shift) : 0L;
    }

    public long address(Object o) {
        return this.address((Buffer)o);
    }

    public Object object(Object o) {
        return ((Buffer)o).array();
    }

    public int offset(Object o) {
        Buffer buffer = (Buffer)o;
        return buffer.arrayOffset() + buffer.position();
    }

    public int length(Object o) {
        return ((Buffer)o).remaining();
    }

    static int calculateShift(ObjectParameterType.ComponentType componentType) {
        switch (componentType) {
            case BYTE: {
                return 0;
            }
            case SHORT: 
            case CHAR: {
                return 1;
            }
            case INT: 
            case BOOLEAN: 
            case FLOAT: {
                return 2;
            }
            case LONG: 
            case DOUBLE: {
                return 3;
            }
        }
        throw new IllegalArgumentException("unsupported component type: " + (Object)((Object)componentType));
    }

    static BufferParameterStrategy direct(ObjectParameterType.ComponentType componentType) {
        return DIRECT_BUFFER_PARAMETER_STRATEGIES[componentType.ordinal()];
    }

    static BufferParameterStrategy heap(ObjectParameterType.ComponentType componentType) {
        return HEAP_BUFFER_PARAMETER_STRATEGIES[componentType.ordinal()];
    }

    static {
        EnumSet<ObjectParameterType.ComponentType> componentTypes = EnumSet.allOf(ObjectParameterType.ComponentType.class);
        DIRECT_BUFFER_PARAMETER_STRATEGIES = new BufferParameterStrategy[componentTypes.size()];
        HEAP_BUFFER_PARAMETER_STRATEGIES = new BufferParameterStrategy[componentTypes.size()];
        for (ObjectParameterType.ComponentType componentType : componentTypes) {
            BufferParameterStrategy.DIRECT_BUFFER_PARAMETER_STRATEGIES[componentType.ordinal()] = new BufferParameterStrategy(DIRECT, componentType);
            BufferParameterStrategy.HEAP_BUFFER_PARAMETER_STRATEGIES[componentType.ordinal()] = new BufferParameterStrategy(HEAP, componentType);
        }
    }
}

