/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi;

import cz.o2.proxima.cassandra.shaded.jnr.ffi.Pointer;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.Runtime;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.BoundedMemoryIO;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.IntPointer;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.MemoryManager;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.ArrayMemoryIO;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.ByteBufferMemoryIO;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.DirectMemoryIO;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.NativeRuntime;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.TransientNativeMemory;
import java.nio.ByteBuffer;

public class NativeMemoryManager
implements MemoryManager {
    private final Runtime runtime;
    private final long addressMask;

    public NativeMemoryManager(NativeRuntime runtime) {
        this.runtime = runtime;
        this.addressMask = runtime.addressMask();
    }

    @Override
    public Pointer allocate(int size) {
        return new ArrayMemoryIO(this.runtime, size);
    }

    @Override
    public Pointer allocateDirect(int size) {
        return new BoundedMemoryIO(TransientNativeMemory.allocate(this.runtime, size, 8, true), 0L, size);
    }

    @Override
    public Pointer allocateDirect(int size, boolean clear) {
        return new BoundedMemoryIO(TransientNativeMemory.allocate(this.runtime, size, 8, clear), 0L, size);
    }

    public Pointer allocateTemporary(int size) {
        return new BoundedMemoryIO(TransientNativeMemory.allocate(this.runtime, size, 8, true), 0L, size);
    }

    @Override
    public Pointer allocateTemporary(int size, boolean clear) {
        return new BoundedMemoryIO(TransientNativeMemory.allocate(this.runtime, size, 8, clear), 0L, size);
    }

    @Override
    public Pointer newPointer(ByteBuffer buffer) {
        return new ByteBufferMemoryIO(this.runtime, buffer);
    }

    @Override
    public Pointer newPointer(long address) {
        return new DirectMemoryIO(this.runtime, address & this.addressMask);
    }

    @Override
    public Pointer newPointer(long address, long size) {
        return new BoundedMemoryIO(new DirectMemoryIO(this.runtime, address & this.addressMask), 0L, size);
    }

    @Override
    public Pointer newOpaquePointer(long address) {
        return new IntPointer(this.runtime, address);
    }
}

