/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi;

import cz.o2.proxima.cassandra.shaded.com.kenai.jffi.LastError;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.NativeType;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.ObjectReferenceManager;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.Platform;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.Runtime;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.Type;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.TypeAlias;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.DefaultTypeMapper;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.SignatureTypeMapperAdapter;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.AbstractRuntime;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.BadType;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.DefaultObjectReferenceManager;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.AsmClassLoader;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.NativeClosureManager;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.provider.jffi.NativeMemoryManager;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NativeRuntime
extends AbstractRuntime {
    private final NativeMemoryManager mm = new NativeMemoryManager(this);
    private final NativeClosureManager closureManager = new NativeClosureManager(this, new SignatureTypeMapperAdapter(new DefaultTypeMapper()), new AsmClassLoader(NativeRuntime.getParentClassLoader()));
    private final Type[] aliases;

    private static ClassLoader getParentClassLoader() {
        ClassLoader cl = NativeRuntime.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static NativeRuntime getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private NativeRuntime() {
        super(ByteOrder.nativeOrder(), NativeRuntime.buildTypeMap());
        NativeType[] nativeAliases = NativeRuntime.buildNativeTypeAliases();
        EnumSet<TypeAlias> typeAliasSet = EnumSet.allOf(TypeAlias.class);
        this.aliases = new Type[typeAliasSet.size()];
        for (TypeAlias alias : typeAliasSet) {
            if (nativeAliases.length > alias.ordinal() && nativeAliases[alias.ordinal()] != NativeType.VOID) {
                this.aliases[alias.ordinal()] = this.findType(nativeAliases[alias.ordinal()]);
                continue;
            }
            this.aliases[alias.ordinal()] = new BadType(alias.name());
        }
    }

    private static EnumMap<NativeType, Type> buildTypeMap() {
        EnumMap<NativeType, Type> typeMap = new EnumMap<NativeType, Type>(NativeType.class);
        EnumSet<NativeType> nativeTypes = EnumSet.allOf(NativeType.class);
        for (NativeType t : nativeTypes) {
            typeMap.put(t, NativeRuntime.jafflType(t));
        }
        return typeMap;
    }

    private static NativeType[] buildNativeTypeAliases() {
        Platform platform = Platform.getNativePlatform();
        Package pkg = NativeRuntime.class.getPackage();
        String cpu = platform.getCPU().toString();
        String os = platform.getOS().toString();
        EnumSet<TypeAlias> typeAliases = EnumSet.allOf(TypeAlias.class);
        NativeType[] aliases = new NativeType[]{};
        try {
            Class<?> cls = Class.forName(pkg.getName() + ".platform." + cpu + "." + os + ".TypeAliases");
            Field aliasesField = cls.getField("ALIASES");
            Map aliasMap = (Map)Map.class.cast(aliasesField.get(cls));
            aliases = new NativeType[typeAliases.size()];
            for (TypeAlias t : typeAliases) {
                aliases[t.ordinal()] = (NativeType)((Object)aliasMap.get((Object)t));
                if (aliases[t.ordinal()] != null) continue;
                aliases[t.ordinal()] = NativeType.VOID;
            }
        }
        catch (ClassNotFoundException cne) {
            Logger.getLogger(NativeRuntime.class.getName()).log(Level.SEVERE, "failed to load type aliases: " + cne);
        }
        catch (NoSuchFieldException nsfe) {
            Logger.getLogger(NativeRuntime.class.getName()).log(Level.SEVERE, "failed to load type aliases: " + nsfe);
        }
        catch (IllegalAccessException iae) {
            Logger.getLogger(NativeRuntime.class.getName()).log(Level.SEVERE, "failed to load type aliases: " + iae);
        }
        return aliases;
    }

    @Override
    public Type findType(TypeAlias type) {
        return this.aliases[type.ordinal()];
    }

    @Override
    public final NativeMemoryManager getMemoryManager() {
        return this.mm;
    }

    @Override
    public NativeClosureManager getClosureManager() {
        return this.closureManager;
    }

    public ObjectReferenceManager newObjectReferenceManager() {
        return new DefaultObjectReferenceManager(this);
    }

    @Override
    public int getLastError() {
        return LastError.getInstance().get();
    }

    @Override
    public void setLastError(int error) {
        LastError.getInstance().set(error);
    }

    @Override
    public boolean isCompatible(Runtime other) {
        return other instanceof NativeRuntime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeRuntime that = (NativeRuntime)o;
        return Arrays.equals(this.aliases, that.aliases) && this.closureManager.equals(that.closureManager) && this.mm.equals(that.mm);
    }

    public int hashCode() {
        int result = this.mm.hashCode();
        result = 31 * result + this.closureManager.hashCode();
        result = 31 * result + Arrays.hashCode(this.aliases);
        return result;
    }

    private static Type jafflType(NativeType type) {
        switch (type) {
            case VOID: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.VOID, NativeType.VOID);
            }
            case SCHAR: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.SCHAR, NativeType.SCHAR);
            }
            case UCHAR: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.UCHAR, NativeType.UCHAR);
            }
            case SSHORT: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.SSHORT, NativeType.SSHORT);
            }
            case USHORT: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.USHORT, NativeType.USHORT);
            }
            case SINT: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.SINT, NativeType.SINT);
            }
            case UINT: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.UINT, NativeType.UINT);
            }
            case SLONG: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.SLONG, NativeType.SLONG);
            }
            case ULONG: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.ULONG, NativeType.ULONG);
            }
            case SLONGLONG: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.SINT64, NativeType.SLONGLONG);
            }
            case ULONGLONG: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.UINT64, NativeType.ULONGLONG);
            }
            case FLOAT: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.FLOAT, NativeType.FLOAT);
            }
            case DOUBLE: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.DOUBLE, NativeType.DOUBLE);
            }
            case ADDRESS: {
                return new TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type.POINTER, NativeType.ADDRESS);
            }
        }
        return new BadType(type.toString());
    }

    private static final class TypeDelegate
    extends Type {
        private final cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type type;
        private final NativeType nativeType;

        public TypeDelegate(cz.o2.proxima.cassandra.shaded.com.kenai.jffi.Type type, NativeType nativeType) {
            this.type = type;
            this.nativeType = nativeType;
        }

        @Override
        public int alignment() {
            return this.type.alignment();
        }

        @Override
        public int size() {
            return this.type.size();
        }

        @Override
        public NativeType getNativeType() {
            return this.nativeType;
        }

        public String toString() {
            return this.type.toString();
        }
    }

    private static final class SingletonHolder {
        public static final NativeRuntime INSTANCE = new NativeRuntime();

        private SingletonHolder() {
        }
    }
}

