/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.jnr.posix;

import cz.o2.proxima.cassandra.shaded.jnr.constants.Constant;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.Platform;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.FromNativeContext;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.FromNativeConverter;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.ToNativeContext;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.ToNativeConverter;
import cz.o2.proxima.cassandra.shaded.jnr.ffi.mapper.TypeMapper;
import cz.o2.proxima.cassandra.shaded.jnr.posix.AixPOSIX;
import cz.o2.proxima.cassandra.shaded.jnr.posix.BaseNativePOSIX;
import cz.o2.proxima.cassandra.shaded.jnr.posix.FileStat;
import cz.o2.proxima.cassandra.shaded.jnr.posix.FreeBSDPOSIX;
import cz.o2.proxima.cassandra.shaded.jnr.posix.Group;
import cz.o2.proxima.cassandra.shaded.jnr.posix.HANDLE;
import cz.o2.proxima.cassandra.shaded.jnr.posix.LinuxPOSIX;
import cz.o2.proxima.cassandra.shaded.jnr.posix.MacOSPOSIX;
import cz.o2.proxima.cassandra.shaded.jnr.posix.MsgHdr;
import cz.o2.proxima.cassandra.shaded.jnr.posix.NativeTimes;
import cz.o2.proxima.cassandra.shaded.jnr.posix.OpenBSDPOSIX;
import cz.o2.proxima.cassandra.shaded.jnr.posix.Passwd;
import cz.o2.proxima.cassandra.shaded.jnr.posix.SolarisPOSIX;
import cz.o2.proxima.cassandra.shaded.jnr.posix.WString;
import cz.o2.proxima.cassandra.shaded.jnr.posix.WindowsPOSIX;
import cz.o2.proxima.cassandra.shaded.jnr.posix.util.Platform;

final class POSIXTypeMapper
implements TypeMapper {
    public static final TypeMapper INSTANCE = new POSIXTypeMapper();

    private POSIXTypeMapper() {
    }

    @Override
    public FromNativeConverter getFromNativeConverter(Class klazz) {
        if (Passwd.class.isAssignableFrom(klazz)) {
            if (Platform.IS_MAC) {
                return MacOSPOSIX.PASSWD;
            }
            if (Platform.IS_LINUX) {
                return LinuxPOSIX.PASSWD;
            }
            if (Platform.IS_SOLARIS) {
                return SolarisPOSIX.PASSWD;
            }
            if (Platform.IS_FREEBSD) {
                return FreeBSDPOSIX.PASSWD;
            }
            if (Platform.IS_OPENBSD) {
                return OpenBSDPOSIX.PASSWD;
            }
            if (Platform.IS_WINDOWS) {
                return WindowsPOSIX.PASSWD;
            }
            if (cz.o2.proxima.cassandra.shaded.jnr.ffi.Platform.getNativePlatform().getOS().equals((Object)Platform.OS.AIX)) {
                return AixPOSIX.PASSWD;
            }
            return null;
        }
        if (Group.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.GROUP;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        return null;
    }

    @Override
    public ToNativeConverter getToNativeConverter(Class klazz) {
        if (FileStat.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.FileStatConverter;
        }
        if (NativeTimes.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.TimesConverter;
        }
        if (Constant.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.ConstantConverter;
        }
        if (WString.class.isAssignableFrom(klazz)) {
            return WString.Converter;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        if (MsgHdr.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.MsgHdrConverter;
        }
        return null;
    }

    public final ToNativeConverter getToNativeConverter(Class klazz, ToNativeContext context) {
        return this.getToNativeConverter(klazz);
    }

    public final FromNativeConverter getFromNativeConverter(Class klazz, FromNativeContext context) {
        return this.getFromNativeConverter(klazz);
    }
}

