/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.io.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Session;
import cz.o2.proxima.core.storage.StreamElement;
import cz.o2.proxima.direct.core.AbstractOnlineAttributeWriter;
import cz.o2.proxima.direct.core.CommitCallback;
import cz.o2.proxima.direct.core.OnlineAttributeWriter;
import cz.o2.proxima.direct.io.cassandra.CassandraDBAccessor;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraWriter
extends AbstractOnlineAttributeWriter
implements OnlineAttributeWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraWriter.class);
    private final CassandraDBAccessor accessor;
    private final CassandraDBAccessor.ClusterHolder clusterHolder;

    CassandraWriter(CassandraDBAccessor accessor) {
        super(accessor.getEntityDescriptor(), accessor.getUri());
        this.accessor = accessor;
        this.clusterHolder = accessor.acquireCluster();
    }

    public synchronized void write(StreamElement data, CommitCallback statusCallback) {
        try {
            Session session = this.accessor.ensureSession();
            Optional<BoundStatement> cql = this.accessor.getCqlFactory().getWriteStatement(data, session);
            if (cql.isPresent()) {
                if (log.isDebugEnabled()) {
                    log.debug("Executing statement {} to write {}", (Object)cql.get().preparedStatement().getQueryString(), (Object)data);
                }
                this.accessor.execute(cql.get());
            } else {
                log.warn("Missing CQL statement to write {}. Discarding.", (Object)data);
            }
            statusCallback.commit(true, null);
        }
        catch (Exception ex) {
            log.error("Failed to ingest record {} into cassandra", (Object)data, (Object)ex);
            statusCallback.commit(false, (Throwable)ex);
        }
    }

    public OnlineAttributeWriter.Factory<?> asFactory() {
        CassandraDBAccessor accessor = this.accessor;
        return (OnlineAttributeWriter.Factory & Serializable)repo -> new CassandraWriter(accessor);
    }

    public void close() {
        this.clusterHolder.close();
    }
}

