/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.SSLOptions;
import cz.o2.proxima.cassandra.shaded.com.google.common.collect.ImmutableList;
import java.net.InetSocketAddress;
import java.util.List;

class CloudConfig {
    private final InetSocketAddress proxyAddress;
    private final List<EndPoint> endPoints;
    private final String localDatacenter;
    private final SSLOptions sslOptions;
    private final AuthProvider authProvider;

    CloudConfig(InetSocketAddress proxyAddress, List<EndPoint> endPoints, String localDatacenter, SSLOptions sslOptions, AuthProvider authProvider) {
        this.proxyAddress = proxyAddress;
        this.endPoints = ImmutableList.copyOf(endPoints);
        this.localDatacenter = localDatacenter;
        this.sslOptions = sslOptions;
        this.authProvider = authProvider;
    }

    InetSocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    List<EndPoint> getEndPoints() {
        return this.endPoints;
    }

    String getLocalDatacenter() {
        return this.localDatacenter;
    }

    SSLOptions getSslOptions() {
        return this.sslOptions;
    }

    AuthProvider getAuthProvider() {
        return this.authProvider;
    }
}

