/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.EndPoint;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Objects;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.cassandra.shaded.com.google.common.primitives.UnsignedBytes;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;

public class SniEndPoint
implements EndPoint {
    private static final AtomicLong OFFSET = new AtomicLong();
    private final InetSocketAddress proxyAddress;
    private final String serverName;
    private static final Comparator<InetAddress> IP_COMPARATOR = new Comparator<InetAddress>(){

        @Override
        public int compare(InetAddress address1, InetAddress address2) {
            return UnsignedBytes.lexicographicalComparator().compare(address1.getAddress(), address2.getAddress());
        }
    };

    public SniEndPoint(InetSocketAddress proxyAddress, String serverName) {
        Preconditions.checkNotNull(proxyAddress);
        Preconditions.checkNotNull(serverName);
        this.proxyAddress = proxyAddress;
        this.serverName = serverName;
    }

    @Override
    public InetSocketAddress resolve() {
        if (this.proxyAddress.isUnresolved()) {
            try {
                InetAddress[] aRecords = InetAddress.getAllByName(this.proxyAddress.getHostName());
                if (aRecords.length == 0) {
                    throw new IllegalArgumentException("Could not resolve proxy address " + this.proxyAddress.getHostName());
                }
                Arrays.sort(aRecords, IP_COMPARATOR);
                int index = aRecords.length == 1 ? 0 : (int)OFFSET.getAndIncrement() % aRecords.length;
                return new InetSocketAddress(aRecords[index], this.proxyAddress.getPort());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Could not resolve proxy address " + this.proxyAddress.getHostName(), e);
            }
        }
        return this.proxyAddress;
    }

    String getServerName() {
        return this.serverName;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SniEndPoint) {
            SniEndPoint that = (SniEndPoint)other;
            return this.proxyAddress.equals(that.proxyAddress) && this.serverName.equals(that.serverName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.proxyAddress, this.serverName);
    }

    public String toString() {
        return this.proxyAddress.toString() + ":" + this.serverName;
    }
}

