/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.com.google.common.graph;

import cz.o2.proxima.cassandra.shaded.com.google.common.annotations.Beta;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Optional;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.cassandra.shaded.com.google.common.graph.AbstractGraphBuilder;
import cz.o2.proxima.cassandra.shaded.com.google.common.graph.ConfigurableMutableValueGraph;
import cz.o2.proxima.cassandra.shaded.com.google.common.graph.ElementOrder;
import cz.o2.proxima.cassandra.shaded.com.google.common.graph.Graphs;
import cz.o2.proxima.cassandra.shaded.com.google.common.graph.ImmutableValueGraph;
import cz.o2.proxima.cassandra.shaded.com.google.common.graph.MutableValueGraph;
import cz.o2.proxima.cassandra.shaded.com.google.common.graph.ValueGraph;

@Beta
public final class ValueGraphBuilder<N, V>
extends AbstractGraphBuilder<N> {
    private ValueGraphBuilder(boolean directed) {
        super(directed);
    }

    public static ValueGraphBuilder<Object, Object> directed() {
        return new ValueGraphBuilder<Object, Object>(true);
    }

    public static ValueGraphBuilder<Object, Object> undirected() {
        return new ValueGraphBuilder<Object, Object>(false);
    }

    public static <N, V> ValueGraphBuilder<N, V> from(ValueGraph<N, V> graph) {
        return new ValueGraphBuilder<N, V>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops()).nodeOrder(graph.nodeOrder());
    }

    public <N1 extends N, V1 extends V> ImmutableValueGraph.Builder<N1, V1> immutable() {
        ValueGraphBuilder<N1, V1> castBuilder = this.cast();
        return new ImmutableValueGraph.Builder<N1, V1>(castBuilder);
    }

    public ValueGraphBuilder<N, V> allowsSelfLoops(boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    public ValueGraphBuilder<N, V> expectedNodeCount(int expectedNodeCount) {
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative(expectedNodeCount));
        return this;
    }

    public <N1 extends N> ValueGraphBuilder<N1, V> nodeOrder(ElementOrder<N1> nodeOrder) {
        ValueGraphBuilder newBuilder = this.cast();
        newBuilder.nodeOrder = Preconditions.checkNotNull(nodeOrder);
        return newBuilder;
    }

    public <N1 extends N, V1 extends V> MutableValueGraph<N1, V1> build() {
        return new ConfigurableMutableValueGraph(this);
    }

    private <N1 extends N, V1 extends V> ValueGraphBuilder<N1, V1> cast() {
        return this;
    }
}

