/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Token;
import cz.o2.proxima.direct.cassandra.CassandraDBAccessor;
import cz.o2.proxima.direct.cassandra.CqlFactory;
import cz.o2.proxima.direct.cassandra.Offsets;
import cz.o2.proxima.direct.randomaccess.KeyValue;
import cz.o2.proxima.direct.randomaccess.RandomAccessReader;
import cz.o2.proxima.direct.randomaccess.RandomOffset;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.storage.AbstractStorage;
import cz.o2.proxima.util.Pair;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraRandomReader
extends AbstractStorage
implements RandomAccessReader {
    private static final Logger log = LoggerFactory.getLogger(CassandraRandomReader.class);
    private final CassandraDBAccessor accessor;

    CassandraRandomReader(CassandraDBAccessor accessor) {
        super(accessor.getEntityDescriptor(), accessor.getUri());
        this.accessor = accessor;
    }

    public synchronized <T> Optional<KeyValue<T>> get(String key, String attribute, AttributeDescriptor<T> desc, long stamp) {
        ResultSet result;
        Session session = this.accessor.ensureSession();
        BoundStatement statement = this.accessor.getCqlFactory().getReadStatement(key, attribute, desc, session);
        try {
            result = this.accessor.execute(statement);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        for (Row row : result) {
            ByteBuffer val = row.getBytes(0);
            if (val == null) continue;
            byte[] rowValue = val.array();
            try {
                return Optional.of(KeyValue.of((EntityDescriptor)this.getEntityDescriptor(), desc, (String)key, (String)attribute, (RandomOffset)new Offsets.Raw(attribute), (byte[])rowValue));
            }
            catch (Exception ex) {
                log.warn("Failed to read data from {}.{}", key, attribute, ex);
            }
        }
        return Optional.empty();
    }

    public void scanWildcardAll(String key, RandomOffset offset, long stamp, int limit, Consumer<KeyValue<?>> consumer) {
        try {
            Offsets.Raw off = (Offsets.Raw)offset;
            Session session = this.accessor.ensureSession();
            CqlFactory.KvIterable iter = this.accessor.getCqlFactory().getListAllStatement(key, off, limit, session);
            for (KeyValue kv : iter.iterable(this.accessor)) {
                if (kv.getAttribute().compareTo(off.getRaw()) <= 0) continue;
                if (limit-- != 0) {
                    consumer.accept(kv);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            log.error("Failed to scan attributes of {}", (Object)key, (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    public synchronized <T> void scanWildcard(String key, AttributeDescriptor<T> wildcard, @Nullable RandomOffset offset, long stamp, int limit, Consumer<KeyValue<T>> consumer) {
        try {
            Session session = this.accessor.ensureSession();
            BoundStatement statement = this.accessor.getCqlFactory().getListStatement(key, wildcard, (Offsets.Raw)offset, limit, session);
            ResultSet result = this.accessor.execute(statement);
            for (Row row : result) {
                Object attribute = row.getObject(0);
                ByteBuffer val = row.getBytes(1);
                if (val == null) continue;
                byte[] rowValue = val.array();
                String name = wildcard.toAttributePrefix() + this.accessor.getConverter().asString(attribute);
                Optional parsed = wildcard.getValueSerializer().deserialize(rowValue);
                if (parsed.isPresent()) {
                    consumer.accept((Object)KeyValue.of((EntityDescriptor)this.getEntityDescriptor(), wildcard, (String)key, (String)name, (RandomOffset)new Offsets.Raw(name), parsed.get(), (byte[])rowValue));
                    continue;
                }
                log.error("Failed to parse value for key {} attribute {}.{}", key, wildcard, attribute);
            }
        }
        catch (Exception ex) {
            log.error("Failed to scan wildcard attribute {}", (Object)wildcard, (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    public synchronized void listEntities(RandomOffset offset, int limit, Consumer<Pair<RandomOffset, String>> consumer) {
        Session session = this.accessor.ensureSession();
        BoundStatement statement = this.accessor.getCqlFactory().getListEntitiesStatement((Offsets.Token)offset, limit, session);
        try {
            ResultSet result = this.accessor.execute(statement);
            for (Row row : result) {
                String key = row.getString(0);
                Token token = row.getToken(1);
                consumer.accept((Object)Pair.of((Object)new Offsets.Token((Long)token.getValue()), (Object)key));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public RandomAccessReader.Factory asFactory() {
        CassandraDBAccessor accessor = this.accessor;
        return (RandomAccessReader.Factory & Serializable)repo -> new CassandraRandomReader(accessor);
    }

    public synchronized void close() {
        this.accessor.close();
    }

    public synchronized RandomOffset fetchOffset(RandomAccessReader.Listing type, String key) {
        try {
            switch (type) {
                case ATTRIBUTE: {
                    return new Offsets.Raw(key);
                }
                case ENTITY: {
                    Session session = this.accessor.ensureSession();
                    ResultSet res = this.accessor.execute(this.accessor.getCqlFactory().getFetchTokenStatement(key, session));
                    if (res.isExhausted()) {
                        return new Offsets.Token(Long.MIN_VALUE);
                    }
                    return new Offsets.Token(res.one().getLong(0));
                }
            }
            throw new IllegalArgumentException("Unknown type of listing: " + type);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

