/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.direct.cassandra;

import cz.o2.proxima.cassandra.shaded.com.google.common.base.Strings;
import cz.o2.proxima.direct.cassandra.StringConverter;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateToLongConverter
implements StringConverter<Date> {
    private static final Logger log = LoggerFactory.getLogger(DateToLongConverter.class);
    private static final long serialVersionUID = 1L;
    private static final Date MAX = new Date(Long.MAX_VALUE);
    private static final Date MIN = new Date(Long.MIN_VALUE);

    @Override
    public String asString(Date what) {
        return String.valueOf(what.getTime());
    }

    @Override
    @Nullable
    public Date fromString(String what) {
        if (Strings.isNullOrEmpty(what)) {
            return null;
        }
        try {
            return new Date(Long.parseLong(what));
        }
        catch (Exception ex) {
            log.error("Error converting {} to long", (Object)what, (Object)ex);
            return null;
        }
    }

    @Override
    public Date max() {
        return MAX;
    }

    @Override
    public Date min() {
        return MIN;
    }
}

