/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.datastax.driver.core.utils.MoreObjects;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Preconditions;
import cz.o2.proxima.cassandra.shaded.com.google.common.cache.CacheBuilder;
import cz.o2.proxima.cassandra.shaded.com.google.common.cache.CacheLoader;
import cz.o2.proxima.cassandra.shaded.com.google.common.cache.LoadingCache;
import cz.o2.proxima.cassandra.shaded.com.google.common.cache.RemovalListener;
import cz.o2.proxima.cassandra.shaded.com.google.common.cache.RemovalNotification;
import cz.o2.proxima.cassandra.shaded.com.google.common.cache.Weigher;
import cz.o2.proxima.cassandra.shaded.com.google.common.reflect.TypeToken;
import cz.o2.proxima.cassandra.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecRegistry {
    private static final Logger logger = LoggerFactory.getLogger(CodecRegistry.class);
    private static final Map<DataType.Name, TypeCodec<?>> BUILT_IN_CODECS_MAP = new EnumMap(DataType.Name.class);
    private static final TypeCodec<?>[] BUILT_IN_CODECS;
    public static final CodecRegistry DEFAULT_INSTANCE;
    private final CopyOnWriteArrayList<TypeCodec<?>> codecs = new CopyOnWriteArrayList();
    private final LoadingCache<CacheKey, TypeCodec<?>> cache = this.defaultCacheBuilder().build(new TypeCodecCacheLoader());

    private CacheBuilder<CacheKey, TypeCodec<?>> defaultCacheBuilder() {
        CacheBuilder<CacheKey, TypeCodec<Object>> builder = CacheBuilder.newBuilder().initialCapacity(100).maximumWeight(1000L).weigher(new TypeCodecWeigher());
        if (logger.isTraceEnabled()) {
            builder = builder.removalListener(new TypeCodecRemovalListener());
        }
        return builder;
    }

    public CodecRegistry register(TypeCodec<?> newCodec) {
        for (TypeCodec<?> oldCodec : BUILT_IN_CODECS) {
            if (!oldCodec.accepts(newCodec.getCqlType()) || !oldCodec.accepts(newCodec.getJavaType())) continue;
            logger.warn("Ignoring codec {} because it collides with previously registered codec {}", (Object)newCodec, (Object)oldCodec);
            return this;
        }
        for (TypeCodec typeCodec : this.codecs) {
            if (!typeCodec.accepts(newCodec.getCqlType()) || !typeCodec.accepts(newCodec.getJavaType())) continue;
            logger.warn("Ignoring codec {} because it collides with previously registered codec {}", (Object)newCodec, (Object)typeCodec);
            return this;
        }
        CacheKey key = new CacheKey(newCodec.getCqlType(), newCodec.getJavaType());
        TypeCodec typeCodec = (TypeCodec)this.cache.getIfPresent(key);
        if (typeCodec != null) {
            logger.warn("Ignoring codec {} because it collides with previously generated codec {}", (Object)newCodec, (Object)typeCodec);
            return this;
        }
        this.codecs.add(newCodec);
        return this;
    }

    public CodecRegistry register(TypeCodec<?> ... codecs) {
        for (TypeCodec<?> codec : codecs) {
            this.register(codec);
        }
        return this;
    }

    public CodecRegistry register(Iterable<? extends TypeCodec<?>> codecs) {
        for (TypeCodec<?> codec : codecs) {
            this.register(codec);
        }
        return this;
    }

    public <T> TypeCodec<T> codecFor(T value) {
        return this.findCodec(null, value);
    }

    public <T> TypeCodec<T> codecFor(DataType cqlType) throws CodecNotFoundException {
        return this.lookupCodec(cqlType, null);
    }

    public <T> TypeCodec<T> codecFor(DataType cqlType, Class<T> javaType) throws CodecNotFoundException {
        return this.codecFor(cqlType, (T)TypeToken.of(javaType));
    }

    public <T> TypeCodec<T> codecFor(DataType cqlType, TypeToken<T> javaType) throws CodecNotFoundException {
        return this.lookupCodec(cqlType, javaType);
    }

    public <T> TypeCodec<T> codecFor(DataType cqlType, T value) {
        return this.findCodec(cqlType, value);
    }

    private <T> TypeCodec<T> lookupCodec(DataType cqlType, TypeToken<T> javaType) {
        Preconditions.checkNotNull(cqlType, "Parameter cqlType cannot be null");
        TypeCodec<T> codec = BUILT_IN_CODECS_MAP.get((Object)cqlType.getName());
        if (codec != null && (javaType == null || codec.accepts(javaType))) {
            logger.trace("Returning built-in codec {}", (Object)codec);
            return codec;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Querying cache for codec [{} <-> {}]", (Object)CodecRegistry.toString(cqlType), (Object)CodecRegistry.toString(javaType));
        }
        try {
            CacheKey cacheKey = new CacheKey(cqlType, javaType);
            codec = this.cache.get(cacheKey);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof CodecNotFoundException) {
                throw (CodecNotFoundException)e.getCause();
            }
            throw new CodecNotFoundException(e.getCause(), cqlType, javaType);
        }
        catch (RuntimeException e) {
            throw new CodecNotFoundException(e.getCause(), cqlType, javaType);
        }
        catch (ExecutionException e) {
            throw new CodecNotFoundException(e.getCause(), cqlType, javaType);
        }
        logger.trace("Returning cached codec {}", (Object)codec);
        return codec;
    }

    private <T> TypeCodec<T> findCodec(DataType cqlType, TypeToken<T> javaType) {
        Preconditions.checkNotNull(cqlType, "Parameter cqlType cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for codec [{} <-> {}]", (Object)CodecRegistry.toString(cqlType), (Object)CodecRegistry.toString(javaType));
        }
        for (TypeCodec<T> typeCodec : BUILT_IN_CODECS) {
            if (!typeCodec.accepts(cqlType) || javaType != null && !typeCodec.accepts(javaType)) continue;
            logger.trace("Built-in codec found: {}", (Object)typeCodec);
            return typeCodec;
        }
        for (TypeCodec typeCodec : this.codecs) {
            if (!typeCodec.accepts(cqlType) || javaType != null && !typeCodec.accepts(javaType)) continue;
            logger.trace("Already registered codec found: {}", (Object)typeCodec);
            return typeCodec;
        }
        return this.createCodec(cqlType, (T)javaType);
    }

    private <T> TypeCodec<T> findCodec(DataType cqlType, T value) {
        Preconditions.checkNotNull(value, "Parameter value cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("Looking for codec [{} <-> {}]", (Object)CodecRegistry.toString(cqlType), (Object)value.getClass());
        }
        for (TypeCodec<?> codec : BUILT_IN_CODECS) {
            if (cqlType != null && !codec.accepts(cqlType) || !codec.accepts(value)) continue;
            logger.trace("Built-in codec found: {}", (Object)codec);
            return codec;
        }
        for (TypeCodec typeCodec : this.codecs) {
            if (cqlType != null && !typeCodec.accepts(cqlType) || !typeCodec.accepts(value)) continue;
            logger.trace("Already registered codec found: {}", (Object)typeCodec);
            return typeCodec;
        }
        return this.createCodec(cqlType, value);
    }

    private <T> TypeCodec<T> createCodec(DataType cqlType, TypeToken<T> javaType) {
        TypeCodec<TypeToken<T>> codec = this.maybeCreateCodec(cqlType, (T)javaType);
        if (codec == null) {
            throw CodecRegistry.notFound(cqlType, javaType);
        }
        if (!codec.accepts(cqlType) || javaType != null && !codec.accepts(javaType)) {
            throw CodecRegistry.notFound(cqlType, javaType);
        }
        logger.trace("Codec created: {}", (Object)codec);
        return codec;
    }

    private <T> TypeCodec<T> createCodec(DataType cqlType, T value) {
        TypeCodec<T> codec = this.maybeCreateCodec(cqlType, value);
        if (codec == null) {
            throw CodecRegistry.notFound(cqlType, TypeToken.of(value.getClass()));
        }
        if (cqlType != null && !codec.accepts(cqlType) || !codec.accepts(value)) {
            throw CodecRegistry.notFound(cqlType, TypeToken.of(value.getClass()));
        }
        logger.trace("Codec created: {}", (Object)codec);
        return codec;
    }

    private <T> TypeCodec<T> maybeCreateCodec(DataType cqlType, TypeToken<T> javaType) {
        Preconditions.checkNotNull(cqlType);
        if (cqlType.getName() == DataType.Name.LIST && (javaType == null || List.class.isAssignableFrom(javaType.getRawType()))) {
            TypeToken<?> elementType = null;
            if (javaType != null && javaType.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)javaType.getType()).getActualTypeArguments();
                elementType = TypeToken.of(typeArguments[0]);
            }
            TypeCodec<Object> eltCodec = this.findCodec(cqlType.getTypeArguments().get(0), (T)elementType);
            return TypeCodec.list(eltCodec);
        }
        if (cqlType.getName() == DataType.Name.SET && (javaType == null || Set.class.isAssignableFrom(javaType.getRawType()))) {
            TypeToken<?> elementType = null;
            if (javaType != null && javaType.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)javaType.getType()).getActualTypeArguments();
                elementType = TypeToken.of(typeArguments[0]);
            }
            TypeCodec<Object> eltCodec = this.findCodec(cqlType.getTypeArguments().get(0), (T)elementType);
            return TypeCodec.set(eltCodec);
        }
        if (cqlType.getName() == DataType.Name.MAP && (javaType == null || Map.class.isAssignableFrom(javaType.getRawType()))) {
            TypeToken<?> keyType = null;
            TypeToken<?> valueType = null;
            if (javaType != null && javaType.getType() instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)javaType.getType()).getActualTypeArguments();
                keyType = TypeToken.of(typeArguments[0]);
                valueType = TypeToken.of(typeArguments[1]);
            }
            TypeCodec<Object> keyCodec = this.findCodec(cqlType.getTypeArguments().get(0), (T)keyType);
            TypeCodec<Object> valueCodec = this.findCodec(cqlType.getTypeArguments().get(1), (T)valueType);
            return TypeCodec.map(keyCodec, valueCodec);
        }
        if (cqlType instanceof TupleType && (javaType == null || TupleValue.class.isAssignableFrom(javaType.getRawType()))) {
            return TypeCodec.tuple((TupleType)cqlType);
        }
        if (cqlType instanceof UserType && (javaType == null || UDTValue.class.isAssignableFrom(javaType.getRawType()))) {
            return TypeCodec.userType((UserType)cqlType);
        }
        if (cqlType instanceof DataType.CustomType && (javaType == null || ByteBuffer.class.isAssignableFrom(javaType.getRawType()))) {
            return TypeCodec.custom((DataType.CustomType)cqlType);
        }
        return null;
    }

    private <T> TypeCodec<T> maybeCreateCodec(DataType cqlType, T value) {
        Preconditions.checkNotNull(value);
        if ((cqlType == null || cqlType.getName() == DataType.Name.LIST) && value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                DataType elementType = cqlType == null || cqlType.getTypeArguments().isEmpty() ? DataType.blob() : cqlType.getTypeArguments().get(0);
                return TypeCodec.list(this.findCodec(elementType, (T)null));
            }
            DataType elementType = cqlType == null || cqlType.getTypeArguments().isEmpty() ? null : cqlType.getTypeArguments().get(0);
            return TypeCodec.list(this.findCodec(elementType, list.iterator().next()));
        }
        if ((cqlType == null || cqlType.getName() == DataType.Name.SET) && value instanceof Set) {
            Set set = (Set)value;
            if (set.isEmpty()) {
                DataType elementType = cqlType == null || cqlType.getTypeArguments().isEmpty() ? DataType.blob() : cqlType.getTypeArguments().get(0);
                return TypeCodec.set(this.findCodec(elementType, (T)null));
            }
            DataType elementType = cqlType == null || cqlType.getTypeArguments().isEmpty() ? null : cqlType.getTypeArguments().get(0);
            return TypeCodec.set(this.findCodec(elementType, set.iterator().next()));
        }
        if ((cqlType == null || cqlType.getName() == DataType.Name.MAP) && value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                DataType keyType = cqlType == null || cqlType.getTypeArguments().size() < 1 ? DataType.blob() : cqlType.getTypeArguments().get(0);
                DataType valueType = cqlType == null || cqlType.getTypeArguments().size() < 2 ? DataType.blob() : cqlType.getTypeArguments().get(1);
                return TypeCodec.map(this.findCodec(keyType, (T)null), this.findCodec(valueType, (T)null));
            }
            DataType keyType = cqlType == null || cqlType.getTypeArguments().size() < 1 ? null : cqlType.getTypeArguments().get(0);
            DataType valueType = cqlType == null || cqlType.getTypeArguments().size() < 2 ? null : cqlType.getTypeArguments().get(1);
            Map.Entry entry = map.entrySet().iterator().next();
            return TypeCodec.map(this.findCodec(keyType, entry.getKey()), this.findCodec(valueType, entry.getValue()));
        }
        if ((cqlType == null || cqlType.getName() == DataType.Name.TUPLE) && value instanceof TupleValue) {
            return TypeCodec.tuple(cqlType == null ? ((TupleValue)value).getType() : (TupleType)cqlType);
        }
        if ((cqlType == null || cqlType.getName() == DataType.Name.UDT) && value instanceof UDTValue) {
            return TypeCodec.userType(cqlType == null ? ((UDTValue)value).getType() : (UserType)cqlType);
        }
        if (cqlType != null && cqlType instanceof DataType.CustomType && value instanceof ByteBuffer) {
            return TypeCodec.custom((DataType.CustomType)cqlType);
        }
        return null;
    }

    private static CodecNotFoundException notFound(DataType cqlType, TypeToken<?> javaType) {
        String msg = String.format("Codec not found for requested operation: [%s <-> %s]", CodecRegistry.toString(cqlType), CodecRegistry.toString(javaType));
        return new CodecNotFoundException(msg, cqlType, javaType);
    }

    private static String toString(Object value) {
        return value == null ? "ANY" : value.toString();
    }

    static {
        BUILT_IN_CODECS_MAP.put(DataType.Name.ASCII, TypeCodec.ascii());
        BUILT_IN_CODECS_MAP.put(DataType.Name.BIGINT, TypeCodec.bigint());
        BUILT_IN_CODECS_MAP.put(DataType.Name.BLOB, TypeCodec.blob());
        BUILT_IN_CODECS_MAP.put(DataType.Name.BOOLEAN, TypeCodec.cboolean());
        BUILT_IN_CODECS_MAP.put(DataType.Name.COUNTER, TypeCodec.counter());
        BUILT_IN_CODECS_MAP.put(DataType.Name.DECIMAL, TypeCodec.decimal());
        BUILT_IN_CODECS_MAP.put(DataType.Name.DOUBLE, TypeCodec.cdouble());
        BUILT_IN_CODECS_MAP.put(DataType.Name.FLOAT, TypeCodec.cfloat());
        BUILT_IN_CODECS_MAP.put(DataType.Name.INET, TypeCodec.inet());
        BUILT_IN_CODECS_MAP.put(DataType.Name.INT, TypeCodec.cint());
        BUILT_IN_CODECS_MAP.put(DataType.Name.TEXT, TypeCodec.varchar());
        BUILT_IN_CODECS_MAP.put(DataType.Name.TIMESTAMP, TypeCodec.timestamp());
        BUILT_IN_CODECS_MAP.put(DataType.Name.UUID, TypeCodec.uuid());
        BUILT_IN_CODECS_MAP.put(DataType.Name.VARCHAR, TypeCodec.varchar());
        BUILT_IN_CODECS_MAP.put(DataType.Name.VARINT, TypeCodec.varint());
        BUILT_IN_CODECS_MAP.put(DataType.Name.TIMEUUID, TypeCodec.timeUUID());
        BUILT_IN_CODECS_MAP.put(DataType.Name.SMALLINT, TypeCodec.smallInt());
        BUILT_IN_CODECS_MAP.put(DataType.Name.TINYINT, TypeCodec.tinyInt());
        BUILT_IN_CODECS_MAP.put(DataType.Name.DATE, TypeCodec.date());
        BUILT_IN_CODECS_MAP.put(DataType.Name.TIME, TypeCodec.time());
        BUILT_IN_CODECS_MAP.put(DataType.Name.DURATION, TypeCodec.duration());
        BUILT_IN_CODECS = new TypeCodec[]{TypeCodec.varchar(), TypeCodec.uuid(), TypeCodec.timeUUID(), TypeCodec.timestamp(), TypeCodec.cint(), TypeCodec.bigint(), TypeCodec.blob(), TypeCodec.cdouble(), TypeCodec.cfloat(), TypeCodec.decimal(), TypeCodec.varint(), TypeCodec.inet(), TypeCodec.cboolean(), TypeCodec.smallInt(), TypeCodec.tinyInt(), TypeCodec.date(), TypeCodec.time(), TypeCodec.duration(), TypeCodec.counter(), TypeCodec.ascii()};
        DEFAULT_INSTANCE = new CodecRegistry();
    }

    private class TypeCodecRemovalListener
    implements RemovalListener<CacheKey, TypeCodec<?>> {
        private TypeCodecRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<CacheKey, TypeCodec<?>> notification) {
            logger.trace("Evicting codec from cache: {} (cause: {})", notification.getValue(), (Object)notification.getCause());
        }
    }

    private class TypeCodecWeigher
    implements Weigher<CacheKey, TypeCodec<?>> {
        private TypeCodecWeigher() {
        }

        @Override
        public int weigh(CacheKey key, TypeCodec<?> value) {
            return CodecRegistry.this.codecs.contains(value) ? 0 : this.weigh(value.cqlType, 0);
        }

        @Override
        private int weigh(DataType cqlType, int level) {
            switch (cqlType.getName()) {
                case LIST: 
                case SET: 
                case MAP: {
                    int weight = level;
                    for (DataType eltType : cqlType.getTypeArguments()) {
                        weight += this.weigh(eltType, level + 1);
                    }
                    return weight;
                }
                case UDT: {
                    int weight = level;
                    for (UserType.Field field : (UserType)cqlType) {
                        weight += this.weigh(field.getType(), level + 1);
                    }
                    return weight == 0 ? 1 : weight;
                }
                case TUPLE: {
                    int weight = level;
                    for (DataType componentType : ((TupleType)cqlType).getComponentTypes()) {
                        weight += this.weigh(componentType, level + 1);
                    }
                    return weight == 0 ? 1 : weight;
                }
                case CUSTOM: {
                    return 1;
                }
            }
            return 0;
        }
    }

    private class TypeCodecCacheLoader
    extends CacheLoader<CacheKey, TypeCodec<?>> {
        private TypeCodecCacheLoader() {
        }

        @Override
        public TypeCodec<?> load(CacheKey cacheKey) {
            Preconditions.checkNotNull(cacheKey.cqlType, "Parameter cqlType cannot be null");
            if (logger.isTraceEnabled()) {
                logger.trace("Loading codec into cache: [{} <-> {}]", (Object)CodecRegistry.toString(cacheKey.cqlType), (Object)CodecRegistry.toString(cacheKey.javaType));
            }
            for (TypeCodec codec : CodecRegistry.this.codecs) {
                if (!codec.accepts(cacheKey.cqlType) || cacheKey.javaType != null && !codec.accepts(cacheKey.javaType)) continue;
                logger.trace("Already existing codec found: {}", (Object)codec);
                return codec;
            }
            return CodecRegistry.this.createCodec(cacheKey.cqlType, (Object)cacheKey.javaType);
        }
    }

    private static final class CacheKey {
        private final DataType cqlType;
        private final TypeToken<?> javaType;

        CacheKey(DataType cqlType, TypeToken<?> javaType) {
            this.javaType = javaType;
            this.cqlType = cqlType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return MoreObjects.equal(this.cqlType, cacheKey.cqlType) && MoreObjects.equal(this.javaType, cacheKey.javaType);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.cqlType, this.javaType);
        }
    }
}

