/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.SchemaStatement;
import cz.o2.proxima.cassandra.shaded.com.google.common.base.Optional;

public class Drop
extends SchemaStatement {
    private Optional<String> keyspaceName = Optional.absent();
    private String itemName;
    private boolean ifExists;
    private final String itemType;

    Drop(String keyspaceName, String itemName, DroppedItem itemType) {
        this.itemType = itemType.name();
        Drop.validateNotEmpty(keyspaceName, "Keyspace name");
        Drop.validateNotEmpty(itemName, this.itemType.toLowerCase() + " name");
        Drop.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        Drop.validateNotKeyWord(itemName, String.format("The " + this.itemType.toLowerCase() + " name '%s' is not allowed because it is a reserved keyword", itemName));
        this.itemName = itemName;
        this.keyspaceName = Optional.fromNullable(keyspaceName);
    }

    Drop(String itemName, DroppedItem itemType) {
        this.itemType = itemType.name();
        Drop.validateNotEmpty(itemName, this.itemType.toLowerCase() + " name");
        Drop.validateNotKeyWord(itemName, String.format("The " + this.itemType.toLowerCase() + " name '%s' is not allowed because it is a reserved keyword", itemName));
        this.itemName = itemName;
    }

    public Drop ifExists() {
        this.ifExists = true;
        return this;
    }

    @Override
    public String buildInternal() {
        StringBuilder dropStatement = new StringBuilder("DROP " + this.itemType + " ");
        if (this.ifExists) {
            dropStatement.append("IF EXISTS ");
        }
        if (this.keyspaceName.isPresent()) {
            dropStatement.append(this.keyspaceName.get()).append(".");
        }
        dropStatement.append(this.itemName);
        return dropStatement.toString();
    }

    public String build() {
        return this.buildInternal();
    }

    static enum DroppedItem {
        TABLE,
        TYPE,
        INDEX;

    }
}

