/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.deser.impl;

import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.core.JsonParser;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.core.JsonToken;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import cz.o2.proxima.cassandra.shaded.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.HashSet;

public class BeanAsArrayDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;

    public BeanAsArrayDeserializer(BeanDeserializerBase delegate, SettableBeanProperty[] ordered) {
        super(delegate);
        this._delegate = delegate;
        this._orderedProperties = ordered;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return this._delegate.unwrappingDeserializer(unwrapper);
    }

    @Override
    public BeanAsArrayDeserializer withObjectIdReader(ObjectIdReader oir) {
        return new BeanAsArrayDeserializer(this._delegate.withObjectIdReader(oir), this._orderedProperties);
    }

    @Override
    public BeanAsArrayDeserializer withIgnorableProperties(HashSet<String> ignorableProps) {
        return new BeanAsArrayDeserializer(this._delegate.withIgnorableProperties(ignorableProps), this._orderedProperties);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            return this._deserializeFromNonArray(p, ctxt);
        }
        if (!this._vanillaProcessing) {
            return this._deserializeNonVanilla(p, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean);
        SettableBeanProperty[] props = this._orderedProperties;
        int i = 0;
        int propCount = props.length;
        while (true) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            if (i == propCount) break;
            SettableBeanProperty prop = props[i];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, bean, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            ++i;
        }
        if (!this._ignoreAllUnknown) {
            throw ctxt.mappingException("Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        while (p.nextToken() != JsonToken.END_ARRAY) {
            p.skipChildren();
        }
        return bean;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        p.setCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        SettableBeanProperty[] props = this._orderedProperties;
        int i = 0;
        int propCount = props.length;
        while (true) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            if (i == propCount) break;
            SettableBeanProperty prop = props[i];
            if (prop != null) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, bean, prop.getName(), ctxt);
                }
            } else {
                p.skipChildren();
            }
            ++i;
        }
        if (!this._ignoreAllUnknown) {
            throw ctxt.mappingException("Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        while (p.nextToken() != JsonToken.END_ARRAY) {
            p.skipChildren();
        }
        return bean;
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this._deserializeFromNonArray(p, ctxt);
    }

    protected Object _deserializeNonVanilla(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._nonStandardCreation) {
            return this._deserializeWithCreator(p, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.setCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        SettableBeanProperty[] props = this._orderedProperties;
        int i = 0;
        int propCount = props.length;
        while (true) {
            if (p.nextToken() == JsonToken.END_ARRAY) {
                return bean;
            }
            if (i == propCount) break;
            SettableBeanProperty prop = props[i];
            ++i;
            if (prop != null && (activeView == null || prop.visibleInView(activeView))) {
                try {
                    prop.deserializeAndSet(p, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, bean, prop.getName(), ctxt);
                }
                continue;
            }
            p.skipChildren();
        }
        if (!this._ignoreAllUnknown) {
            throw ctxt.mappingException("Unexpected JSON values; expected at most %d properties (in JSON Array)", propCount);
        }
        while (p.nextToken() != JsonToken.END_ARRAY) {
            p.skipChildren();
        }
        return bean;
    }

    protected Object _deserializeWithCreator(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(p, ctxt);
        }
        if (this._beanType.isAbstract()) {
            throw JsonMappingException.from(p, "Can not instantiate abstract type " + this._beanType + " (need to add/enable type information?)");
        }
        throw JsonMappingException.from(p, "No suitable constructor found for type " + this._beanType + ": can not instantiate from JSON object (need to add/enable type information?)");
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser p, DeserializationContext ctxt) throws IOException {
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        SettableBeanProperty[] props = this._orderedProperties;
        int propCount = props.length;
        int i = 0;
        Object bean = null;
        while (p.nextToken() != JsonToken.END_ARRAY) {
            block17: {
                SettableBeanProperty prop;
                SettableBeanProperty settableBeanProperty = prop = i < propCount ? props[i] : null;
                if (prop == null) {
                    p.skipChildren();
                } else if (bean != null) {
                    try {
                        prop.deserializeAndSet(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, bean, prop.getName(), ctxt);
                    }
                } else {
                    String propName = prop.getName();
                    SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                    if (creatorProp != null) {
                        if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p, ctxt))) {
                            try {
                                bean = creator.build(ctxt, buffer);
                            }
                            catch (Exception e) {
                                this.wrapAndThrow((Throwable)e, this._beanType.getRawClass(), propName, ctxt);
                                break block17;
                            }
                            p.setCurrentValue(bean);
                            if (bean.getClass() != this._beanType.getRawClass()) {
                                throw ctxt.mappingException("Can not support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type %s, actual type %s", this._beanType.getRawClass().getName(), bean.getClass().getName());
                            }
                        }
                    } else if (!buffer.readIdProperty(propName)) {
                        buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                    }
                }
            }
            ++i;
        }
        if (bean == null) {
            try {
                bean = creator.build(ctxt, buffer);
            }
            catch (Exception e) {
                this.wrapInstantiationProblem(e, ctxt);
                return null;
            }
        }
        return bean;
    }

    protected Object _deserializeFromNonArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        throw ctxt.mappingException("Can not deserialize a POJO (of type %s) from non-Array representation (token: %s): type/property designed to be serialized as JSON Array", new Object[]{this._beanType.getRawClass().getName(), p.getCurrentToken()});
    }
}

